/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.CanOpenNumericSensor;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderCarrierController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuLoaderPlutoGateway
extends SimuPlutoGateway {
    private LoaderModule loader;
    private SimuLoaderCarrierController carrierController;
    private CanOpenNumericSensor lockSensor1;
    private CanOpenNumericSensor unlockSensor1;
    private CanOpenNumericSensor lockSensor2;
    private CanOpenNumericSensor unlockSensor2;
    private CanOpenNumericSensor lockSensor3;
    private CanOpenNumericSensor unlockSensor3;
    private CanOpenNumericSensor lockSensor4;
    private CanOpenNumericSensor unlockSensor4;
    private CanOpenNumericSensor loaderOnCameraSensor0;
    private CanOpenNumericSensor loaderOnCameraSensor1;
    private CanOpenNumericSensor filterPresenceSensor0;
    private CanOpenNumericSensor filterPresenceSensor1;
    private CanOpenNumericSensor storagePositionSensor0;
    private CanOpenNumericSensor handoffPositionSensor0;
    private CanOpenNumericSensor storagePositionSensor1;
    private CanOpenNumericSensor handoffPositionSensor1;

    public SimuLoaderPlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.lockSensor1 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderLockSensor1"));
        this.lockSensor2 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderLockSensor2"));
        this.lockSensor3 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderLockSensor3"));
        this.lockSensor4 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderLockSensor4"));
        this.unlockSensor1 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderUnlockSensor1"));
        this.unlockSensor2 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderUnlockSensor2"));
        this.unlockSensor3 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderUnlockSensor3"));
        this.unlockSensor4 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderUnlockSensor4"));
        this.loaderOnCameraSensor0 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderOnCameraSensor0"));
        this.loaderOnCameraSensor1 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderOnCameraSensor1"));
        this.filterPresenceSensor0 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderFilterPresenceSensor0"));
        this.filterPresenceSensor1 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderFilterPresenceSensor1"));
        this.storagePositionSensor0 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderStoragePositionSensor0"));
        this.storagePositionSensor1 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderStoragePositionSensor1"));
        this.handoffPositionSensor0 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderHandoffPositionSensor0"));
        this.handoffPositionSensor1 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderHandoffPositionSensor1"));
        this.carrierController = (SimuLoaderCarrierController)lookup.getComponentByName("carrierController");
        this.loader = (LoaderModule)lookup.getComponentByName("loader");
        this.simulateLoaderClampIsLocked();
        this.simulateLoaderIsConnectedOnCamera();
        this.simulateFilterIsOnLoader();
        this.simulateLoaderCarrierIsAtStorage();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsLocked() {
        this.simulateHookIsLocked(this.lockSensor1, this.unlockSensor1);
        this.simulateHookIsLocked(this.lockSensor2, this.unlockSensor2);
        this.simulateHookIsLocked(this.lockSensor3, this.unlockSensor3);
        this.simulateHookIsLocked(this.lockSensor4, this.unlockSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsUnLocked() {
        this.simulateHookIsUnlocked(this.lockSensor1, this.unlockSensor1);
        this.simulateHookIsUnlocked(this.lockSensor2, this.unlockSensor2);
        this.simulateHookIsUnlocked(this.lockSensor3, this.unlockSensor3);
        this.simulateHookIsUnlocked(this.lockSensor4, this.unlockSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsInTravel() {
        this.simulateHookIsInTravel(this.lockSensor1, this.unlockSensor1);
        this.simulateHookIsInTravel(this.lockSensor2, this.unlockSensor2);
        this.simulateHookIsInTravel(this.lockSensor3, this.unlockSensor3);
        this.simulateHookIsInTravel(this.lockSensor4, this.unlockSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsLocked(CanOpenNumericSensor lockSensor, CanOpenNumericSensor unlockSensor) {
        this.replaceDigitalValues(lockSensor, "1");
        this.replaceDigitalValues(unlockSensor, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsUnlocked(CanOpenNumericSensor lockSensor, CanOpenNumericSensor unlockSensor) {
        this.replaceDigitalValues(lockSensor, "0");
        this.replaceDigitalValues(unlockSensor, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsInTravel(CanOpenNumericSensor lockSensor, CanOpenNumericSensor unlockSensor) {
        this.replaceDigitalValues(lockSensor, "0");
        this.replaceDigitalValues(unlockSensor, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsConnectedOnCamera() {
        this.replaceDigitalValues(this.loaderOnCameraSensor0, "1");
        this.replaceDigitalValues(this.loaderOnCameraSensor1, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsNotConnectedOnCamera() {
        this.replaceDigitalValues(this.loaderOnCameraSensor0, "0");
        this.replaceDigitalValues(this.loaderOnCameraSensor1, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsOnLoader() {
        this.replaceDigitalValues(this.filterPresenceSensor0, "1");
        this.replaceDigitalValues(this.filterPresenceSensor1, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsNotOnLoader() {
        this.replaceDigitalValues(this.filterPresenceSensor0, "0");
        this.replaceDigitalValues(this.filterPresenceSensor1, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsAtStorage() {
        this.replaceDigitalValues(this.storagePositionSensor0, "1");
        this.replaceDigitalValues(this.storagePositionSensor1, "1");
        this.replaceDigitalValues(this.handoffPositionSensor0, "0");
        this.replaceDigitalValues(this.handoffPositionSensor1, "0");
        this.carrierController.setPosition(this.loader.getCarrier().getStoragePosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsAtHandoff() {
        this.replaceDigitalValues(this.storagePositionSensor0, "0");
        this.replaceDigitalValues(this.storagePositionSensor1, "0");
        this.replaceDigitalValues(this.handoffPositionSensor0, "1");
        this.replaceDigitalValues(this.handoffPositionSensor1, "1");
        this.carrierController.setPosition(this.loader.getCarrier().getHandoffPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsInTravel() {
        this.replaceDigitalValues(this.storagePositionSensor0, "0");
        this.replaceDigitalValues(this.storagePositionSensor1, "0");
        this.replaceDigitalValues(this.handoffPositionSensor0, "0");
        this.replaceDigitalValues(this.handoffPositionSensor1, "0");
    }
}

