/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.io.Serializable;
import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public abstract class SimuEPOSControllerModule
extends CanOpenDevice
implements EPOSController {
    protected boolean turnedOff;
    private boolean enabled;
    private boolean enabledToPublish;
    protected EPOSEnumerations.EposMode mode;
    protected int targetPosition;
    protected int position;
    protected int ssiPosition;
    protected int targetCurrent;
    protected int actualCurrent;
    @ConfigurationParameter
    private final Map<String, Integer> paramsForHoming;
    @ConfigurationParameter
    private final Map<String, Integer> paramsForProfilePosition;
    @ConfigurationParameter
    private final Map<String, Integer> paramsForCurrent;

    public SimuEPOSControllerModule(String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB);
        this.paramsForHoming = paramsForHoming;
        this.paramsForProfilePosition = paramsForProfilePosition;
        this.paramsForCurrent = paramsForCurrent;
        this.position = 0;
        this.turnedOff = false;
        this.mode = EPOSEnumerations.EposMode.PROFILE_POSITION;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="For simulator only : Update position with a position given as argument.")
    public void setPosition(int actualPosition) {
        this.position = actualPosition;
    }

    @Override
    public boolean isEnabledToPublish() {
        return this.enabledToPublish;
    }

    @Override
    public boolean isTurnedOff() {
        return this.turnedOff;
    }

    @Override
    public EPOSEnumerations.EposMode getMode() {
        return this.mode;
    }

    @Override
    public Map<String, Integer> getParamsForHoming() {
        return this.paramsForHoming;
    }

    @Override
    public Map<String, Integer> getParamsForProfilePosition() {
        return this.paramsForProfilePosition;
    }

    @Override
    public Map<String, Integer> getParamsForCurrent() {
        return this.paramsForCurrent;
    }

    @Override
    public boolean isParametersOK() {
        return true;
    }

    @Override
    public String initializeAndCheckHardware() {
        super.initializeAndCheckHardware();
        this.publishData();
        return this.getName() + " is INITIALIZED.";
    }

    public String changeMode(String modeInString) {
        EPOSEnumerations.EposMode newMode = EPOSEnumerations.EposMode.valueOf((String)modeInString.trim().toUpperCase());
        return this.changeMode(newMode);
    }

    @Override
    public String changeMode(EPOSEnumerations.EposMode newMode) {
        this.mode = newMode;
        return this.getName() + " mode changed to=" + newMode.toString();
    }

    @Override
    public void defineAbsolutePosition(int position) {
        this.position = position;
    }

    @Override
    public void disable() {
        this.enabled = true;
        this.enabledToPublish = true;
    }

    @Override
    public void writeParameters(EPOSEnumerations.EposMode mode) {
    }

    @Override
    public String writeParameterInHexa(EPOSEnumerations.Parameter parameter, String string) {
        return this.getName() + " " + parameter.toString() + " set to value in HEXA=" + string;
    }

    public String writeParameter(EPOSEnumerations.Parameter param, int value) {
        return "OK";
    }

    @Override
    public Object saveParameters() {
        return "OK";
    }

    @Override
    public void writeTargetPosition(int position) {
        this.position = position;
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) {
    }

    @Override
    public void writeCurrent(int aValue) {
        this.turnedOff = false;
        this.actualCurrent = aValue;
    }

    @Override
    public String off() {
        this.turnedOff = true;
        return this.getName() + " is OFF";
    }

    @Override
    public boolean isTargetPositionReached(int targetPosition) {
        return this.position == targetPosition;
    }

    @Override
    public int readPosition() {
        return this.position;
    }

    @Override
    public int readSSIPosition() {
        return this.ssiPosition;
    }

    @Override
    public String enable() {
        this.enabled = true;
        return this.getName() + "IS ENABLED";
    }

    @Override
    public int readCurrent() {
        return this.actualCurrent;
    }

    @Override
    public EPOSEnumerations.EposMode readMode() {
        return this.mode;
    }

    @Override
    public int getMaxCurrent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMinCurrent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMaxSpeed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMaxPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMinPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void quickStop() {
        FCSCst.FCSLOG.finest((Object)(this.getName() + " quickStop done."));
    }

    @Override
    public int readNumberOfErrors() {
        return 0;
    }

    @Override
    public String readErrorRegister() {
        return null;
    }

    @Override
    public String[] readErrorHistory() {
        return new String[0];
    }

    @Override
    public String displayErrorHistory() {
        return "No ERROR";
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() {
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clear faults on the controller.")
    public void faultReset() {
        this.writeControlWord("80");
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.getName(), (Object)"faultReset"));
        this.inError = false;
        this.errorRegister = "NO ERROR";
        this.errorHistory = new String[0];
        this.publishData();
    }

    @Override
    public int readProfileVelocity() {
        return 0;
    }

    @Override
    public String readParameters(EPOSEnumerations.EposMode mode) {
        return this.getName() + ":no parameter to read.";
    }

    @Override
    public void checkParameters(String modeInString) throws HardwareException {
    }

    @Override
    public void checkParameters(EPOSEnumerations.EposMode aMode) throws HardwareException {
    }

    @Override
    public void writeControlWord(String f) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + "writeControlWord :" + f));
    }

    @Override
    public String shutdown() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " is SHUTDOWN"));
        return this.getName() + " is SHUTDOWN";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean checkTargetReached() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void releaseBrake() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " brake is released."));
    }

    @Override
    public void switchOnEnableOperation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void activateBrake() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " brake is activated."));
    }

    public StatusDataPublishedByEPOSController getStatusData() {
        return FcsUtils.createStatusDataPublishedByEPOSController(this);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="refreshGUI", description="Publish data for the controller on the status bus.")
    public void publishData() {
        StatusDataPublishedByEPOSController status = this.getStatusData();
        KeyValueData kvd = new KeyValueData(this.getName(), (Serializable)status);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }
}

