/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Observable;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenSensor14bits;

public class SimuCarouselClampFilterPresenceSensor
extends SimuCanOpenSensor14bits {
    public SimuCarouselClampFilterPresenceSensor(String adcName, int numOfAnalogInput) {
        super(adcName, numOfAnalogInput);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.simulateFilterIsLockable();
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        FCSCst.FCSLOG.finest((Object)(this.getName() + " :old Value=" + this.printValue()));
        if (this.isAtStandby()) {
            FCSCst.FCSLOG.finest((Object)(this.getName() + " is AT STANDBY."));
        }
        if (this.getSubsystem().isInState((Enum)PhaseState.OPERATIONAL) && this.isAtStandby() && this.autochanger.isHoldingFilter()) {
            if ((Integer)v.getValue() > 500) {
                this.simulateNoFilter();
            } else if ((Integer)v.getValue() == 0) {
                this.simulateFilterIsLockable();
            }
        }
        FCSCst.FCSLOG.finest((Object)(this.getName() + " :new Value=" + this.printValue()));
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsLockable() {
        this.setNewRange(this.clamp.getFilterPresenceValueA(), this.clamp.getFilterPresenceValueB());
        this.updateFakePDOStorage();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsNotLockable() {
        this.setNewRange(this.clamp.getFilterPresenceValueB(), this.clamp.getFilterPresenceValueC());
        this.updateFakePDOStorage();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateNoFilter() {
        this.setNewRange(this.clamp.getFilterPresenceValueC(), Short.MAX_VALUE);
        this.updateFakePDOStorage();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsInError() {
        this.setNewRange(0, this.clamp.getFilterPresenceValueA());
        this.updateFakePDOStorage();
    }
}

