/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutoChangerTwoTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerTruckModule;
import org.lsst.ccs.subsystems.fcs.CanOpenNumericSensor;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLatchController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLinearRailController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerOnlineClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuFilterIDPlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuAutochangerPlutoGateway
extends SimuPlutoGateway
implements SimuFilterIDPlutoGatewayInterface {
    private FilterIdentificator filterIdentificator;
    private FilterHolder carousel;
    private AutoChangerModule autochanger;
    private AutoChangerTwoTrucksModule trucks;
    private SimuAutochangerLinearRailController trucksController;
    private SimuAutochangerLinearRailController trucksSlaveController;
    private SimuAutochangerLatchController latchXminusController;
    private SimuAutochangerLatchController latchXplusController;
    private SimuAutochangerOnlineClampController onlineClampXminusController;
    private SimuAutochangerOnlineClampController onlineClampXplusController;
    private SimuAutochangerOnlineClampController onlineClampYminusController;
    private AutochangerTruckModule acTruckXminus;
    private AutochangerTruckModule acTruckXplus;
    private CanOpenNumericSensor loaderConnectedSensor0;
    private CanOpenNumericSensor loaderConnectedSensor1;
    private CanOpenNumericSensor lockSensorLatchXminus;
    private CanOpenNumericSensor unlockSensorLatchXminus;
    private CanOpenNumericSensor filterPresenceSensorLatchXminus;
    private CanOpenNumericSensor lockSensorLatchXplus;
    private CanOpenNumericSensor unlockSensorLatchXplus;
    private CanOpenNumericSensor filterPresenceSensorLatchXplus;
    private CanOpenNumericSensor lockSensorBLatchXminus;
    private CanOpenNumericSensor unlockSensorBLatchXminus;
    private CanOpenNumericSensor filterPresenceSensorBLatchXminus;
    private CanOpenNumericSensor lockSensorBLatchXplus;
    private CanOpenNumericSensor unlockSensorBLatchXplus;
    private CanOpenNumericSensor filterPresenceSensorBLatchXplus;
    private CanOpenNumericSensor onlineClampXminusLockSensor;
    private CanOpenNumericSensor onlineClampXminusCLockSensor;
    private CanOpenNumericSensor onlineClampXminusUnlockSensor;
    private CanOpenNumericSensor onlineClampXminusCUnlockSensor;
    private CanOpenNumericSensor onlineClampXplusLockSensor;
    private CanOpenNumericSensor onlineClampXplusCLockSensor;
    private CanOpenNumericSensor onlineClampXplusUnlockSensor;
    private CanOpenNumericSensor onlineClampXplusCUnlockSensor;
    private CanOpenNumericSensor onlineClampYminusLockSensor;
    private CanOpenNumericSensor onlineClampYminusCLockSensor;
    private CanOpenNumericSensor onlineClampYminusUnlockSensor;
    private CanOpenNumericSensor onlineClampYminusCUnlockSensor;

    public SimuAutochangerPlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public List<CanOpenNumericSensor> getFilterIDSensors() {
        return this.filterIdentificator.getFilterIDSensors();
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.filterIdentificator = (FilterIdentificator)((Object)lookup.getComponentByName("filterIdentificator"));
        this.carousel = (FilterHolder)lookup.getComponentByName("carousel");
        this.acTruckXminus = (AutochangerTruckModule)lookup.getComponentByName("acTruckXminus");
        this.acTruckXplus = (AutochangerTruckModule)lookup.getComponentByName("acTruckXplus");
        this.loaderConnectedSensor0 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderConnectedSensor0"));
        this.loaderConnectedSensor1 = (CanOpenNumericSensor)((Object)lookup.getComponentByName("loaderConnectedSensor1"));
        this.trucksController = (SimuAutochangerLinearRailController)lookup.getComponentByName("linearRailMasterController");
        this.trucksSlaveController = (SimuAutochangerLinearRailController)lookup.getComponentByName("linearRailSlaveController");
        this.trucks = (AutoChangerTwoTrucksModule)lookup.getComponentByName("autochangerTrucks");
        this.lockSensorLatchXminus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("lockSensorLatchXminus"));
        this.unlockSensorLatchXminus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("unlockSensorLatchXminus"));
        this.filterPresenceSensorLatchXminus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("filterEngagedSensorLatchXminus"));
        this.lockSensorLatchXplus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("lockSensorLatchXplus"));
        this.unlockSensorLatchXplus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("unlockSensorLatchXplus"));
        this.filterPresenceSensorLatchXplus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("filterEngagedSensorLatchXplus"));
        this.lockSensorBLatchXminus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("lockSensorBLatchXminus"));
        this.unlockSensorBLatchXminus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("unlockSensorBLatchXminus"));
        this.filterPresenceSensorBLatchXminus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("filterEngagedSensorBLatchXminus"));
        this.lockSensorBLatchXplus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("lockSensorBLatchXplus"));
        this.unlockSensorBLatchXplus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("unlockSensorBLatchXplus"));
        this.filterPresenceSensorBLatchXplus = (CanOpenNumericSensor)((Object)lookup.getComponentByName("filterEngagedSensorBLatchXplus"));
        this.latchXminusController = (SimuAutochangerLatchController)lookup.getComponentByName("latchXminusController");
        this.latchXplusController = (SimuAutochangerLatchController)lookup.getComponentByName("latchXplusController");
        this.onlineClampXminusLockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXminusLockSensor"));
        this.onlineClampXminusCLockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXminusCLockSensor"));
        this.onlineClampXminusUnlockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXminusUnlockSensor"));
        this.onlineClampXminusCUnlockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXminusCUnlockSensor"));
        this.onlineClampXplusLockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXplusLockSensor"));
        this.onlineClampXplusCLockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXplusCLockSensor"));
        this.onlineClampXplusUnlockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXplusUnlockSensor"));
        this.onlineClampXplusCUnlockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampXplusCUnlockSensor"));
        this.onlineClampYminusLockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampYminusLockSensor"));
        this.onlineClampYminusCLockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampYminusCLockSensor"));
        this.onlineClampYminusUnlockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampYminusUnlockSensor"));
        this.onlineClampYminusCUnlockSensor = (CanOpenNumericSensor)((Object)lookup.getComponentByName("onlineClampYminusCUnlockSensor"));
        this.simulateAutochangerTrucksIsAtHandoff();
        this.simulateAutochangerIsEmpty();
        this.simulateAutochangerLatchesAreUnlocked();
        this.simulateAutochangerOnlineClampsAreUnlocked();
    }

    private void simulateACTruckIsAtHandoff(AutochangerTruckModule truck) {
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensor(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensorB(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensorB(), "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsAtHandoff() {
        FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksIsAtHandoff");
        this.simulateACTruckIsAtHandoff(this.acTruckXminus);
        this.simulateACTruckIsAtHandoff(this.acTruckXplus);
        this.trucksController.setPosition(this.trucks.getHandoffPosition());
        this.trucksController.setSsiPosition(this.trucks.getEncoderRibbonMinValue() + this.trucks.getHandoffPosition());
        this.trucksSlaveController.setPosition(this.trucks.getHandoffPosition());
        this.trucksSlaveController.setSsiPosition(this.trucks.getEncoderRibbonMinValue() + this.trucks.getHandoffPosition());
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)this.trucks.getHandoffPosition()));
    }

    private void simulateACTruckIsOnline(AutochangerTruckModule truck) {
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensor(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensorB(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensorB(), "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsOnline() {
        this.simulateACTruckIsOnline(this.acTruckXminus);
        this.simulateACTruckIsOnline(this.acTruckXplus);
        this.trucksController.setPosition(this.trucks.getOnlinePosition());
        this.trucksController.setSsiPosition(this.trucks.getEncoderRibbonMinValue() + this.trucks.getOnlinePosition());
        this.trucksSlaveController.setPosition(this.trucks.getOnlinePosition());
        this.trucksSlaveController.setSsiPosition(this.trucks.getEncoderRibbonMinValue() + this.trucks.getOnlinePosition());
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)this.trucks.getOnlinePosition()));
    }

    private void simulateACTruckIsAtStandby(AutochangerTruckModule truck) {
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensor(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensorB(), "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsAtStandby() {
        this.simulateACTruckIsAtStandby(this.acTruckXminus);
        this.simulateACTruckIsAtStandby(this.acTruckXplus);
        this.trucksController.setSsiPosition(this.trucks.getEncoderRibbonMinValue());
        this.trucksController.setPosition(this.trucks.getStandbyPosition());
        this.trucksSlaveController.setSsiPosition(this.trucks.getEncoderRibbonMinValue());
        this.trucksSlaveController.setPosition(this.trucks.getStandbyPosition());
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)this.trucks.getStandbyPosition()));
        this.simulateFilterIDAtStandby();
    }

    private void simulateACTruckIsInTravel(AutochangerTruckModule truck) {
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getHandoffPositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getOnlinePositionSensorB(), "1");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensor(), "0");
        this.replaceDigitalValues((CanOpenNumericSensor)truck.getStandbyPositionSensorB(), "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsInTravel() {
        this.simulateACTruckIsInTravel(this.acTruckXminus);
        this.simulateACTruckIsInTravel(this.acTruckXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsConnected() {
        this.replaceDigitalValues(this.loaderConnectedSensor0, "1");
        this.replaceDigitalValues(this.loaderConnectedSensor1, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsDisconnected() {
        this.replaceDigitalValues(this.loaderConnectedSensor0, "0");
        this.replaceDigitalValues(this.loaderConnectedSensor1, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsOnAutochanger() {
        this.replaceDigitalValues(this.filterPresenceSensorLatchXminus, "1");
        this.replaceDigitalValues(this.filterPresenceSensorLatchXplus, "1");
        this.replaceDigitalValues(this.filterPresenceSensorBLatchXminus, "0");
        this.replaceDigitalValues(this.filterPresenceSensorBLatchXplus, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerIsEmpty() {
        this.replaceDigitalValues(this.filterPresenceSensorLatchXminus, "0");
        this.replaceDigitalValues(this.filterPresenceSensorLatchXplus, "0");
        this.replaceDigitalValues(this.filterPresenceSensorBLatchXminus, "1");
        this.replaceDigitalValues(this.filterPresenceSensorBLatchXplus, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchesAreLocked() {
        this.replaceDigitalValues(this.lockSensorLatchXminus, "1");
        this.replaceDigitalValues(this.unlockSensorLatchXminus, "0");
        this.replaceDigitalValues(this.lockSensorLatchXplus, "1");
        this.replaceDigitalValues(this.unlockSensorLatchXplus, "0");
        this.replaceDigitalValues(this.lockSensorBLatchXminus, "0");
        this.replaceDigitalValues(this.unlockSensorBLatchXminus, "1");
        this.replaceDigitalValues(this.lockSensorBLatchXplus, "0");
        this.replaceDigitalValues(this.unlockSensorBLatchXplus, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchesAreUnlocked() {
        this.replaceDigitalValues(this.lockSensorLatchXminus, "0");
        this.replaceDigitalValues(this.unlockSensorLatchXminus, "1");
        this.replaceDigitalValues(this.lockSensorLatchXplus, "0");
        this.replaceDigitalValues(this.unlockSensorLatchXplus, "1");
        this.replaceDigitalValues(this.lockSensorBLatchXminus, "1");
        this.replaceDigitalValues(this.unlockSensorBLatchXminus, "0");
        this.replaceDigitalValues(this.lockSensorBLatchXplus, "1");
        this.replaceDigitalValues(this.unlockSensorBLatchXplus, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsLocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.replaceDigitalValues(this.lockSensorLatchXminus, "1");
            this.replaceDigitalValues(this.unlockSensorLatchXminus, "0");
            this.replaceDigitalValues(this.lockSensorBLatchXminus, "0");
            this.replaceDigitalValues(this.unlockSensorBLatchXminus, "1");
        } else if (latchName.contains("Xplus")) {
            this.replaceDigitalValues(this.lockSensorLatchXplus, "1");
            this.replaceDigitalValues(this.unlockSensorLatchXplus, "0");
            this.replaceDigitalValues(this.lockSensorBLatchXplus, "0");
            this.replaceDigitalValues(this.unlockSensorBLatchXplus, "1");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsUnlocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.replaceDigitalValues(this.lockSensorLatchXminus, "0");
            this.replaceDigitalValues(this.unlockSensorLatchXminus, "1");
            this.replaceDigitalValues(this.lockSensorBLatchXminus, "1");
            this.replaceDigitalValues(this.unlockSensorBLatchXminus, "0");
        } else if (latchName.contains("Xplus")) {
            this.replaceDigitalValues(this.lockSensorLatchXplus, "0");
            this.replaceDigitalValues(this.unlockSensorLatchXplus, "1");
            this.replaceDigitalValues(this.lockSensorBLatchXplus, "1");
            this.replaceDigitalValues(this.unlockSensorBLatchXplus, "0");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLockSensorsInError(String latchName) {
        if (latchName.contains("Xminus")) {
            this.replaceDigitalValues(this.lockSensorLatchXminus, "1");
            this.replaceDigitalValues(this.lockSensorBLatchXminus, "1");
        } else if (latchName.contains("Xplus")) {
            this.replaceDigitalValues(this.lockSensorLatchXplus, "1");
            this.replaceDigitalValues(this.lockSensorBLatchXplus, "1");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreLocked() {
        this.simulateAutochangerOnlineClampXminusIsLocked();
        this.simulateAutochangerOnlineClampXplusIsLocked();
        this.simulateAutochangerOnlineClampYminusIsLocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreUnlocked() {
        this.simulateAutochangerOnlineClampXminusIsUnlocked();
        this.simulateAutochangerOnlineClampXplusIsUnlocked();
        this.simulateAutochangerOnlineClampYminusIsUnlocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsLocked(CanOpenNumericSensor lockSensor, CanOpenNumericSensor lockSensorC, CanOpenNumericSensor unlockSensor, CanOpenNumericSensor unlockSensorC) {
        this.replaceDigitalValues(lockSensor, "1");
        this.replaceDigitalValues(lockSensorC, "0");
        this.replaceDigitalValues(unlockSensor, "0");
        this.replaceDigitalValues(unlockSensorC, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsUnlocked(CanOpenNumericSensor lockSensor, CanOpenNumericSensor lockSensorC, CanOpenNumericSensor unlockSensor, CanOpenNumericSensor unlockSensorC) {
        this.replaceDigitalValues(lockSensor, "0");
        this.replaceDigitalValues(lockSensorC, "1");
        this.replaceDigitalValues(unlockSensor, "1");
        this.replaceDigitalValues(unlockSensorC, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXminusIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampXminusLockSensor, this.onlineClampXminusCLockSensor, this.onlineClampXminusUnlockSensor, this.onlineClampXminusCUnlockSensor);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXminusIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.onlineClampXminusLockSensor, this.onlineClampXminusCLockSensor, this.onlineClampXminusUnlockSensor, this.onlineClampXminusCUnlockSensor);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXplusIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampXplusLockSensor, this.onlineClampXplusCLockSensor, this.onlineClampXplusUnlockSensor, this.onlineClampXplusCUnlockSensor);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXplusIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.onlineClampXplusLockSensor, this.onlineClampXplusCLockSensor, this.onlineClampXplusUnlockSensor, this.onlineClampXplusCUnlockSensor);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampYminusIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampYminusLockSensor, this.onlineClampYminusCLockSensor, this.onlineClampYminusUnlockSensor, this.onlineClampYminusCUnlockSensor);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampYminusIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.onlineClampYminusLockSensor, this.onlineClampYminusCLockSensor, this.onlineClampYminusUnlockSensor, this.onlineClampYminusCUnlockSensor);
    }

    private void simulateFilterIDAtStandby() {
        if (this.carousel instanceof CarouselModule && ((CarouselModule)this.carousel).getFilterAtStandby() != null) {
            this.simulateFilterID(((CarouselModule)this.carousel).getFilterAtStandby().getFilterID());
        }
    }

    public void start() {
        boolean aFilterIsOnTrucks = false;
        this.autochanger = (AutoChangerModule)this.getComponentLookup().getComponentByName("autochanger");
        FilterManager filterManager = (FilterManager)((Object)this.getComponentLookup().getComponentByName("filterManager"));
        SortedMap<String, Filter> filtersMap = filterManager.getFiltersMapByName();
        for (Map.Entry entry : filtersMap.entrySet()) {
            Filter filter = (Filter)entry.getValue();
            if (!filter.isOnAutoChanger()) continue;
            FCSCst.FCSLOG.fine((Object)(filter.getName() + " is on autochanger trucks."));
            aFilterIsOnTrucks = true;
            this.autochanger.setFilterOnTrucksID(filter.getFilterID());
        }
        if (aFilterIsOnTrucks) {
            this.simulateAutochangerTrucksIsOnline();
            this.simulateFilterIsOnAutochanger();
            this.simulateAutochangerLatchesAreLocked();
            this.simulateAutochangerOnlineClampsAreLocked();
        } else {
            this.simulateAutochangerTrucksIsAtHandoff();
            this.simulateAutochangerIsEmpty();
            this.simulateAutochangerLatchesAreUnlocked();
            this.simulateAutochangerOnlineClampsAreUnlocked();
        }
    }
}

