/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.AutoChangerTwoTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

public class SimuAutochangerLinearRailController
extends SimuEPOSControllerModule {
    @ConfigurationParameter(isFinal=true)
    private String plutoGatewayName;
    private AutoChangerTwoTrucksModule trucks;
    private SimuAutochangerPlutoGateway plutoGateway;
    private FilterHolder carousel;
    private AutochangerTwoLatches latches;
    private SimuAutochangerLinearRailController slaveController;

    public SimuAutochangerLinearRailController(String nodeID, String serialNB, String plutoGatewayName, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.plutoGatewayName = plutoGatewayName;
    }

    public void setSsiPosition(int ssiPosition) {
        this.ssiPosition = ssiPosition;
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.trucks = (AutoChangerTwoTrucksModule)lookup.getComponentByName("autochangerTrucks");
        this.plutoGateway = (SimuAutochangerPlutoGateway)lookup.getComponentByName(this.plutoGatewayName);
        this.carousel = (FilterHolder)lookup.getComponentByName("carousel");
        this.latches = (AutochangerTwoLatches)lookup.getComponentByName("latches");
        this.setSsiPosition(this.trucks.getEncoderRibbonMinValue());
        this.slaveController = (SimuAutochangerLinearRailController)lookup.getComponentByName("linearRailSlaveController");
    }

    @Override
    public void writeTargetPosition(int positionToReached) {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSCst.FCSLOG.debug((Object)"loader trucks is moving.");
        FCSCst.FCSLOG.debug((Object)(this.getName() + "=>position intitiale=" + this.position));
        int stepsNB = Math.abs(this.targetPosition - this.position) > 10000 ? 20 : 5;
        int step = (this.targetPosition - this.position) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            try {
                this.position = positionInitiale + i * step;
                this.slaveController.setPosition(this.position);
                this.trucks.updatePosition();
                FCSCst.FCSLOG.info((Object)("trucks Position=" + this.trucks.readPosition()));
                if (positionInitiale > 0 && this.position <= 100 && this.carousel.isHoldingFilter()) {
                    FCSCst.FCSLOG.info((Object)"simulateFilterIsOnAutochanger");
                    this.plutoGateway.simulateFilterIsOnAutochanger();
                } else if (positionInitiale == 0 && this.latches.isUnlocked() && this.position > 100 && this.position < 2 * step) {
                    FCSCst.FCSLOG.info((Object)"simulateAutochangerIsEmpty");
                    this.plutoGateway.simulateAutochangerIsEmpty();
                }
                this.trucks.updateStateWithSensors();
                this.trucks.publishData();
                FCSCst.FCSLOG.debug((Object)(this.getName() + "i=" + i + ",position=" + this.position));
                try {
                    Thread.sleep(250L);
                    if (!this.trucks.getHaltRequired().get()) continue;
                    FCSCst.FCSLOG.debug((Object)(this.getName() + " STOP simulated trucks motion."));
                    return;
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)ex);
                    throw new RejectedCommandException(this.getName() + " sleep was interrupted.");
                }
            }
            catch (FcsHardwareException ex) {
                FCSCst.FCSLOG.error((Object)ex);
                throw new RejectedCommandException(ex.getMessage());
            }
        }
        this.position = this.targetPosition;
        this.slaveController.setPosition(this.position);
        this.trucks.updatePosition();
        this.trucks.publishData();
        FCSCst.FCSLOG.info((Object)("plutoGateway=" + this.plutoGateway.toString()));
        if (this.position == this.trucks.getHandoffPosition()) {
            FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksIsAtHandoff");
            this.plutoGateway.simulateAutochangerTrucksIsAtHandoff();
        } else if (this.position == this.trucks.getStandbyPosition()) {
            this.plutoGateway.simulateAutochangerTrucksIsAtStandby();
            if (this.carousel.isHoldingFilter()) {
                FCSCst.FCSLOG.info((Object)"simulateFilterIsOnAutochanger");
                this.plutoGateway.simulateFilterIsOnAutochanger();
            }
        } else if (this.position == this.trucks.getOnlinePosition()) {
            FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksIsOnline");
            this.plutoGateway.simulateAutochangerTrucksIsOnline();
        } else {
            FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksIsInTravel");
            this.plutoGateway.simulateAutochangerTrucksIsInTravel();
        }
        FCSCst.FCSLOG.info((Object)("plutoGateway=" + this.plutoGateway.toString()));
    }
}

