/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;

public abstract class PlutoGatewayModule
extends CanOpenDevice
implements PlutoGatewayInterface,
PieceOfHardware {
    protected String[] hexaValues;
    protected volatile boolean updatingValues = false;
    protected final Lock lock = new ReentrantLock();
    protected final Condition valueUpdated = this.lock.newCondition();

    public PlutoGatewayModule(String nodeID, String serialNB) {
        super(nodeID, serialNB);
        this.hexaValues = new String[16];
        for (int i = 0; i < this.hexaValues.length; ++i) {
            this.hexaValues[i] = "00";
        }
    }

    @Override
    public String[] getHexaValues() {
        this.lock.lock();
        try {
            while (this.updatingValues) {
                try {
                    this.valueUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.getName() + ex.getMessage()));
                }
            }
            String[] stringArray = this.hexaValues;
            return stringArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void updateValues() {
        this.lock.lock();
        try {
            this.updatingValues = true;
            this.hexaValues = this.readNewHexaValues();
            FCSCst.FCSLOG.finest((Object)(this.getName() + " HEXA VALUE READ: hexaValues[0]=" + this.hexaValues[0] + " hexaValues[1]=" + this.hexaValues[1]));
        }
        finally {
            this.updatingValues = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1)
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/byte no0=");
        sb.append(String.valueOf(this.hexaValues[0]));
        sb.append("/byte no1=");
        sb.append(String.valueOf(this.hexaValues[1]));
        sb.append("/byte no2=");
        sb.append(String.valueOf(this.hexaValues[2]));
        sb.append("/byte no3=");
        sb.append(String.valueOf(this.hexaValues[3]));
        return sb.toString();
    }
}

