/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenPlutoGateway;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class LoaderCanOpenPlutoGateway
extends CanOpenPlutoGateway {
    public LoaderCanOpenPlutoGateway(String nodeID, String serialNB, String station_addr) {
        super(nodeID, serialNB, station_addr);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Initialize the Gateway.")
    public String initializeAndCheckHardware() {
        if (!this.isBooted()) {
            throw new FcsHardwareException(this.getName() + " is not booted - can't be initialized.");
        }
        try {
            FCSCst.FCSLOG.info((Object)(this.getName() + " BEGIN initializeHardware"));
            this.initialized = true;
            FCSCst.FCSLOG.info((Object)(this.getName() + " is INITIALIZED."));
            this.tcpProxy.publishHardwareData(this);
            return this.getName() + " is INITIALIZED.";
        }
        catch (FailedCommandException | SDORequestException ex) {
            throw new FcsHardwareException(this.getName(), ex);
        }
    }

    @Override
    public String[] readNewHexaValues() {
        if (!this.isBooted()) {
            throw new FcsHardwareException(this.getName() + " is not booted - can't read new values.");
        }
        try {
            this.hexaValues[0] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "03");
            FCSCst.FCSLOG.finest((Object)String.format("%s : first byte read in hexaValue= %s", this.getName(), this.hexaValues[0]));
            this.hexaValues[1] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "04");
            FCSCst.FCSLOG.finest((Object)String.format("%s : second byte read in hexaValue= %s", this.getName(), this.hexaValues[1]));
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.warning((Object)(this.getName() + "=> ERROR IN READING SENSOR:" + (Object)((Object)ex)));
        }
        catch (SDORequestException ex) {
            String message = this.getName() + "=> ERROR IN READING SENSOR:";
            this.raiseAlarm("FCS004:" + this.getName(), message, (Exception)((Object)ex));
        }
        return this.hexaValues;
    }
}

