/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.drivers.CommandDispenser;
import org.lsst.ccs.subsystems.fcs.errors.CWrapperNotConnected;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.utilities.beanutils.WrappedException;

abstract class FcsTcpProxy
extends Module
implements AlertRaiser {
    @ConfigurationParameter(isFinal=true, range="1024..99000", description="tcpip port number on which this tcpip server starts on.")
    protected int portNumber;
    @ConfigurationParameter(description="Timeout in Millisecond. If a command sent to the CANbus doesn't respond during this amount of time, we considere that they could be an issue on the hardware.")
    protected int fieldBusTimeout;
    private ServerSocket serverSock;
    private Thread readerThread;
    protected volatile boolean stopped = true;
    protected volatile boolean stopping = false;
    protected volatile boolean tcpServerStarted = false;
    protected ClientContext clientContext;
    private CommandDispenser commandDispenser;
    protected final Lock lock = new ReentrantLock();
    protected final Condition hardwareBooted = this.lock.newCondition();

    public FcsTcpProxy(int portNumber, int fieldBusTimeout) {
        super(3000);
        this.portNumber = portNumber;
        this.fieldBusTimeout = fieldBusTimeout;
    }

    public boolean isTcpServerStarted() {
        return this.tcpServerStarted;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getClientName() {
        return this.clientContext.clientName;
    }

    public void initModule() {
        this.stopped = false;
        this.stopping = false;
        this.tcpServerStarted = false;
        this.commandDispenser = new CommandDispenser();
    }

    public void start() {
        this.startServer();
        this.startThreadReader();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Starts the tcp server.")
    public void startServer() {
        try {
            this.serverSock = new ServerSocket(this.portNumber);
            FCSCst.FCSLOG.info((Object)(this.getName() + ":SERVER STARTED ON PORT:" + this.portNumber));
        }
        catch (IOException e) {
            FCSCst.FCSLOG.error((Object)(this.getName() + ":server not started"), (Throwable)e);
            throw new WrappedException((Throwable)e);
        }
        try {
            FCSCst.FCSLOG.info((Object)(this.getName() + ":WAITING FOR C-WRAPPER CLIENT..."));
            this.getSubsystem().updateAgentState("FILTER", new Enum[]{FcsEnumerations.FilterState.WAITING_FOR_CWRAPPER, FcsEnumerations.FilterReadinessState.NOT_READY});
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":DEBUGGING MODE"));
            Socket sock = this.serverSock.accept();
            FCSCst.FCSLOG.info((Object)(this.getName() + ":socket accept on " + this.portNumber));
            BufferedReader reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), "ISO-8859-1"), 256);
            String nameAndProtocol = reader.readLine();
            if (nameAndProtocol == null) {
                FCSCst.FCSLOG.error((Object)(this.getName() + ": nameAndProtocol is null : that should not happen."));
            } else {
                String[] words = nameAndProtocol.split(" ");
                String cname = words[0];
                this.clientContext = new ClientContext(cname, sock, reader, sock.getOutputStream());
                FCSCst.FCSLOG.info((Object)(this.getName() + ":REGISTERED : " + cname));
                this.tcpServerStarted = true;
                this.stopped = false;
            }
        }
        catch (IOException e) {
            FCSCst.FCSLOG.error((Object)(this.getName() + " unexpected "), (Throwable)e);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Starts to listen to the tcp client.")
    public void startThreadReader() {
        FCSCst.FCSLOG.info((Object)(this.getName() + "startThreadReader"));
        if (!this.isTcpServerStarted()) {
            String errorMsg = this.getName() + " tcp server has to be started before startThreadReader.";
            this.raiseAlarm("FCS001" + this.name, errorMsg);
        }
        Runnable readingFromTcpProxy = new Runnable(){

            @Override
            public void run() {
                while (!FcsTcpProxy.this.stopped) {
                    try {
                        String readline = FcsTcpProxy.this.clientContext.reader.readLine();
                        if (readline == null) {
                            if (FcsTcpProxy.this.stopping) {
                                FCSCst.FCSLOG.info((Object)(FcsTcpProxy.this.getName() + " : CWrapper is stopped."));
                                continue;
                            }
                            FCSCst.FCSLOG.error((Object)(FcsTcpProxy.this.getName() + " :nameAndProtocol is null : that should not happen."));
                            continue;
                        }
                        FCSCst.FCSLOG.finest((Object)(FcsTcpProxy.this.getName() + ":message read from socket=" + readline));
                        if (readline.startsWith("emcy")) {
                            FcsTcpProxy.this.processEmcyMessage(readline);
                            continue;
                        }
                        if (readline.startsWith("Unknown")) {
                            FcsTcpProxy.this.processUnknownCommand(readline);
                            continue;
                        }
                        String[] words = readline.split(",");
                        String commandWord = words[0];
                        String nodeID = words[1];
                        if ("boot".equals(commandWord)) {
                            FCSCst.FCSLOG.info((Object)(FcsTcpProxy.this.getName() + ":boot command received for node: " + nodeID));
                            FcsTcpProxy.this.processBootMessage(nodeID);
                            continue;
                        }
                        String token = readline.startsWith("sync") ? "sync" : commandWord + nodeID;
                        FCSCst.FCSLOG.finest((Object)("Corresponding token=" + token));
                        if (FcsTcpProxy.this.commandDispenser.isTokenUsed(token)) {
                            FCSCst.FCSLOG.finest((Object)("Response to a registred command:" + readline));
                            try {
                                FcsTcpProxy.this.commandDispenser.registerResponse(token, readline);
                            }
                            catch (Exception ex) {
                                FCSCst.FCSLOG.error((Object)ex);
                                FCSCst.FCSLOG.error((Object)(FcsTcpProxy.this.getName() + ":Error in registering response to command :" + readline), ex.getCause());
                            }
                            continue;
                        }
                        FCSCst.FCSLOG.warning((Object)(FcsTcpProxy.this.getName() + ":Unsynchronous message read from CANbus=" + readline));
                    }
                    catch (IOException ex) {
                        FCSCst.FCSLOG.error((Object)ex);
                        FCSCst.FCSLOG.error((Object)(FcsTcpProxy.this.getName() + ": Error in Thread reading from the tcp client."));
                    }
                }
            }
        };
        FCSCst.FCSLOG.info((Object)(this.getName() + ":STARTING Thread reader"));
        this.readerThread = new Thread(readingFromTcpProxy);
        this.readerThread.start();
    }

    public void shutdownNow() {
        super.shutdownNow();
        this.stopServer();
        this.getSubsystem().updateAgentState("FILTER", new Enum[]{FcsEnumerations.FilterState.OFF_LINE, FcsEnumerations.FilterReadinessState.NOT_READY});
    }

    public void stopServer() {
        if (!this.tcpServerStarted) {
            FCSCst.FCSLOG.warning((Object)(this.getName() + " is stopped; nothing to stop."));
            return;
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + ": ABOUT TO STOP TCP server....."));
        FCSCst.FCSLOG.finest((Object)("clientName=" + this.clientContext.clientName));
        this.stopping = true;
        try {
            this.call(this.clientContext.clientName, "quit");
        }
        catch (CanOpenCallTimeoutException ex) {
            String msg = this.getName() + ": could not stop Cwrapper.";
            this.raiseAlarm("FCS001:" + this.getName(), msg + (Object)((Object)ex));
        }
        catch (CWrapperNotConnected ex) {
            String msg = this.getName() + ": could not stop because CWrapper is not connected.";
            this.raiseAlarm("FCS001:" + this.getName(), msg + (Object)((Object)ex));
        }
        this.stopped = true;
        this.readerThread.interrupt();
        try {
            this.serverSock.close();
            this.tcpServerStarted = false;
            FCSCst.FCSLOG.info((Object)(this.getName() + ": Subsystem " + this.getSubsystem().getName() + " TCPIP SERVER STOPPED:"));
        }
        catch (IOException ex) {
            FCSCst.FCSLOG.error((Object)ex);
            FCSCst.FCSLOG.error((Object)(this.getName() + " : stop method does not work properly when closing socket"));
        }
        try {
            this.clientContext.reader.close();
            this.clientContext.writer.close();
            this.clientContext.socket.close();
        }
        catch (IOException ex) {
            FCSCst.FCSLOG.error((Object)ex);
            FCSCst.FCSLOG.error((Object)(this.getName() + " : stop method does not work properly"));
        }
    }

    public synchronized boolean isReady(String clientName) {
        if (clientName == null) {
            throw new IllegalArgumentException("Client name can't be null.");
        }
        if (this.clientContext == null || this.clientContext.clientName == null) {
            return false;
        }
        if (this.stopped) {
            return false;
        }
        if (!this.tcpServerStarted) {
            return false;
        }
        FCSCst.FCSLOG.debug((Object)(this.getName() + "client name:= " + this.clientContext.clientName + "#"));
        return this.clientContext.clientName.equals(clientName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object call(String clientName, String command) {
        FCSCst.FCSLOG.finest((Object)(" CALL :" + clientName + " " + command));
        if (this.clientContext == null) {
            throw new CWrapperNotConnected(this.portNumber, clientName, " could not send command:" + command);
        }
        if (this.stopped) {
            throw new IllegalStateException(this.getName() + ":textTCP module stopped");
        }
        String sentCommand = command + "\r\u0000\n";
        FCSCst.FCSLOG.finest((Object)(this.getName() + ":Sent command=" + command));
        this.clientContext.writer.write(sentCommand, 0, sentCommand.length());
        this.clientContext.writer.flush();
        if (!command.startsWith("rsdo") && !command.startsWith("wsdo") && !command.startsWith("info") && !command.startsWith("sync") && !command.startsWith("srtr")) return "asynchronous command sent:" + command;
        String commandToken = this.commandDispenser.register(command);
        try {
            String string = this.commandDispenser.getCommandResponse(commandToken, this.fieldBusTimeout);
            this.commandDispenser.remove(commandToken);
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.commandDispenser.remove(commandToken);
                throw throwable;
            }
            catch (IOException ex) {
                FCSCst.FCSLOG.error((Object)(this.getName() + ":ERROR in tcpProxy call method"));
                FCSCst.FCSLOG.error((Object)ex);
                throw new WrappedException(this.getName() + ":ERROR in tcpProxy call method " + clientName, (Throwable)ex);
            }
        }
    }

    abstract void processBootMessage(String var1);

    abstract void processEmcyMessage(String var1);

    abstract void processUnknownCommand(String var1);

    public String toString() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getName()));
        sb.append("/port=");
        sb.append(this.portNumber);
        return sb.toString();
    }

    protected static class ClientContext {
        private String clientName;
        private BufferedReader reader;
        private BufferedWriter writer;
        protected Socket socket;

        ClientContext(String name, Socket socket, BufferedReader reader, OutputStream os) {
            try {
                this.clientName = name;
                this.reader = reader;
                this.socket = socket;
                this.writer = new BufferedWriter(new OutputStreamWriter(os, "ISO-8859-1"), 256);
            }
            catch (UnsupportedEncodingException e) {
                FCSCst.FCSLOG.error((Object)(name + ":context not started"), (Throwable)e);
                throw new Error(e);
            }
        }
    }
}

