/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.common.TcpProxyInterface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.FcsTcpProxy;
import org.lsst.ccs.subsystems.fcs.errors.CWrapperNotConnected;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenProxy
extends FcsTcpProxy
implements HardwareController,
ClearAlertHandler,
TcpProxyInterface {
    @ConfigurationParameter(isFinal=true)
    private String clientName;
    @ConfigurationParameter(range="1000..10000", description="A timeout for the hardware booting process")
    private long hardwareBootTimeout = 1000L;
    private Map<String, CanOpenNode> bootedNodes = new HashMap<String, CanOpenNode>();
    private boolean hardwareBootProcessEnded = false;
    private boolean hardwareIdentified = false;
    protected ArrayList<PieceOfHardware> hardwareList;
    private Map<String, PieceOfHardware> hardwareMapByNodeID;
    private boolean canOpenNodeNumbersOK = false;
    private StringBuilder errorMessageSB;
    private boolean hardwareIDError;
    private PDOStorage pdoStorage;
    private ScheduledFuture<?> checkDevicesHandle;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    protected final Condition bootingCompleted = this.lock.newCondition();

    public CanOpenProxy(int portNumber, int fieldBusTimeout, String clientName, long hardwareBootTimeout) {
        super(portNumber, fieldBusTimeout);
        this.clientName = clientName;
        this.hardwareBootTimeout = hardwareBootTimeout;
    }

    protected void setHardwareList(ArrayList<PieceOfHardware> devices) {
        this.hardwareList = (ArrayList)devices.clone();
        this.hardwareMapByNodeID = new HashMap<String, PieceOfHardware>();
        this.hardwareList.stream().forEach(hardware -> this.hardwareMapByNodeID.put(hardware.getNodeID(), (PieceOfHardware)hardware));
    }

    public String getMyClientName() {
        return this.clientName;
    }

    public PDOStorage getPdoStorage() {
        return this.pdoStorage;
    }

    public boolean isHardwareIdentified() {
        return this.hardwareIdentified;
    }

    public void setHardwareIdentified(boolean hardwareIdentified) {
        this.hardwareIdentified = hardwareIdentified;
    }

    public void setCanOpenNodeNumbersOK(boolean canOpenNodeNumbersOK) {
        this.canOpenNodeNumbersOK = canOpenNodeNumbersOK;
    }

    public void setHardwareBootProcessEnded(boolean hardwareBootProcessEnded) {
        this.hardwareBootProcessEnded = hardwareBootProcessEnded;
    }

    @Override
    public void disconnectHardware() {
        this.stopServer();
        this.initialize();
    }

    @Override
    public void connectHardware() throws HardwareException {
        this.startServer();
        this.startThreadReader();
    }

    @Override
    public void initModule() {
        super.initModule();
        this.initialize();
        this.getSubsystem().addClearAlertHandler((ClearAlertHandler)this);
    }

    public void initialize() {
        this.bootedNodes = new HashMap<String, CanOpenNode>();
        this.hardwareBootProcessEnded = false;
        this.hardwareIdentified = false;
        this.canOpenNodeNumbersOK = false;
        this.hardwareIDError = false;
        this.pdoStorage = new PDOStorage();
        this.errorMessageSB = new StringBuilder(String.valueOf(this.getName()));
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        this.hardwareBootProcessEnded = false;
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": BEGIN CHECKHARDWARE"));
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.CAN_DEVICES_BOOTING, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.lock.lock();
        try {
            this.readDevicesInfo(System.currentTimeMillis(), this.hardwareBootTimeout);
            this.waitForEndOfBooting();
        }
        finally {
            this.lock.unlock();
        }
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": END OF BOOT PROCESS"));
        FCSCst.FCSLOG.info((Object)(this.getName() + "=>" + this.listBootedNodes()));
        this.checkBootedCanOpenNodes();
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": END CHECKHARDWARE"));
        this.publishData();
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public void readDevicesInfo(long beginTime, long timeout) {
        Runnable checkDevices = () -> {
            try {
                this.identifyHardware();
                this.publishData();
                long duration = System.currentTimeMillis() - beginTime;
                if (duration > timeout || this.bootedNodes.size() == this.hardwareList.size()) {
                    this.hardwareBootProcessEnded = true;
                    this.cancelReadDevicesInfo();
                }
            }
            catch (HardwareException ex) {
                this.raiseAlarm("FCS001:", this.getName() + " couln't read devices info because:" + (Object)((Object)ex));
            }
        };
        this.checkDevicesHandle = this.scheduler.scheduleAtFixedRate(checkDevices, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void cancelReadDevicesInfo() {
        this.lock.lock();
        try {
            FCSCst.FCSLOG.debug((Object)(this.getName() + " => stop waiting for devices info."));
            this.bootingCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.checkDevicesHandle.cancel(true);
        FCSCst.FCSLOG.debug((Object)(this.getName() + " => readDevicesInfo canceled"));
    }

    private void waitForEndOfBooting() {
        while (!this.hardwareBootProcessEnded) {
            try {
                FCSCst.FCSLOG.info((Object)(this.getName() + " waiting until all pieces of hardware are booted."));
                this.bootingCompleted.await();
            }
            catch (InterruptedException ex) {
                FCSCst.FCSLOG.info((Object)(this.getName() + ": InterruptedException received=" + ex));
                break;
            }
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + " STOP WAITING FOR END OF BOOTING PROCESS"));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Retrieve information for booted devices and checks if CANopen node ID and serial number match thosein description file .")
    public void checkNewHardware() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.getName() + " BEGIN checkStartedToCompleteInitialization"));
        if (!this.isReady(this.clientName)) {
            throw new HardwareException(true, this.getName() + ": not yet connected with CWrapper.");
        }
        if (!this.isTcpServerStarted()) {
            throw new HardwareException(true, this.getName() + ": could not start tcp server.");
        }
        this.identifyHardware();
        this.checkBootedCanOpenNodes();
    }

    public void checkStarted() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.getName() + " BEGIN checkStarted"));
    }

    public void checkStopped() throws HardwareException {
    }

    @Override
    public void shutdownNow() {
        super.shutdownNow();
        this.scheduler.shutdown();
    }

    public String getNodeName(String aNodeID) {
        if (this.hardwareMapByNodeID.get(aNodeID) == null) {
            return "Unknown nodeID:" + aNodeID;
        }
        return this.hardwareMapByNodeID.get(aNodeID).getName();
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Return true if the device, with nodeID given as argument, is booted.")
    public boolean isBooted(String aNodeID) {
        if (this.bootedNodes.isEmpty()) {
            return false;
        }
        return this.bootedNodes.containsKey(aNodeID);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Print the list of CANopen nodes which are booted on the CAN bus. (values are in HEXA)")
    public String listBootedNodes() {
        if (this.bootedNodes.isEmpty()) {
            return this.getName() + ": no booted CANopen devices.";
        }
        return this.getName() + " booted CANopen devices:" + this.bootedNodes.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen command to the Can Bus.")
    public String sendCanOpenCommand(String command) {
        if (!this.tcpServerStarted) {
            throw new FcsHardwareException(this.getName() + ": is not started, can't send CanOpen commands.");
        }
        this.checkCanOpenCommand(command);
        return this.sendCanOpen(command);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkCanOpenCommand(String command) {
        if (command == null || command.isEmpty()) {
            throw new IllegalArgumentException("null command");
        }
        String[] words = command.split(",");
        String keyWord = words[0];
        if ("sync".equals(keyWord) || "scan".equals(keyWord) || "quit".equals(keyWord)) {
            if (words.length == 1 && !command.endsWith(",")) return;
            throw new IllegalArgumentException("Usage: " + keyWord);
        }
        if ("info".equals(keyWord) || "reset".equals(keyWord) || "srtr".equals(keyWord)) {
            if (words.length != 2 || command.endsWith(",")) throw new IllegalArgumentException("Usage: " + keyWord + ",nodeID");
            this.checkNodeID(words[1]);
            return;
        } else if ("rsdo".equals(keyWord)) {
            if (words.length != 4 || command.endsWith(",")) throw new IllegalArgumentException("Usage: rsdo, nodeID, index, subindex");
            this.checkNodeID(words[1]);
            return;
        } else {
            if (!"wsdo".equals(keyWord)) throw new IllegalArgumentException(command + ":invalid CANopen command");
            if (words.length != 6 || command.endsWith(",")) throw new IllegalArgumentException("Usage: rsdo, nodeID, index, subindex,size, data");
            this.checkNodeID(words[1]);
        }
    }

    public void checkNodeID(String nodeID) {
        if (!this.hardwareMapByNodeID.containsKey(nodeID)) {
            throw new IllegalArgumentException(nodeID + " is not in the hardware list for tcpProxy " + this.getName());
        }
    }

    private String sendCanOpen(String command) {
        try {
            return (String)this.call(this.getMyClientName(), command);
        }
        catch (CWrapperNotConnected ex) {
            this.raiseAlarm("FCS001:" + this.getName(), "Can't communicate with hardware because CWrapper is not connected - check ethernet connections.", (Exception)((Object)ex));
            throw new FcsHardwareException("CWrapper not connected.", (Throwable)ex);
        }
        catch (CanOpenCallTimeoutException ex) {
            String msg = this.getName() + ": timeout expired while waiting to a response from CANbus to command: " + command + " POWER FAILURE ? ";
            this.raiseWarning("FCS001:" + this.getName(), msg, (Exception)((Object)ex));
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
    }

    public String writeSDO(String nodeID, String index, String subindex, String size, String value) {
        String errorCode;
        String request = FcsUtils.buildWsdoCommand(nodeID, index, subindex, size, value);
        String sdoResponseLine = this.sendCanOpen(request);
        String[] words = sdoResponseLine.split(",");
        switch (errorCode = words[2]) {
            case "0": {
                return "OK";
            }
            case "-1": {
                String msg = this.getName() + ":wrong writeSDO command : " + sdoResponseLine;
                String deviceName = this.getNodeName(nodeID);
                this.raiseAlarm(deviceName, msg);
                throw new SDORequestException(this.getName() + ":wrong writeSDO command : " + sdoResponseLine);
            }
        }
        String message = this.processSDORequestError(request, sdoResponseLine, nodeID, errorCode, AlertState.ALARM);
        throw new SDORequestException(message);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen writeSDO command to the Can Bus.  \nValues of the argument are to be given in hexadecimal format for: index and subindex\n and in decimal format for size and value.\n size represents the number of bytes on which the value is encoded. See device documentation.")
    public String writeSDO(String nodeID, String index, String subindex, int size, int value) {
        this.checkNodeID(nodeID);
        if (size < 0 || size > 4) {
            throw new IllegalArgumentException("size must be > 0 and < 4");
        }
        return this.writeSDO(nodeID, index, subindex, Integer.toHexString(size), Integer.toHexString(value));
    }

    public String readSDO(String nodeID, String index, String subindex) throws ShortResponseToSDORequestException, FcsHardwareException {
        String request = FcsUtils.buildRsdoCommand(nodeID, index, subindex);
        String sdoLine = this.sendCanOpen(FcsUtils.buildRsdoCommand(nodeID, index, subindex));
        return this.processResponseToReadSDO(sdoLine, nodeID, request);
    }

    public String processResponseToReadSDO(String response, String nodeID, String request) throws ShortResponseToSDORequestException, SDORequestException {
        String[] words = response.split(",");
        int responseLength = words.length;
        String errorCode = words[2];
        if ("0".equals(errorCode) && responseLength > 3) {
            return words[3];
        }
        if ("0".equals(errorCode) && responseLength == 3) {
            String msg = this.getName() + ":readSDO request received a too short response=" + response;
            String deviceName = this.getNodeName(nodeID);
            this.raiseWarning(deviceName, msg);
            throw new ShortResponseToSDORequestException(msg);
        }
        if ("-1".equals(errorCode)) {
            String msg = this.getName() + ":wrong readSDO command : " + response;
            String deviceName = this.getNodeName(nodeID);
            this.raiseAlarm(deviceName, msg);
            throw new SDORequestException(msg);
        }
        String message = this.processSDORequestError(request, response, nodeID, errorCode, AlertState.ALARM);
        throw new SDORequestException(message);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Send a CANOpen readSDO command to the Can Bus.")
    public String readSDOCommand(String nodeID, String index, String subindex) {
        this.checkNodeID(nodeID);
        return this.readSDO(nodeID, index, subindex);
    }

    public String processSDORequestError(String request, String response, String nodeID, String errorCode, AlertState alertState) {
        String error = String.format("%08d", Integer.parseInt(errorCode));
        String errorName = CanOpenErrorsTable.getCommErrorNameByCode(error);
        String deviceName = this.getNodeName(nodeID);
        String msg = this.getName() + ": SDO request was going wrong for device: " + deviceName;
        msg = msg + ",request=" + request + ",received response=" + response;
        msg = msg + ",errorCode=" + errorCode + ",errorName=" + errorName;
        if (alertState.equals((Object)AlertState.WARNING)) {
            this.raiseWarning(deviceName, msg);
        } else {
            this.raiseAlarm(deviceName, msg);
        }
        return msg;
    }

    public PDOStorage readPDOs() {
        try {
            String replyToSync = this.sendCanOpen("sync");
            FCSCst.FCSLOG.finest((Object)(this.getName() + ": replyToSync=" + replyToSync));
            this.pdoStorage.updatePDOs(replyToSync);
            return this.pdoStorage;
        }
        catch (FcsHardwareException ex) {
            String msg = this.getName() + ": error in response to a sync command.";
            this.raiseAlarm("FCS001:", msg, (Exception)((Object)ex));
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Identification of the hardware : we want to retrieve the information \n     * stored in the hardware of the booted nodes and update the array of nodes\n     * with this information.")
    public void identifyHardware() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.getName() + ":Identification of the hardware"));
        for (Map.Entry<String, CanOpenNode> entry : this.bootedNodes.entrySet()) {
            CanOpenNode bootedNode = entry.getValue();
            String bootedNodeID = entry.getKey();
            if (bootedNode == null || bootedNode.isIdentified()) continue;
            this.updateDeviceInfo(bootedNodeID);
        }
        this.hardwareIdentified = true;
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update device information in sending to the CANbus a CANopen command : info,nodeID")
    public void updateDeviceInfo(String bootedNodeID) throws HardwareException {
        try {
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":Sending to can open command : info," + bootedNodeID));
            String result = this.sendCanOpen("info," + bootedNodeID);
            this.processInfoMessage(result, bootedNodeID);
        }
        catch (FcsHardwareException ex) {
            FCSCst.FCSLOG.error((Object)ex);
            throw new HardwareException(false, (Throwable)ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all CANopen devices are booted and identified.Identified means that the serial numbers match the CANopen nodeID which reside inconfiguration.")
    public boolean isCANDevicesReady() {
        FCSCst.FCSLOG.info((Object)(this.getName() + ":hardwareBootProcessEnded=" + this.hardwareBootProcessEnded));
        FCSCst.FCSLOG.info((Object)(this.getName() + ":hardwareIdentified=" + this.hardwareIdentified));
        FCSCst.FCSLOG.info((Object)(this.getName() + ":canOpenNodeNumbersOK=" + this.canOpenNodeNumbersOK));
        FCSCst.FCSLOG.info((Object)(this.getName() + ":hardwareIDError=" + this.hardwareIDError));
        return this.hardwareBootProcessEnded && this.hardwareIdentified && this.canOpenNodeNumbersOK && !this.hardwareIDError;
    }

    @Override
    void processBootMessage(String nodeID) {
        if (this.isBooted(nodeID)) {
            if (this.hardwareBootProcessEnded) {
                String msg = this.getName() + " An unsynchronous boot message is arrived for node ID = " + nodeID + " Possible power failure?";
                this.raiseWarning("FCS003:" + this.getName() + ":" + nodeID, msg);
            }
        } else {
            this.bootedNodes.put(nodeID, new CanOpenNode(nodeID));
            FCSCst.FCSLOG.info((Object)("Node " + nodeID + " added"));
            FCSCst.FCSLOG.info((Object)("Number of booted devices=" + this.bootedNodes.size()));
            FCSCst.FCSLOG.info((Object)("Number of expected devices=" + this.hardwareList.size()));
            if (this.hardwareBootProcessEnded) {
                String msg = this.getName() + ": boot message is arrived for node ID:" + nodeID + " when boot process is completed. +Has the device been powered on ?";
                this.raiseWarning("FCS003:" + this.getName() + ":" + nodeID, msg);
            }
        }
    }

    @Override
    public void processEmcyMessage(String message) {
        String[] words = message.split(",");
        String nodeID = words[1].replaceFirst("^0+(?!$)", "");
        String deviceErrorCode = words[2];
        String errReg = words[3];
        String deviceErrorName = CanOpenErrorsTable.getDeviceErrorNameByCode(deviceErrorCode);
        String errorRegisterName = CanOpenErrorsTable.getErrorRegisterNameByCode(errReg);
        String deviceName = this.getNodeName(nodeID);
        EmergencyMessage emcyMsg = new EmergencyMessage(this.getName(), nodeID, deviceName, deviceErrorCode, deviceErrorName, errReg, errorRegisterName);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.getName(), (Object)emcyMsg));
        FCSCst.FCSLOG.finest((Object)(this.getName() + " getNObserverThreads()=" + this.getNObserverThreads()));
        FCSCst.FCSLOG.warning((Object)(this.getName() + " received EMERGENCY message=" + message + " for nodeID=" + nodeID));
        if ("00".equals(errReg)) {
            this.raiseWarning("FCS002" + this.getName() + nodeID, emcyMsg.toString());
        } else {
            this.raiseAlarm("FCS002" + this.getName() + nodeID, emcyMsg.toString());
        }
    }

    void processInfoMessage(String message, String bootedNodeID) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":Received on socket command = " + message));
        String[] words = message.split(",");
        String command = words[0];
        String nodeID = words[1];
        if ("info".equals(command) && bootedNodeID.equals(nodeID)) {
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":updating Node Info for node " + nodeID));
            String type = words[2];
            String vendor = words[3];
            String productCode = words[4];
            String revision = words[5];
            String serialNB = words[6];
            this.bootedNodes.get(bootedNodeID).setNodeInfo(type, vendor, productCode, revision, serialNB);
        } else {
            FCSCst.FCSLOG.error((Object)(this.getName() + ":ERROR for command = " + command + "NodeID = " + nodeID));
        }
    }

    @Override
    void processUnknownCommand(String message) {
        this.raiseWarning("FCS002" + this.getName(), "Unknown command received by CWrapper:" + message);
    }

    public void checkBootedCanOpenNodes() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.getName() + ":CHECKING HARDWARE CONFIGURATION "));
        this.checkNumberOfBootedNodes();
        this.hardwareIDError = false;
        for (PieceOfHardware hardware : this.hardwareList) {
            FCSCst.FCSLOG.info((Object)("ABOUT TO CHECK: " + hardware.getName() + " NODE_ID=" + hardware.getNodeID()));
            this.checkHardwareID(hardware);
        }
        if (this.hardwareIDError) {
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.CAN_DEVICES_BOOTING, FcsEnumerations.FilterReadinessState.NOT_READY});
            throw new HardwareException(true, this.errorMessageSB.toString());
        }
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.HOMING_TO_BE_DONE, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Checks if the number of booted nodes is correct : it has to be equal to the number of CANopen devices that this subsystem manages.")
    public void checkNumberOfBootedNodes() throws HardwareException {
        int expectedDevicesNumber = this.hardwareList.size();
        if (this.bootedNodes.isEmpty()) {
            String msg = String.format(" (hardwareBootTimeout=%02d, expectedNodesNB=%02d)", this.hardwareBootTimeout, this.hardwareList.size());
            FCSCst.FCSLOG.error((Object)(this.getName() + ":NO HARDWARE DETECTED - POWER FAILURE ?" + msg));
            this.raiseAlarm("NO_HARDWARE_DETECTED", ":NO HARDWARE DETECTED - POWER FAILURE ?", this.getName() + " this could happen because of a POWER FAILURE on CAN bus, or on CANopen devices." + msg);
            throw new HardwareException(true, this.getName() + msg);
        }
        if (this.bootedNodes.size() < expectedDevicesNumber) {
            String msg = ":SOME HARDWARE IS MISSING - POWER FAILURE ?";
            FCSCst.FCSLOG.error((Object)(this.getName() + msg));
            this.raiseAlarm("FCS001:" + this.getName() + ":HARDWARE_MISSING", ":SOME HARDWARE IS MISSING - POWER FAILURE ?" + msg);
            throw new HardwareException(true, this.getName() + msg);
        }
        if (this.bootedNodes.size() == expectedDevicesNumber) {
            this.canOpenNodeNumbersOK = true;
        }
    }

    public void checkHardwareID(PieceOfHardware pieceOfHardware) throws HardwareException {
        if (this.bootedNodes.containsKey(pieceOfHardware.getNodeID())) {
            CanOpenNode bootedNode = this.bootedNodes.get(pieceOfHardware.getNodeID());
            if (!bootedNode.getSerialNB().equals(pieceOfHardware.getSerialNB())) {
                pieceOfHardware.setBooted(false);
                String msg = pieceOfHardware.getName() + " has a wrong serial number. Serial number found=" + bootedNode.getSerialNB() + ", should be=" + pieceOfHardware.getSerialNB();
                FCSCst.FCSLOG.error((Object)msg);
                this.errorMessageSB.append(msg);
                this.hardwareIDError = true;
                this.raiseAlarm("FCS001:" + this.getName() + ":" + pieceOfHardware.getName(), msg);
                throw new HardwareException(false, this.getName() + msg);
            }
        } else {
            CanOpenNode bootedNode = this.getBootedNodeBySerialNumber(pieceOfHardware.getSerialNB());
            if (bootedNode == null) {
                String msg = String.format(":HARDWARE NOT DETECTED - Possible power failure for node ID %s ? - (hardware:%s,serial number:%s)", pieceOfHardware.getNodeID(), pieceOfHardware.getName(), pieceOfHardware.getSerialNB());
                FCSCst.FCSLOG.error((Object)msg);
                this.errorMessageSB.append(msg);
                this.hardwareIDError = true;
                this.raiseAlarm("FCS001:" + this.getName() + ":" + pieceOfHardware.getName() + ":HARDWARE_MISSING", ":HARDWARE NOT DETECTED - POWER FAILURE ?" + msg);
                throw new HardwareException(false, this.getName() + msg);
            }
            pieceOfHardware.setBooted(false);
            String msg = pieceOfHardware.getName() + ": a device is booted with serial number :" + pieceOfHardware.getSerialNB() + ", but with CANopen nodeID=" + bootedNode.getNodeID() + " Please change hardware description or hardware CANopen setting.";
            FCSCst.FCSLOG.error((Object)msg);
            this.errorMessageSB.append(msg);
            this.hardwareIDError = true;
            this.raiseAlarm(pieceOfHardware.getName(), msg);
            throw new HardwareException(false, this.getName() + msg);
        }
        pieceOfHardware.setBooted(true);
        FCSCst.FCSLOG.info((Object)(pieceOfHardware.getName() + " BOOTED AND SERIAL NUMBER OK:" + pieceOfHardware.toString()));
        this.publishHardwareData(pieceOfHardware);
    }

    public CanOpenNode getBootedNodeBySerialNumber(String sn) {
        for (Map.Entry<String, CanOpenNode> entry : this.bootedNodes.entrySet()) {
            CanOpenNode bootedNode = entry.getValue();
            if (!bootedNode.getSerialNB().equalsIgnoreCase(sn)) continue;
            return bootedNode;
        }
        return null;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns a String representation of a CANopen node booted on the CANbus for the device which serial number is given as a parameter.")
    public String printBootedNodeBySerialNumber(String sn) {
        if (sn == null) {
            throw new IllegalArgumentException(this.getName() + " Serial Number must be not null.");
        }
        return String.valueOf(this.getBootedNodeBySerialNumber(sn));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed list of hardware.")
    public String printHardwareList() {
        return this.hardwareList.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed list of hardware with the initialization state.")
    public String printHardwareState() {
        this.publishData();
        StringBuilder sb = new StringBuilder(this.getName() + " CANopen devices : {");
        for (PieceOfHardware pieceOfHardware : this.hardwareList) {
            sb.append(pieceOfHardware.printState());
            sb.append(';');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return an Array containing hardware names handled by this component.")
    public List<String> listHardwareNames() {
        ArrayList<String> res = new ArrayList<String>();
        for (PieceOfHardware pieceOfHardware : this.hardwareList) {
            res.add(pieceOfHardware.getName());
        }
        return res;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        switch (alert.getAlertId()) {
            case "FCS001": {
                if (this.clientContext.socket.isConnected() && !this.clientContext.socket.isClosed()) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            case "FCS002": {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Publish booting information for all CANopen devices.")
    public void publishData() {
        for (PieceOfHardware device : this.hardwareList) {
            this.publishHardwareData(device);
        }
    }

    public void publishHardwareData(PieceOfHardware device) {
        StatusDataPublishedByHardware status = FcsUtils.createStatusDataPublishedByHardware(device);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":publishHardwareData is publishing:" + status));
        KeyValueData kvd = new KeyValueData(this.getName(), (Serializable)status);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Publish booting information for a CANopen device given by its CANopen nodeID.")
    public void publishHardwareData(String nodeID) {
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed format of PDOStorage.")
    public String printPDOStorage() {
        return this.pdoStorage.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/clientName=");
        sb.append(this.clientName);
        sb.append("/hardwareBootTimeout=");
        sb.append(this.hardwareBootTimeout);
        return sb.toString();
    }
}

