/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenPlutoGateway
extends PlutoGatewayModule {
    @ConfigurationParameter
    private final String station_addr;

    public CanOpenPlutoGateway(String nodeID, String serialNB, String station_addr) {
        super(nodeID, serialNB);
        this.station_addr = station_addr;
    }

    public String getStation_addr() {
        return this.station_addr;
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Initialize the Gateway.")
    public String initializeAndCheckHardware() {
        if (!this.isBooted()) {
            throw new FcsHardwareException(this.name + " is not booted - can't be initialized.");
        }
        try {
            FCSCst.FCSLOG.info((Object)(this.name + " BEGIN initializeHardware"));
            this.configurePlutoForThreeBlocs();
            this.initialized = true;
            FCSCst.FCSLOG.info((Object)(this.name + " is INITIALIZED."));
            this.tcpProxy.publishHardwareData(this);
            return this.name + " is INITIALIZED.";
        }
        catch (FailedCommandException | SDORequestException ex) {
            throw new FcsHardwareException(this.name, ex);
        }
    }

    @Override
    public void initModule() {
        super.initModule();
        Map.Entry entry = this.getComponentLookup().getParent(this.getName());
        BridgeToHardware bridge = (BridgeToHardware)entry.getValue();
        this.tcpProxy = (CanOpenProxy)bridge.getTcpProxy();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure this gateway to receive 3 data blocs from Pluto.")
    public String configurePlutoForThreeBlocs() {
        this.tcpProxy.writeSDO(this.getNodeID(), "2010", "01", "01", "01");
        this.tcpProxy.writeSDO(this.getNodeID(), "2011", "01", "02", this.station_addr + "01");
        this.tcpProxy.writeSDO(this.getNodeID(), "2011", "02", "02", this.station_addr + "02");
        this.tcpProxy.writeSDO(this.getNodeID(), "2012", "01", "02", this.station_addr + "03");
        this.tcpProxy.writeSDO(this.getNodeID(), "2002", "01", "01", "07");
        return this.name + " is configured.";
    }

    public String writeTransmissionType(String transmissionType) {
        String goodAck;
        if (transmissionType == null) {
            throw new IllegalArgumentException(this.getName() + ": Can't write transmission type to device because transmission type is null.");
        }
        String ack = this.tcpProxy.writeSDO(this.getNodeID(), "2005", "1", "1", transmissionType);
        if (!ack.equals(goodAck = "OK")) {
            throw new FailedCommandException(this.getName() + " :bad returned ack for wsdo, index 1801");
        }
        return String.format("Transmission type of device %s is now %s", this.name, transmissionType);
    }

    @Override
    public String[] readNewHexaValues() {
        if (!this.isBooted()) {
            throw new FcsHardwareException(this.name + " is not booted - can't read new values.");
        }
        try {
            this.hexaValues[0] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "01");
            FCSCst.FCSLOG.finest((Object)String.format("%s : first byte read in hexaValue= %s", this.name, this.hexaValues[0]));
            this.hexaValues[1] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "02");
            FCSCst.FCSLOG.finest((Object)String.format("%s : second byte read in hexaValue= %s", this.name, this.hexaValues[1]));
            this.hexaValues[2] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "03");
            FCSCst.FCSLOG.finest((Object)String.format("%s : third byte read in hexaValue= %s", this.name, this.hexaValues[2]));
            this.hexaValues[3] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "04");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 4th byte read in hexaValue= %s", this.name, this.hexaValues[3]));
            this.hexaValues[4] = this.tcpProxy.readSDO(this.getNodeID(), "6001", "01");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 5th byte read in hexaValue= %s", this.name, this.hexaValues[4]));
            this.hexaValues[5] = this.tcpProxy.readSDO(this.getNodeID(), "6001", "02");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 6th byte read in hexaValue= %s", this.name, this.hexaValues[5]));
            this.hexaValues[6] = this.tcpProxy.readSDO(this.getNodeID(), "6001", "03");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 7th byte read in hexaValue= %s", this.name, this.hexaValues[6]));
            this.hexaValues[7] = this.tcpProxy.readSDO(this.getNodeID(), "6001", "04");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 8th byte read in hexaValue= %s", this.name, this.hexaValues[7]));
            this.hexaValues[8] = this.tcpProxy.readSDO(this.getNodeID(), "6002", "01");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 9th byte read in hexaValue= %s", this.name, this.hexaValues[8]));
            this.hexaValues[9] = this.tcpProxy.readSDO(this.getNodeID(), "6002", "02");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 10th byte read in hexaValue= %s", this.name, this.hexaValues[9]));
            this.hexaValues[10] = this.tcpProxy.readSDO(this.getNodeID(), "6002", "03");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 11th byte read in hexaValue= %s", this.name, this.hexaValues[10]));
            this.hexaValues[11] = this.tcpProxy.readSDO(this.getNodeID(), "6002", "04");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 12th byte read in hexaValue= %s", this.name, this.hexaValues[11]));
            this.hexaValues[12] = this.tcpProxy.readSDO(this.getNodeID(), "6003", "01");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 13th byte read in hexaValue= %s", this.name, this.hexaValues[12]));
            this.hexaValues[13] = this.tcpProxy.readSDO(this.getNodeID(), "6003", "02");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 14th byte read in hexaValue= %s", this.name, this.hexaValues[13]));
            this.hexaValues[14] = this.tcpProxy.readSDO(this.getNodeID(), "6003", "03");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 15th byte read in hexaValue= %s", this.name, this.hexaValues[14]));
            this.hexaValues[15] = this.tcpProxy.readSDO(this.getNodeID(), "6003", "04");
            FCSCst.FCSLOG.finest((Object)String.format("%s : 16th byte read in hexaValue= %s", this.name, this.hexaValues[15]));
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.warning((Object)(this.name + "=> ERROR IN READING SENSOR:" + (Object)((Object)ex)));
        }
        catch (SDORequestException ex) {
            String message = this.name + "=> ERROR IN READING SENSOR:";
            this.raiseAlarm("FCS004:" + this.name, message, (Exception)((Object)ex));
        }
        return this.hexaValues;
    }

    @Override
    public int readNewAnalogValue() {
        String hexaL = this.tcpProxy.readSDO(this.getNodeID(), "6001", "01");
        FCSCst.FCSLOG.finest((Object)(this.name + ": new analog value in hexa=" + hexaL));
        String hexaM = this.tcpProxy.readSDO(this.getNodeID(), "6001", "02");
        String valueInHexa = hexaM + hexaL;
        FCSCst.FCSLOG.finest((Object)(this.name + ": new analog value in hexa=" + valueInHexa));
        int newAnalogValue = Integer.parseInt(valueInHexa, 16);
        FCSCst.FCSLOG.finest((Object)(this.name + ": new analog value =" + newAnalogValue));
        return newAnalogValue;
    }
}

