/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Map;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenEPOS
extends CanOpenDevice
implements EPOSController {
    private boolean turnedOff;
    private boolean parametersOK;
    protected EPOSEnumerations.EposMode mode;
    @ConfigurationParameter
    private Map<String, Integer> paramsForHoming;
    @ConfigurationParameter
    private Map<String, Integer> paramsForProfilePosition;
    @ConfigurationParameter
    private Map<String, Integer> paramsForCurrent;
    private boolean enabledToPublish;

    public CanOpenEPOS(String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB);
        this.paramsForCurrent = paramsForCurrent;
        this.paramsForProfilePosition = paramsForProfilePosition;
        this.paramsForHoming = paramsForHoming;
        this.turnedOff = false;
        this.parametersOK = true;
        this.enabledToPublish = false;
    }

    @Override
    public boolean isEnabledToPublish() {
        return this.enabledToPublish;
    }

    @Override
    public boolean isTurnedOff() {
        return this.turnedOff;
    }

    @Override
    public boolean isParametersOK() {
        return this.parametersOK;
    }

    @Override
    public Map<String, Integer> getParamsForHoming() {
        return this.paramsForHoming;
    }

    @Override
    public Map<String, Integer> getParamsForProfilePosition() {
        return this.paramsForProfilePosition;
    }

    @Override
    public Map<String, Integer> getParamsForCurrent() {
        return this.paramsForCurrent;
    }

    @ConfigurationParameterChanger
    public void setParamsForCurrent(Map<String, Integer> newMap) {
        this.paramsForCurrent.putAll(newMap);
        this.writeParameters(newMap);
        this.saveParameters();
    }

    @Command(description="Change a parameter for mode CURRENT, and write the new value on the CPU of the controller.", type=Command.CommandType.QUERY, level=1)
    public void changeParameterForCurrent(String clef, int value) {
        if (this.paramsForCurrent.containsKey(clef)) {
            this.paramsForCurrent.put(clef, value);
            String response = this.writeParameter(EPOSEnumerations.Parameter.valueOf((String)clef), value);
            if (!response.equals("OK")) {
                throw new IllegalArgumentException(this.getName() + " couldn't write parameter: " + clef + "with this value:" + value);
            }
        } else {
            throw new IllegalArgumentException(this.getName() + " paramsForCurrent doesn't contain this parameter:" + clef);
        }
        this.getComponentConfigurationEnvironment().change("paramsForCurrent", this.paramsForCurrent);
    }

    @Command(description="Change a parameter for mode ProfilePosition, and write the new value on the CPU of the controller.", type=Command.CommandType.QUERY, level=1)
    public void changeParameterForProfilePosition(String clef, int value) {
        if (this.paramsForProfilePosition.containsKey(clef)) {
            this.paramsForProfilePosition.put(clef, value);
            String response = this.writeParameter(EPOSEnumerations.Parameter.valueOf((String)clef), value);
            if (!response.equals("OK")) {
                throw new IllegalArgumentException(this.getName() + " couldn't write parameter: " + clef + "with this value:" + value);
            }
        } else {
            throw new IllegalArgumentException(this.getName() + " paramsForProfilePosition doesn't contain this parameter:" + clef);
        }
        this.getComponentConfigurationEnvironment().change("paramsForProfilePosition", this.paramsForProfilePosition);
    }

    @Command(description="Change a parameter for mode Homing, and write the new value on the CPU of the controller.", type=Command.CommandType.QUERY, level=1)
    public void changeParameterForHoming(String clef, int value) {
        if (this.paramsForHoming.containsKey(clef)) {
            this.paramsForHoming.put(clef, value);
            String response = this.writeParameter(EPOSEnumerations.Parameter.valueOf((String)clef), value);
            if (!response.equals("OK")) {
                throw new IllegalArgumentException(this.getName() + " couldn't write parameter: " + clef + "with this value:" + value);
            }
        } else {
            throw new IllegalArgumentException(this.getName() + " paramsForHoming doesn't contain this parameter:" + clef);
        }
        this.getComponentConfigurationEnvironment().change("paramsForHoming", this.paramsForHoming);
    }

    @Override
    public EPOSEnumerations.EposMode getMode() {
        return this.mode;
    }

    @Override
    public int getMaxCurrent() {
        return this.readParameter(EPOSEnumerations.Parameter.OutputCurrentLimit);
    }

    @Override
    public int getMinCurrent() {
        return this.readParameter(EPOSEnumerations.Parameter.OutputCurrentLimit);
    }

    @Override
    public int getMaxSpeed() {
        return this.readParameter(EPOSEnumerations.Parameter.MaxProfileVelocity);
    }

    @Override
    public int getMaxPosition() {
        return this.readParameter(EPOSEnumerations.Parameter.MaxPositionLimit);
    }

    @Override
    public int getMinPosition() {
        return this.readParameter(EPOSEnumerations.Parameter.MinPositionLimit);
    }

    public int getMotorParameterValue(String parameterName) throws EPOSConfigurationException {
        if (this.paramsForCurrent.containsKey(parameterName)) {
            return this.paramsForCurrent.get(parameterName);
        }
        throw new EPOSConfigurationException(parameterName + " :undefined", this.getName());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print the configured parameters for this EPOS for this mode.This command doesn't read the controlle.")
    public String printParameters() {
        if (this.mode == null) {
            this.mode = this.readMode();
        }
        return this.printConfigurationParameters(this.mode.toString());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print the configured parameters for this EPOS for a mode name given in argument. This command doesn't read the controller.")
    public String printConfigurationParameters(String modeInString) {
        if (modeInString == null) {
            throw new IllegalArgumentException("Mode name can't be null.");
        }
        EPOSEnumerations.EposMode aMode = EPOSEnumerations.EposMode.valueOf((String)modeInString.trim().toUpperCase());
        Map<String, Integer> paramsMap = null;
        switch (aMode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                throw new IllegalArgumentException(modeInString + "  is not a valid EPOS mode");
            }
        }
        if (paramsMap == null) {
            return "NO parameter defined in configuration file for mode:" + aMode;
        }
        return paramsMap.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Reads the EPOS mode in the CPU of the EPOS device and updates the field mode.")
    public EPOSEnumerations.EposMode readMode() {
        EPOSEnumerations.EposMode readMode;
        String modeInHexa = this.readSDO("6061", "0").trim().toUpperCase();
        this.mode = readMode = EPOSEnumerations.EposMode.getMode((String)modeInHexa);
        return readMode;
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change EPOS mode .")
    public String changeMode(String modeInString) {
        EPOSEnumerations.EposMode newMode = EPOSEnumerations.EposMode.valueOf((String)modeInString.trim().toUpperCase());
        return this.changeMode(newMode);
    }

    @Override
    public String changeMode(EPOSEnumerations.EposMode newMode) {
        this.writeSDO("6060", "0", "1", newMode.getModeInHexa());
        this.mode = newMode;
        this.publishData();
        return this.getName() + " mode has been changed to: " + newMode.toString() + ". Please check parameters associated with this mode.";
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="This methods reads in the CPU of the EPOS the values of the parameters for a given mode.")
    public String readParameters(String modeInString) {
        return this.readParameters(EPOSEnumerations.EposMode.valueOf((String)modeInString));
    }

    @Override
    public String readParameters(EPOSEnumerations.EposMode aMode) {
        EPOSEnumerations.Parameter[] params;
        String modeIS = aMode.toString();
        StringBuilder sb = new StringBuilder(this.getName() + " parameters VALUES in decimal format for mode ");
        sb.append(modeIS);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = aMode.getParameters()) {
            sb.append(param.toString());
            sb.append("=");
            int valueInt = this.readParameter(param);
            sb.append(valueInt);
            sb.append("\n");
        }
        FCSCst.FCSLOG.debug((Object)(this.getName() + sb.toString()));
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the parameters for the actual mode.")
    public String readParameters() {
        String modeStr = this.readMode().toString();
        return this.readParameters(modeStr);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="This methods writes in the CPU of the EPOS device the values of the parameters set for the mode.")
    public void writeParameters() {
        this.readMode();
        this.writeParameters(this.mode);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="This methods writes in the CPU of the EPOS device the values of the parameters set for the mode given as argument")
    public void writeParameters(String modeInString) {
        EPOSEnumerations.EposMode aMode = EPOSEnumerations.EposMode.valueOf((String)modeInString);
        this.writeParameters(aMode);
    }

    @Override
    public void writeParameters(EPOSEnumerations.EposMode mode) {
        String modeIS = mode.toString();
        Map<String, Integer> paramsMap = null;
        switch (mode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                assert (false) : mode;
                break;
            }
        }
        if (paramsMap == null) {
            throw new EPOSConfigurationException(this.getName() + "parameters for mode :" + modeIS + "are NULL");
        }
        if (paramsMap.isEmpty()) {
            throw new EPOSConfigurationException(this.getName() + "parameters for mode :" + modeIS + "are not defined.");
        }
        this.writeParameters(paramsMap);
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) {
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            this.writeParameter(paramName, value);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Set EPOS parameter with the value given as argument.")
    public String writeParameter(String parameterName, int value) {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf((String)parameterName);
        return this.writeParameter(param, value);
    }

    public String writeParameter(EPOSEnumerations.Parameter param, int value) {
        this.writeSDO(param.getIndex(), param.getSubindex(), param.getSize(), Integer.toHexString(value));
        return String.format("%s has been written to the CanEpos CPU, value=%d", param.toString(), value);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Set EPOS parameter with the hexadecimal value given as argument.")
    public String writeParameterInHexa(String parameterName, String hexaValue) {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf((String)parameterName);
        return this.writeParameterInHexa(param, hexaValue);
    }

    @Override
    public String writeParameterInHexa(EPOSEnumerations.Parameter param, String hexaValue) {
        this.writeSDO(param.getIndex(), param.getSubindex(), param.getSize(), hexaValue);
        return String.format("%s has been written to the CanEpos CPU, value=%s", param.toString(), hexaValue);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads in the EPOS CPU the decimal value of the Parameter which parameter name is given as argument.")
    public int readParameter(String parameterName) {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf((String)parameterName);
        return this.readParameter(param);
    }

    public int readParameter(EPOSEnumerations.Parameter param) {
        try {
            String valueInHexa = this.readSDO(param.getIndex(), param.getSubindex());
            int valueInDecimal = new BigInteger(valueInHexa, 16).intValue();
            FCSCst.FCSLOG.debug((Object)(this.getName() + " readParameter:" + param.name() + "=" + valueInDecimal + " in decimal format  (valueInHexa=" + valueInHexa + ")"));
            return valueInDecimal;
        }
        catch (SDORequestException | ShortResponseToSDORequestException ex) {
            String msg = this.getName() + " Error in reading Parameter: " + param;
            this.raiseWarning(this.getName(), msg, (Exception)ex);
            return 0;
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads in the EPOS CPU the hexadecimal value of the Parameter which parameter name is given as argument.")
    public String readParameterInHexa(String parameterName) {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf((String)parameterName);
        return this.readParameterInHexa(param);
    }

    public String readParameterInHexa(EPOSEnumerations.Parameter param) {
        return this.readSDO(param.getIndex(), param.getSubindex());
    }

    @Override
    public boolean isTargetPositionReached(int position) {
        return this.readPosition() == position;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read controller's parameter in the CPU for each mode and warn if a parameter has not the same value as in the configuration.Then publish data.")
    public String initializeAndCheckHardware() {
        if (!this.isBooted()) {
            throw new FcsHardwareException(this.getName() + " is not booted - can't be initialized.");
        }
        this.mode = this.readMode();
        this.parametersOK = true;
        this.checkParameters(EPOSEnumerations.EposMode.CURRENT);
        this.checkParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.checkParameters(EPOSEnumerations.EposMode.HOMING);
        this.checkFault();
        this.initialized = true;
        if (!this.parametersOK) {
            FCSCst.FCSLOG.warning((Object)(this.getName() + " Some parameter values are not the same in CPU and configuration system."));
        }
        this.tcpProxy.publishHardwareData(this);
        this.publishData();
        FCSCst.FCSLOG.info((Object)(this.getName() + ": is INITIALIZED."));
        return this.getName() + ": is INITIALIZED.";
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the controller is enabled.")
    public boolean isEnabled() {
        try {
            String statusWordInHexa = this.readStatusWord();
            int statusWord = Integer.parseInt(statusWordInHexa, 16);
            int[] statusWordInBinary = FcsUtils.toReverseBinary(statusWord);
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[0]=" + statusWordInBinary[0]));
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[1]=" + statusWordInBinary[1]));
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[2]=" + statusWordInBinary[2]));
            FCSCst.FCSLOG.debug((Object)(this.getName() + ":statusWordInBinary[3]=" + statusWordInBinary[3]));
            return statusWordInBinary[0] == 1 && statusWordInBinary[1] == 1 && statusWordInBinary[2] == 1 && statusWordInBinary[3] == 0;
        }
        catch (ShortResponseToSDORequestException ex) {
            String msg = this.getName() + " couldn't read status word because ShortResponseToSDORequestException :" + ex.getMessage();
            FCSCst.FCSLOG.error((Object)msg);
            FCSCst.FCSLOG.error((Object)ex);
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="This methods enables the controller : i.e. this makes it able to receive commands.")
    public String enable() {
        this.shutdown();
        this.switchOnEnableOperation();
        this.enabledToPublish = true;
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": is ENABLED."));
        return this.getName() + " ENABLED";
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Shutdown the controller.")
    public String shutdown() {
        this.writeControlWord("6");
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": is SHUTDOWN."));
        return this.getName() + " DISABLED";
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="writeControlWord(\"F\")")
    public void switchOnEnableOperation() {
        this.writeControlWord("F");
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Restore default parameters. AT YOUR OWN RISK.")
    public Object restoreParameters() {
        return this.writeSDO("1011", "1", "4", "64616F6C");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Write a value in hexa in the control world (index=6040, subindex=0,size=2)")
    public void writeControlWord(String value) {
        this.writeSDO("6040", "0", "2", value);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the control world (index=6040, subindex=0,size=2)")
    public String readControlWord() {
        return this.readSDO("6040", "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the status world (index=6041, subindex=0,size=2)")
    public String readStatusWord() {
        return this.readSDO("6041", "0");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="QuickStop.")
    public void quickStop() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " running QUICKSTOP command."));
        if (this.mode.equals((Object)EPOSEnumerations.EposMode.HOMING) || this.mode.equals((Object)EPOSEnumerations.EposMode.PROFILE_POSITION) || this.mode.equals((Object)EPOSEnumerations.EposMode.VELOCITY)) {
            this.writeControlWord("B");
        } else if (this.mode.equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            this.writeControlWord("2");
        } else {
            throw new IllegalArgumentException(this.getName() + " has invalid Epos mode:" + this.mode);
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Turn OFF controller (in mode CURRENT, stop CURRENT) and shutdown.")
    public String off() {
        switch (this.mode) {
            case HOMING: {
                this.writeControlWord("11F");
                break;
            }
            case PROFILE_POSITION: {
                this.writeControlWord("10F");
                break;
            }
            case CURRENT: {
                this.stopCurrent();
                break;
            }
            default: {
                assert (false) : this.mode;
                break;
            }
        }
        this.shutdown();
        this.turnedOff = true;
        FCSCst.FCSLOG.info((Object)(this.getName() + " is TURNED OFF"));
        return this.getName() + " OFF";
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Set the current value in the EPOS CPU.")
    public void writeCurrent(int aValue) {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            throw new RejectedCommandException(this.getName() + " is not in CURRENT mode.");
        }
        if (!this.isEnabled()) {
            throw new RejectedCommandException(this.getName() + " is not ENABLED.");
        }
        try {
            if (aValue > this.getMotorParameterValue("ContinuousCurrentLimit")) {
                throw new IllegalArgumentException(aValue + " is greater than Continuous Current Limit.");
            }
        }
        catch (EPOSConfigurationException ex) {
            FCSCst.FCSLOG.error((Object)(this.getName() + " ERROR in command writeCurrent:" + (Object)((Object)ex)));
            throw new FcsHardwareException(this.getName() + ": ContinuousCurrentLimit is not defined.", (Throwable)ex);
        }
        String currentValueInHexa = Integer.toHexString(aValue);
        this.writeSDO("2030", "0", "2", currentValueInHexa);
        this.turnedOff = false;
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": sent current to controller=" + aValue));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="readCurrentActualValue", description="In Current Mode this methods returns the current actualy received by the motor.")
    public int readCurrent() {
        String currentInHexa = this.readSDO("6078", "0");
        int uns16 = Integer.parseInt(currentInHexa, 16);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readCurrent=" + FcsUtils.convertToInteger16(uns16) + " Unsigned value read=" + uns16));
        return FcsUtils.convertToInteger16(uns16);
    }

    @Command(type=Command.CommandType.QUERY, level=1, alias="readCurrentAverage", description="In Current Mode this methods returns the average of the current  received by the motor.")
    public int readCurrentAverageValue() {
        String currentInHexa = this.readSDO("2027", "0");
        int uns16 = Integer.parseInt(currentInHexa, 16);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readAverageCurrent=" + FcsUtils.convertToInteger16(uns16) + " Unsigned value read=" + uns16));
        return FcsUtils.convertToInteger16(uns16);
    }

    public void stopCurrent() {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            throw new RejectedCommandException(this.getName() + "is not in CURRENT mode");
        }
        this.writeSDO("2030", "00", "2", "0");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="readPositionActualValue", description="In PROFILE_POSITION Mode this methods returns the actual position.")
    public int readPosition() {
        int positionActualValue = this.readParameter(EPOSEnumerations.Parameter.PositionActualValue);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readPosition=" + positionActualValue));
        return positionActualValue;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read the position returned by the absolute encoder (single serial data).")
    public int readSSIPosition() {
        return this.readParameter(EPOSEnumerations.Parameter.SSIEncoderActualPosition);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="In PROFILE_POSITION returns the value of the parameter ProfileVelocity.")
    public int readProfileVelocity() {
        int profileVelocity = this.readParameter(EPOSEnumerations.Parameter.ProfileVelocity);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readProfileVelocity=" + profileVelocity));
        return profileVelocity;
    }

    public String setHomingMethodActual() {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.HOMING)) {
            throw new RejectedCommandException(this.getName() + "is not in HOMING mode");
        }
        return this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 35);
    }

    public void startHoming() {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.HOMING)) {
            throw new RejectedCommandException(this.getName() + "is not in HOMING mode");
        }
        this.writeControlWord("1F");
    }

    public String setHomePosition(int position) {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.HOMING)) {
            throw new RejectedCommandException(this.getName() + "is not in HOMING mode");
        }
        return this.writeParameter(EPOSEnumerations.Parameter.HomePosition, position);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    public void defineAbsolutePosition(int position) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " Defining Absolute Position:" + position));
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameters(EPOSEnumerations.EposMode.HOMING);
        if (!this.isEnabled()) {
            this.enable();
        }
        this.setHomePosition(position);
        this.setHomingMethodActual();
        this.writeControlWord("3F");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position. Target position has to be given in microns.")
    public void writeTargetPosition(int aValue) {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new RejectedCommandException(this.getName() + "is not in PROFILE_POSITION mode");
        }
        if (!this.isEnabled()) {
            throw new RejectedCommandException(this.getName() + "is not ENABLED");
        }
        String targetPositionInHexa = Integer.toHexString(aValue);
        this.writeSDO("607A", "0", "4", targetPositionInHexa);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="In HOMING mode and PROFILE_POSITION mode this indicates that the position is reached.")
    public boolean checkTargetReached() {
        String statusWordInHexa = this.readStatusWord();
        int statusWord = Integer.parseInt(statusWordInHexa, 16);
        int[] statusWordInBinary = FcsUtils.toReverseBinary(statusWord);
        return statusWordInBinary[10] == 1;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() {
        if (!this.booted) {
            throw new FcsHardwareException(this.getName() + " is not booted - can't checkFault.");
        }
        if (this.readNumberOfErrors() > 0) {
            this.inError = true;
            String errorInHexa = this.readErrorRegister();
            this.errorRegister = CanOpenErrorsTable.getErrorRegisterNameByCode(errorInHexa);
            this.errorHistory = this.readErrorHistoryNames();
            this.setChanged();
            this.notifyObservers(new Module.ValueUpdate((Module)this, this.getName(), (Object)"checkFault"));
            this.publishData();
            String errorHistoryString = this.displayErrorHistory();
            throw new FcsHardwareException(this.getName() + " is in fault. " + errorHistoryString);
        }
        this.inError = false;
        this.errorRegister = "NO ERROR";
        this.errorHistory = new String[0];
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.getName(), (Object)"faultReset"));
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clear faults on the controller.", alias="resetFault")
    public void faultReset() {
        this.writeControlWord("80");
        this.inError = false;
        this.errorRegister = "NO ERROR";
        this.errorHistory = new String[0];
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.getName(), (Object)"faultReset"));
        this.publishData();
    }

    @Override
    public void checkParameters(EPOSEnumerations.EposMode aMode) {
        Map<String, Integer> paramsMap = null;
        switch (aMode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (paramsMap == null) {
            throw new FcsHardwareException(this.getName() + "parameters for mode :" + aMode.toString() + "are NULL in configuration system.");
        }
        if (paramsMap.isEmpty()) {
            throw new FcsHardwareException(this.getName() + "parameters for mode :" + aMode.toString() + "are not defined in configuration system.");
        }
        this.checkParameters(paramsMap);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="For every parameter to be defined for this mode this method compares the values in configuration with the value stored in controller CPUand throws a HardwareException if these values are not equal.")
    public void checkParameters(String modeInString) {
        EPOSEnumerations.EposMode aMode = EPOSEnumerations.EposMode.valueOf((String)modeInString.trim().toUpperCase());
        this.checkParameters(aMode);
    }

    public void checkParameters(Map<String, Integer> paramsMap) {
        boolean errorFound = false;
        StringBuilder sb = new StringBuilder(this.getName());
        for (Map.Entry<String, Integer> entry : paramsMap.entrySet()) {
            int controllerValue;
            String paramName = entry.getKey();
            int configValue = entry.getValue();
            if (configValue == (controllerValue = this.readParameter(paramName))) continue;
            String msg = " ERROR in CPU controller for parameter=" + paramName + " value found in configuration=" + configValue + " value read in CPU=" + controllerValue + "\n";
            this.raiseWarning(this.getName(), msg);
            sb.append(msg);
            errorFound = true;
            this.writeParameter(paramName, configValue);
        }
        this.parametersOK = !errorFound;
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change mode to CURRENT mode and initialize theCURRENT mode parameters from configuration values.")
    public void activateCurrentMode() {
        this.changeMode(EPOSEnumerations.EposMode.CURRENT);
        this.writeParameters(this.paramsForCurrent);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change mode to HOMING mode and initialize theHOMING mode parameters from configuration values.")
    public void activateHomingMode() {
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameters(this.paramsForHoming);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change mode to PROFILE_POSITION mode and initialize thePROFILE_POSITION mode parameters from configuration values.")
    public void activateProfilePositionMode() {
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeParameters(this.paramsForProfilePosition);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Put the brake on to prevent the trucks motion.")
    public void activateBrake() {
        String hexaValue = this.readParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2zero(hexaValue, 15));
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": brake activated."));
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Release the brake in order to be able to move the trucks.")
    public void releaseBrake() {
        if (!this.isEnabled()) {
            this.enable();
        }
        String hexaValue = this.readParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2one(hexaValue, 15));
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": brake released."));
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Activate the holding brake and shutdown the controller.")
    public void disable() {
        this.activateBrake();
        this.shutdown();
        this.enabledToPublish = false;
    }

    public StatusDataPublishedByEPOSController getStatusData() {
        return FcsUtils.createStatusDataPublishedByEPOSController(this);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="refreshGUI", description="Publish data for the controller on the status bus.")
    public void publishData() {
        KeyValueData kvd = new KeyValueData(this.getName(), (Serializable)this.getStatusData());
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }
}

