/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;

public class CanOpenADC
extends CanOpenDevice
implements ADCInterface {
    public static final double adcVoltsPerBit = 0.3125;
    public static final double waterFreezeTemp = 273.15;
    @ConfigurationParameter
    protected String transmissionType;

    public CanOpenADC(String nodeID, String serialNB, String transmissionType) {
        super(nodeID, serialNB);
        this.transmissionType = transmissionType;
    }

    @Override
    public String readAnalogInput(int inputNB) {
        if (!this.bridge.isCWrapperConnected()) {
            throw new HardwareNotDetectedException(this.name + ": hardware not connected.");
        }
        if (this.isBooted()) {
            if (inputNB < 1 || inputNB > 8) {
                throw new IllegalArgumentException("CAN-CBX-AI814 : input has to be 1..8");
            }
            String input = Integer.toHexString(inputNB);
            return this.tcpProxy.readSDO(this.nodeID, "6401", input);
        }
        String message = String.format("Module %s / nodeID=%s is UNREACHABLE", this.getName(), this.nodeID);
        FCSCst.FCSLOG.error((Object)message);
        throw new HardwareNotDetectedException("CanOpenADC MISSING", this.getName(), this.nodeID, this.serialNB);
    }

    @Override
    public double readVoltage(int inputNB) {
        String hexa = this.readAnalogInput(inputNB);
        int valueInt = Integer.parseInt(hexa, 16);
        return (double)valueInt * 0.3125;
    }

    @Override
    public String initializeAndCheckHardware() {
        super.initializeAndCheckHardware();
        this.writeTransmissionTypeToDevice();
        this.initialized = true;
        return this.getName() + "is initialized with transmission type =" + this.transmissionType;
    }

    protected String writeTransmissionTypeToDevice() {
        if (this.transmissionType == null) {
            throw new IllegalArgumentException(this.getName() + ": Can't write transmission type to device because transmaission type is null.");
        }
        this.tcpProxy.writeSDO(this.nodeID, "1801", "2", "1", this.transmissionType);
        this.tcpProxy.writeSDO(this.nodeID, "1802", "2", "1", this.transmissionType);
        return String.format("Transmission type of device %s is now %s", this.name, this.transmissionType);
    }
}

