/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.nio.file.FileSystemNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;

public class BridgeToCanOpenHardware
extends Module
implements BridgeToHardware {
    protected CanOpenProxy tcpProxy;
    private final ArrayList<PieceOfHardware> devices = new ArrayList();
    protected boolean configurationChecked = false;
    protected boolean hardwareInitialized = false;
    protected final Map<String, PieceOfHardware> hardwareMapByName = new HashMap<String, PieceOfHardware>();

    public BridgeToCanOpenHardware(CanOpenProxy tcpProxy) {
        this.tcpProxy = tcpProxy;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print my hardware list; for tests")
    public String printHardwareList() {
        return this.hardwareMapByName.toString();
    }

    @Override
    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    @Override
    public void startServer() {
        this.tcpProxy.startServer();
    }

    @Override
    public void startThreadReader() {
        this.tcpProxy.startThreadReader();
    }

    @Override
    public boolean isCWrapperConnected() {
        return this.tcpProxy.isReady(this.tcpProxy.getMyClientName());
    }

    @Override
    public boolean isCANDevicesReady() {
        return this.tcpProxy.isCANDevicesReady();
    }

    @Override
    public boolean isRealHardware() {
        return true;
    }

    public void initModule() {
        ComponentLookup lookup = this.getComponentLookup();
        this.hardwareMapByName.putAll(lookup.getChildren(this.getName(), PieceOfHardware.class));
        this.devices.addAll(this.hardwareMapByName.values());
        FCSCst.FCSLOG.info((Object)(this.getName() + ": init MODULE BRIDGE TO HARDWARE."));
        this.tcpProxy.setHardwareList(this.devices);
        FCSCst.FCSLOG.info((Object)(this.getName() + ":NUMBER OF CAN OPEN DEVICES EXPECTED =" + this.devices.size()));
        FCSCst.FCSLOG.info((Object)this.toString());
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        }
        catch (DeploymentException ex) {
            String msg = (Object)((Object)ex) + ": Could not load CanOpen Error Tables";
            FCSCst.FCSLOG.error((Object)msg);
            throw new FileSystemNotFoundException(msg);
        }
    }

    @Override
    public PDOStorage readPDOs() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + "/readPDOS"));
        return this.tcpProxy.readPDOs();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getName()));
        sb.append(",tcpProxy:");
        sb.append(String.valueOf(this.tcpProxy.toString()));
        sb.append(",devices:");
        sb.append(this.hardwareMapByName);
        return sb.toString();
    }
}

