/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.Observable;
import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;

public interface MovedByEPOSController
extends UsesSubsystem {
    public String getControllerName();

    public boolean isControllerInFault();

    public void setControllerInFault(boolean var1);

    public void publishData();

    default public void processUpdate(Observable source, Module.ValueUpdate v) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":=" + source.toString() + " ValueUpdate=" + v.getName()));
        if (source instanceof EPOSController && v.getName().equals(this.getControllerName())) {
            if (v.getValue() instanceof EmergencyMessage) {
                EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
                FCSCst.FCSLOG.debug((Object)(this.getName() + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()));
                this.processEmergencyMessage(emcyMsg);
            } else if (v.getValue() instanceof String) {
                if ("faultReset".equals((String)v.getValue())) {
                    this.processFaultReset();
                } else if ("checkFault".equals((String)v.getValue())) {
                    this.setControllerInFault(true);
                }
            }
        }
        this.publishData();
    }

    default public void processEmergencyMessage(EmergencyMessage emcyMsg) {
        if (this.getControllerName().equals(emcyMsg.getDeviceName())) {
            String errCode;
            switch (errCode = emcyMsg.getDeviceErrorCode()) {
                case "00": {
                    FCSCst.FCSLOG.debug((Object)(this.getName() + ":faultReset ?=" + emcyMsg.toString()));
                    this.setControllerInFault(false);
                    break;
                }
                default: {
                    FCSCst.FCSLOG.debug((Object)(this.getName() + ":EmergencyMessage received for my controller from CanOpenProxy=" + emcyMsg.toString()));
                    this.setControllerInFault(true);
                }
            }
            this.publishData();
        }
    }

    default public void processFaultReset() {
        this.setControllerInFault(false);
    }
}

