/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class MobileItemModule
extends Module
implements HardwareController,
AlertRaiser {
    protected static final Logger FCSLOG = FCSCst.FCSLOG;
    protected volatile boolean hasToWaitForEndOfAction = false;
    protected volatile FcsEnumerations.MobileItemAction currentAction;
    protected volatile boolean moving = false;
    protected final Lock lock = new ReentrantLock();
    protected final Condition motionCompleted = this.lock.newCondition();
    private ScheduledFuture<?> readSensorsHandle;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    protected AtomicBoolean haltRequired = new AtomicBoolean();
    protected AtomicBoolean stopRequired;

    public MobileItemModule() {
        this.haltRequired.set(false);
        this.stopRequired = new AtomicBoolean();
        this.stopRequired.set(false);
    }

    public MobileItemModule(int tickMillis) {
        super(tickMillis);
        this.haltRequired.set(false);
        this.stopRequired = new AtomicBoolean();
        this.stopRequired.set(false);
    }

    public boolean isMoving() {
        return this.moving;
    }

    public AtomicBoolean getHaltRequired() {
        return this.haltRequired;
    }

    private void cancelReadingSensors() {
        this.lock.lock();
        try {
            FCSLOG.debug((Object)(this.getName() + " => stop reading sensors"));
            this.motionCompleted.signal();
        }
        finally {
            this.lock.unlock();
        }
        this.readSensorsHandle.cancel(true);
        FCSLOG.debug((Object)(this.getName() + " => readingSensors canceled"));
    }

    public void initModule() {
        super.initModule();
        FCSLOG.info((Object)(this.getName() + ": init MODULE"));
    }

    public abstract boolean isCANDevicesReady();

    public abstract boolean isActionCompleted(FcsEnumerations.MobileItemAction var1);

    public abstract void updateStateWithSensorsToCheckIfActionIsCompleted();

    public abstract void startAction(FcsEnumerations.MobileItemAction var1);

    public abstract void abortAction(FcsEnumerations.MobileItemAction var1, long var2);

    public abstract void quickStopAction(FcsEnumerations.MobileItemAction var1, long var2);

    public abstract void postAction(FcsEnumerations.MobileItemAction var1);

    public abstract void publishData();

    protected String executeAction(FcsEnumerations.MobileItemAction action, long timeoutForAction) {
        if (!this.isCANDevicesReady()) {
            throw new FcsHardwareException(this.getName() + ": hardware is not ready to execute ACTION commands.");
        }
        this.lock.lock();
        try {
            this.hasToWaitForEndOfAction = true;
            this.currentAction = action;
            this.moving = true;
            FCSLOG.info((Object)(this.getName() + ": ===> STARTING ACTION:" + action.toString()));
            this.startAction(action);
            this.readSensorsUntilActionIsCompleted(action, System.currentTimeMillis(), timeoutForAction);
            this.waitForEndOfAction(action);
            if (this.haltRequired.get()) {
                this.abortAction(action, 0L);
                this.moving = false;
                FCSLOG.info((Object)(this.getName() + "=> Received an ABORT command for action :" + action.toString()));
                String string = this.getName() + "=> Received an ABORT command for action :" + action.toString();
                return string;
            }
            if (this.stopRequired.get()) {
                this.quickStopAction(action, 0L);
                this.moving = false;
                FCSLOG.info((Object)(this.getName() + "=> Received a STOP command for action :" + action.toString()));
                String string = this.getName() + "=> Received a STOP command for action :" + action.toString();
                return string;
            }
            if (this.isActionCompleted(action)) {
                this.moving = false;
                this.postAction(action);
                FCSLOG.info((Object)(this.getName() + " ===> ACTION COMPLETED : " + action.doneString()));
                String string = this.getName() + " " + action.doneString();
                return string;
            }
            throw new FailedCommandException(this.getName() + "=>" + action.getFailureMsg());
        }
        finally {
            FCSLOG.debug((Object)(this.getName() + ": finally in executeAction."));
            this.abortAction(action, 0L);
            this.moving = false;
            this.hasToWaitForEndOfAction = false;
            this.motionCompleted.signal();
            this.haltRequired.set(false);
            this.stopRequired.set(false);
            this.lock.unlock();
            FCSLOG.info((Object)(this.getName() + " ===> END ACTION:" + action.toString()));
            this.publishData();
        }
    }

    public void readSensorsUntilActionIsCompleted(final FcsEnumerations.MobileItemAction action, final long beginTime, final long timeout) {
        Runnable readSensors = new Runnable(){

            @Override
            public void run() {
                try {
                    FCSLOG.info((Object)(MobileItemModule.this.getName() + " : reading sensors"));
                    long duration = System.currentTimeMillis() - beginTime;
                    MobileItemModule.this.updateStateWithSensorsToCheckIfActionIsCompleted();
                    boolean actionCompleted = MobileItemModule.this.isActionCompleted(action);
                    if (MobileItemModule.this.haltRequired.get() || MobileItemModule.this.stopRequired.get()) {
                        MobileItemModule.this.hasToWaitForEndOfAction = false;
                        FCSLOG.info((Object)(MobileItemModule.this.getName() + ":" + action.toString() + " ABORT or STOP REQUESTED FOR ACTION BY ABORT or STOP COMMAND"));
                        MobileItemModule.this.cancelReadingSensors();
                    } else if (actionCompleted) {
                        MobileItemModule.this.hasToWaitForEndOfAction = false;
                        FCSLOG.info((Object)(MobileItemModule.this.getName() + ":" + action.toString() + " ACTION COMPLETED"));
                        MobileItemModule.this.cancelReadingSensors();
                    } else {
                        if (duration >= timeout) {
                            MobileItemModule.this.hasToWaitForEndOfAction = false;
                            FCSLOG.info((Object)(MobileItemModule.this.getName() + ":" + action.toString() + " ACTION NOT COMPLETED during allocated time"));
                            MobileItemModule.this.cancelReadingSensors();
                            throw new FcsHardwareException(MobileItemModule.this.getName() + ":" + action.toString() + " exceeded timeout for this task: duration=" + duration + ",timeout=" + timeout);
                        }
                        FCSLOG.info((Object)(MobileItemModule.this.getName() + ":" + action.toString() + " not completed....."));
                        FCSLOG.info((Object)(MobileItemModule.this.getName() + ":" + action.name() + "/duration=" + duration));
                    }
                }
                catch (Exception ex) {
                    MobileItemModule.this.hasToWaitForEndOfAction = false;
                    String errorMsg = MobileItemModule.this.getName() + ":ERROR during action:" + ex;
                    MobileItemModule.this.cancelReadingSensors();
                    MobileItemModule.this.raiseAlarm("FCS005:" + MobileItemModule.this.getName(), errorMsg, ex);
                }
            }
        };
        this.readSensorsHandle = this.scheduler.scheduleAtFixedRate(readSensors, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void waitForEndOfAction(FcsEnumerations.MobileItemAction action) {
        while (this.hasToWaitForEndOfAction) {
            try {
                FCSLOG.info((Object)(this.getName() + " waiting for end of " + action.toString()));
                this.motionCompleted.await();
            }
            catch (InterruptedException ex) {
                FCSLOG.info((Object)(this.getName() + ": InterruptedException received=" + ex.toString()));
                break;
            }
        }
        FCSLOG.info((Object)(this.getName() + " STOP WAITING FOR END OF ACTION"));
    }

    private void halt(FcsEnumerations.MobileItemAction action, long delay) {
        if (action == null) {
            FCSLOG.warning((Object)(this.getName() + ": no current action running => nothing to abort."));
            return;
        }
        try {
            FCSLOG.debug((Object)(this.getName() + ": ABORTING ACTION " + action.toString() + "within delay=" + delay));
            this.abortAction(action, delay);
            this.moving = false;
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            String errorMsg = " couldn't abort action " + action.toString();
            this.raiseAlarm("FCS005:" + this.getName(), errorMsg, (Exception)ex);
        }
    }

    private void quickStop(FcsEnumerations.MobileItemAction action, long delay) {
        if (action == null) {
            FCSLOG.warning((Object)(this.getName() + ": no current action running => nothing to stop."));
            return;
        }
        try {
            FCSLOG.debug((Object)(this.getName() + ": QUICKSTOP for" + action.toString() + "within delay=" + delay));
            this.quickStopAction(action, delay);
            this.moving = false;
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            String errorMsg = this.getName() + " couldn't do stop action " + action.toString();
            this.raiseAlarm("FCS005:" + this.getName(), errorMsg, (Exception)ex);
        }
    }

    @Command(type=Command.CommandType.SIGNAL, level=1, description="Abort the running action within a delay.")
    public void abort(long delay) {
        this.sendSignalWithTimeLimit("HALT", delay);
    }

    @Command(type=Command.CommandType.SIGNAL, level=1, description="Abort the running action.")
    public void abort() {
        this.abort(0L);
    }

    @Command(type=Command.CommandType.SIGNAL, level=1, description="Stop the running action with a quickstop.")
    public void stop(long delay) {
        this.sendSignalWithTimeLimit("STOP", delay);
    }

    @Command(type=Command.CommandType.SIGNAL, level=1, description="Stop the running action with a quickstop.")
    public void stop() {
        this.stop(0L);
    }

    @Command(type=Command.CommandType.SIGNAL, level=1, description="Stop the running action with a quickstop.")
    public void quickstop() {
        this.stop(0L);
    }

    public void shutdownNow() {
        super.shutdownNow();
        this.scheduler.shutdown();
    }

    public TreeWalkerDiag signal(Signal signal) {
        SignalLevel sl = signal.getLevel();
        FCSLOG.info((Object)sl.toString());
        if (!this.moving) {
            FCSLOG.warning((Object)(this.getName() + " is not moving; nothing to stop."));
        } else {
            switch (signal.getLevel()) {
                case HALT: {
                    FCSLOG.info((Object)(this.getName() + " HALT required"));
                    this.haltRequired.set(true);
                    this.halt(this.currentAction, signal.getTimeHint());
                    break;
                }
                case STOP: {
                    FCSLOG.info((Object)(this.getName() + " STOP required"));
                    this.stopRequired.set(true);
                    this.quickStop(this.currentAction, signal.getTimeHint());
                    break;
                }
                case RE_START: {
                    this.haltRequired.set(false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() throws HardwareException {
    }

    public void checkStopped() throws HardwareException {
        if (this.isMoving()) {
            throw new HardwareException(false, this.getName() + " is moving, has to be stopped before a shutdown.");
        }
    }
}

