/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;

public interface EPOSController
extends PieceOfHardware {
    public boolean isTurnedOff();

    public String off();

    public int getMaxCurrent();

    public int getMinCurrent();

    public int getMaxSpeed();

    public int getMaxPosition();

    public int getMinPosition();

    public boolean isParametersOK();

    public String changeMode(EPOSEnumerations.EposMode var1);

    @Command(type=Command.CommandType.ACTION, level=1, description="Defines the actual position as the absolute position which value is given as an argument.")
    public void defineAbsolutePosition(int var1);

    public int readNumberOfErrors();

    public String displayErrorHistory();

    public void checkFault();

    public void writeParameters(EPOSEnumerations.EposMode var1);

    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.")
    public void writeTargetPosition(int var1);

    public void writeParameters(Map<String, Integer> var1);

    @Command(type=Command.CommandType.ACTION, level=1, description="In current mode this methods send a current to the motor.")
    public void writeCurrent(int var1) throws EPOSConfigurationException;

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the target position has been reached.")
    public boolean isTargetPositionReached(int var1);

    public int readPosition();

    public int readSSIPosition();

    public int readCurrent();

    public String readParameters(EPOSEnumerations.EposMode var1);

    public int readProfileVelocity();

    public String enable();

    public boolean isEnabled();

    public EPOSEnumerations.EposMode readMode();

    public void quickStop();

    public void checkParameters(String var1) throws HardwareException;

    public void checkParameters(EPOSEnumerations.EposMode var1) throws HardwareException;

    public void writeControlWord(String var1);

    public String shutdown();

    public boolean checkTargetReached();

    public void activateBrake();

    public void releaseBrake();

    public void switchOnEnableOperation();

    public Map<String, Integer> getParamsForCurrent();

    public Map<String, Integer> getParamsForHoming();

    public Map<String, Integer> getParamsForProfilePosition();

    public EPOSEnumerations.EposMode getMode();

    public boolean isEnabledToPublish();

    public boolean isInError();

    public String getErrorRegister();

    public String[] getErrorHistory();

    public String writeParameterInHexa(EPOSEnumerations.Parameter var1, String var2);

    public void disable();
}

