/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.TcpProxyInterface;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class MainModule
extends Module
implements AlertRaiser {
    protected BridgeToHardware bridge;
    protected AtomicBoolean haltRequired;
    protected AtomicBoolean stopRequired;

    public MainModule(BridgeToHardware bridge) {
        super(3000);
        this.bridge = bridge;
    }

    public AtomicBoolean getHaltRequired() {
        return this.haltRequired;
    }

    public AtomicBoolean getStopRequired() {
        return this.stopRequired;
    }

    public void initModule() {
        this.haltRequired = new AtomicBoolean(false);
        this.stopRequired = new AtomicBoolean(false);
        String msg = this.controlRealHardware() ? "Real Hardware" : "Simulation";
        FCSCst.FCSLOG.info((Object)(this.getName() + "==>" + msg));
    }

    public void postStart() throws HardwareException {
        super.postStart();
        FCSCst.FCSLOG.fine((Object)(this.getName() + ":postStart begins."));
        try {
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        FCSCst.FCSLOG.fine((Object)(this.getName() + ":postStart ends."));
    }

    @Command(level=1, type=Command.CommandType.QUERY, description="Return true if hardware is booted, identified and initialized.")
    public boolean isCANDevicesReady() {
        return this.bridge.isCANDevicesReady();
    }

    @Command(type=Command.CommandType.QUERY, description="Return true if this main module controls real hardware.")
    public boolean controlRealHardware() {
        return this.bridge.isRealHardware();
    }

    @Command(level=1, description="Return a printed list of CANopen hardware that this subsystem manages.", type=Command.CommandType.QUERY)
    public String printHardwareList() {
        return this.bridge.getTcpProxy().printHardwareList();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the list if initialized hardware for debug purpose.")
    public String printHardwareState() {
        return this.bridge.getTcpProxy().printHardwareState();
    }

    @Command(level=1, description="Return the list of CANopen hardware that this subsystem manages.", type=Command.CommandType.QUERY)
    public List<String> listHardwareNames() {
        return this.bridge.getTcpProxy().listHardwareNames();
    }

    @Command(level=1, description="Return the list of LOADER CANopen hardware that this subsystem manages.", type=Command.CommandType.QUERY)
    public List<String> listLoaderHardwareNames() {
        return Collections.EMPTY_LIST;
    }

    @Command(type=Command.CommandType.QUERY, description="Return the list of names of filters  that this subsystem manages.", level=1, alias="listFilterNames")
    public List<String> getFilterNames() {
        FilterManager filterManager = (FilterManager)((Object)this.getComponentLookup().getComponentByName("filterManager"));
        if (filterManager == null) {
            return Collections.EMPTY_LIST;
        }
        return filterManager.getFilterNamesSortedByFilterID();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Update state in reading sensors.")
    public void updateStateWithSensors() {
        this.getTcpProxy().publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSState() {
        if (this.isCANDevicesReady()) {
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.HARDWARE_READY, FcsEnumerations.FilterReadinessState.READY});
        }
    }

    public TcpProxyInterface getTcpProxy() {
        return this.bridge.getTcpProxy();
    }

    public TreeWalkerDiag signal(Signal signal) {
        switch (signal.getLevel()) {
            case HALT: {
                FCSCst.FCSLOG.debug((Object)"HALT required");
                this.haltRequired.set(true);
                break;
            }
            case STOP: {
                FCSCst.FCSLOG.debug((Object)"STOP required");
                this.stopRequired.set(true);
                break;
            }
            case INTERRUPT1: {
                FCSCst.FCSLOG.debug((Object)"INTERRUPT1 required");
                break;
            }
            case INTERRUPT2: {
                FCSCst.FCSLOG.debug((Object)"INTERRUPT2 required");
                break;
            }
            case RE_START: {
                this.haltRequired.set(false);
                this.stopRequired.set(false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return TreeWalkerDiag.GO;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="For tests purpose only - raise an ALERT.")
    public void simulateAlert(String errorId, String alarmMsg) {
        FCSCst.FCSLOG.error((Object)"A fake Alert has been raised.");
        String message = alarmMsg == null ? "COUCOU c'est une blague !" : alarmMsg;
        String fcsErrorId = errorId == null ? "FCS002" : errorId;
        this.raiseAlarm(fcsErrorId, message, "cause");
        this.raiseAlarm(fcsErrorId + "sans_cause", message);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="For tests purpose only - raise an ALERT.")
    public void simulateWarning(String errorId, String alarmMsg) {
        FCSCst.FCSLOG.error((Object)"A fake Alert has been raised.");
        String message = alarmMsg == null ? "COUCOU c'est une blague !" : alarmMsg;
        String fcsErrorId = errorId == null ? "FCS002" : errorId;
        this.raiseWarning(fcsErrorId, message, "cause");
        this.raiseWarning(fcsErrorId + "sans_cause", message);
    }
}

