/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;

public class LoaderMainModule
extends MainModule {
    private LoaderModule loader;
    private FilterHolder autochanger;

    public LoaderMainModule(BridgeToHardware bridge) {
        super(bridge);
    }

    public LoaderModule getLoader() {
        return this.loader;
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.loader = (LoaderModule)lookup.getComponentByName("loader");
        this.autochanger = (FilterHolder)lookup.getComponentByName("autochanger");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Load a filter from the loader into the camera.")
    public String loadFilterInCamera() {
        return this.loader.loadFilterInCamera();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unload a filter from the camera into the loader.")
    public String unloadFilterFromCamera() {
        return this.loader.unloadFilterFromCamera();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Open the loader clamp.")
    public String openHooks() {
        return this.loader.openHooks();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Close the loader clamp.")
    public String closeHooks() {
        return this.loader.closeHooks();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Clamp the loader clamp.")
    public String clampHooks() {
        return this.loader.clampHooks();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update loader state in reading the sensors.")
    public void updateStateWithSensors() {
        super.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
        this.loader.updateStateWithSensors();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSState() {
        if (this.loader.isInitialized()) {
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.HARDWARE_READY, FcsEnumerations.FilterReadinessState.READY});
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Print the list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(super.printHardwareState());
        sb.append("\n ");
        sb.append(this.loader.printHardwareState());
        return sb.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Carrier go to Handoff.")
    public String goToHandoff() {
        return this.loader.goToHandoff();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Carrier go to Storage.")
    public String goToStorage() {
        return this.loader.goToStorage();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="List and display hooks sensors.")
    public String listHooksSensors() {
        return this.loader.getClamp().listHooks();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="List and display the hooks sensors values.")
    public String listSensorsValues() {
        return this.loader.getClamp().listSensorsValues();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("\n").append(this.loader.toString());
        return sb.toString();
    }
}

