/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderHookModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class LoaderClampModule
extends MobileItemModule
implements MovedByEPOSController {
    private final LoaderHookModule hook1;
    private final LoaderHookModule hook2;
    private final LoaderHookModule hook3;
    private final LoaderHookModule hook4;
    private EPOSController hooksController;
    private LoaderModule loader;
    private FcsEnumerations.LockStatus lockStatus;
    @ConfigurationParameter(description="timeout in milliseconds : if closing the clamp last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForClosingHooks = 60000L;
    @ConfigurationParameter(description="timeout in milliseconds : if closing strongly the clamp last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForClampingHooks = 60000L;
    @ConfigurationParameter(description="timeout in milliseconds : if opening the clamp last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForOpeningHooks = 60000L;
    @ConfigurationParameter(description="timeout in milliseconds : if the action of hoing to home position last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForGoingToHomePosition = 60000L;
    @ConfigurationParameter(description="target encoder absolute value in qc to open")
    private int targetPositionToOpen = 5000;
    @ConfigurationParameter(description="target encoder absolute value in qc when hooks are LOCKED")
    private int targetPositionToClose = 492000;
    @ConfigurationParameter(description="target encoder absolute value in qc when hooks are LOCKED STRONGLY")
    private int targetPositionToClamp = 515000;
    @ConfigurationParameter(description="current to close in initialisation phase, in mA")
    private int currentToClamp = 280;
    @ConfigurationParameter(description="current to go to home position in initialisation phase, in mA")
    private int currentToGoHome = -200;
    @ConfigurationParameter(description="min position value used by the GUI")
    private int minPosition = 0;
    @ConfigurationParameter(description="max position value used by the GUI")
    private int maxPosition = 515000;
    @ConfigurationParameter(description="min current value used by the GUI")
    private final int minCurrent = -300;
    @ConfigurationParameter(description="max current value used by the GUI")
    private final int maxCurrent = 400;
    @ConfigurationParameter
    private Map<String, Integer> paramsForCurrentToGoHome;
    @ConfigurationParameter
    private Map<String, Integer> paramsForCurrentToClamp;
    private volatile boolean initialized = false;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private int position;
    private int readCurrent;
    private int force;
    private boolean controllerInFault;

    public LoaderClampModule(LoaderHookModule hook1, LoaderHookModule hook2, LoaderHookModule hook3, LoaderHookModule hook4, Map<String, Integer> paramsForCurrentToClamp, Map<String, Integer> paramsForCurrentToGoHomePosition) {
        this.hook1 = hook1;
        this.hook2 = hook2;
        this.hook3 = hook3;
        this.hook4 = hook4;
        this.paramsForCurrentToClamp = paramsForCurrentToClamp;
        this.paramsForCurrentToGoHome = paramsForCurrentToGoHomePosition;
    }

    @Override
    public String getControllerName() {
        return this.hooksController.getName();
    }

    @Override
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    public int getFilterPresenceSensorValue() {
        return this.loader.getFilterPresenceSensor0().getDigitalValue();
    }

    public LoaderHookModule getHook1() {
        return this.hook1;
    }

    public LoaderHookModule getHook2() {
        return this.hook2;
    }

    public LoaderHookModule getHook3() {
        return this.hook3;
    }

    public LoaderHookModule getHook4() {
        return this.hook4;
    }

    public int getPosition() {
        return this.position;
    }

    public int getMinPosition() {
        return this.minPosition;
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    public int getMinCurrent() {
        return -300;
    }

    public int getMaxCurrent() {
        return 400;
    }

    public int getTargetPositionToOpen() {
        return this.targetPositionToOpen;
    }

    public int getTargetPositionToClose() {
        return this.targetPositionToClose;
    }

    public int getTargetPositionToClamp() {
        return this.targetPositionToClamp;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public int getCurrentToGoHome() {
        return this.currentToGoHome;
    }

    public int getReadCurrent() {
        return this.readCurrent;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if loader clamp is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public void setMinPosition(int minPosition) {
        if (minPosition > this.maxPosition) {
            throw new IllegalArgumentException(this.getName() + "minPosition can't be > maxPosition; maxPosition=" + this.maxPosition);
        }
        this.minPosition = minPosition;
    }

    public void setMaxPosition(int maxPosition) {
        if (this.minPosition > maxPosition) {
            throw new IllegalArgumentException(this.getName() + "maxPosition can't be < minPosition; minPosition=" + this.minPosition);
        }
        this.maxPosition = maxPosition;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.getName() + ": interrupted in getLockStatus."), (Throwable)ex);
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED")
    public boolean isLocked() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED")
    public boolean isUnlocked() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED")
    public boolean isInError() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if loader is empty.")
    public boolean isEmpty() {
        return this.loader.isEmpty();
    }

    @Override
    public boolean isCANDevicesReady() {
        return this.loader.isCANDevicesReady();
    }

    @Override
    public void initModule() {
        ComponentLookup lookup = this.getComponentLookup();
        this.hooksController = (EPOSController)lookup.getComponentByName("hooksController");
        this.loader = (LoaderModule)lookup.getComponentByName("loader");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        if (this.hooksController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.hooksController)});
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is open and at home position")
    public boolean isAtHomePosition() {
        return this.position == 0;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is closed and at clamped position")
    public boolean isAtClampedPosition() {
        return this.targetPositionToClamp - 1000 <= this.position && this.targetPositionToClamp <= this.position + 1000;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is at closed position.")
    public boolean isAtClosedPosition() {
        return this.position == this.targetPositionToClose;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is at open position.")
    public boolean isAtOpenPosition() {
        return this.position == this.targetPositionToOpen;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Attention : this commands moves the clamp to do the homing of the controller. If loader is empty, go to home position otherwise go to clamped position.", alias="homing")
    public void initializeHardware() {
        this.updateStateWithSensors();
        this.publishData();
        if (this.isInError()) {
            String msg = this.getName() + " in ERROR state. Can't initialize hardware.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (!this.hooksController.isInitialized()) {
            throw new FcsHardwareException(this.getName() + ": hooksController has to be initialized first.");
        }
        if (this.isEmpty()) {
            this.goToHomePosition();
        } else {
            this.goToClampedPosition();
        }
        this.initialized = true;
        this.loader.updateFCSState();
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.hooksController.initializeAndCheckHardware();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + ":" + (Object)((Object)ex)));
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public void tick() {
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Go to clamped position to intialize hardware.")
    public String goToClampedPosition() {
        if (!this.loader.isConnectedOnCamera()) {
            throw new RejectedCommandException(this.getName() + " Loader not connected - can't execute command goToClampedPosition.");
        }
        this.updateStateWithSensors();
        if (this.isInError()) {
            String msg = this.getName() + " in ERROR state - can't execute command goToClampedPosition.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.getName() + "No filter in carrier -  can't execute command goToClampedPosition.");
        }
        this.updatePosition();
        if (this.initialized && this.isAtClampedPosition()) {
            String msg = this.getName() + " is already at clamped position - nothing to do.";
            FCSLOG.warning((Object)msg);
            return msg;
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.GOTOCLAMPEDPOSITION, this.timeoutForClampingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Go to home position to initialize hardware.")
    public String goToHomePosition() {
        this.updateStateWithSensors();
        if (this.isInError()) {
            String msg = this.getName() + " in ERROR state - can't execute command goToHomePosition.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (!this.loader.isConnectedOnCamera()) {
            throw new RejectedCommandException(this.getName() + " Loader hardware not connected on camera - can't execute command goToHomePosition.");
        }
        if (!this.initialized && !this.isEmpty()) {
            throw new RejectedCommandException(this.getName() + " There is a filter in carrier - can't execute command goToHomePosition.");
        }
        if (this.initialized && !this.isEmpty() && !this.loader.isAutochangerHoldingFilter()) {
            throw new RejectedCommandException(this.getName() + " There is a filter in carrier and Autochanger is not holding filter - can't execute command goToHomePosition. ");
        }
        this.updatePosition();
        if (this.initialized && this.isAtHomePosition()) {
            String msg = this.getName() + " is already at home position - nothing to do.";
            FCSLOG.warning((Object)msg);
            return msg;
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION, this.timeoutForGoingToHomePosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close clamp.")
    public String close() {
        this.loader.checkPreConditionsForClosingHooks();
        if (this.isAtClosedPosition()) {
            String msg = this.getName() + ": is already closed.";
            FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS, this.timeoutForClosingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clamp clamp.")
    public String clamp() {
        this.loader.checkPreConditionsForClosingHooks();
        if (!this.isLocked()) {
            throw new RejectedCommandException(this.getName() + " has to be LOCKED first. Close hooks prior clamp.");
        }
        if (this.loader.isAutochangerHoldingFilter()) {
            throw new RejectedCommandException(this.getName() + " Autochanger is holding filter. Open autochanger latches before clamping loader hooks.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS, this.timeoutForClampingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open clamp.")
    public String open() {
        this.loader.checkConditionsForOpeningHooks();
        return this.executeAction(FcsEnumerations.MobileItemAction.OPENLOADERHOOKS, this.timeoutForOpeningHooks);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        int DELTA = 5;
        switch (action) {
            case GOTOCLAMPEDPOSITION: {
                FCSLOG.debug((Object)("readCurrent=" + this.readCurrent + " currentToClamp=" + this.currentToClamp));
                return this.currentToClamp - DELTA <= this.readCurrent && this.readCurrent <= this.currentToClamp + DELTA;
            }
            case GOTOHOMEPOSITION: {
                FCSLOG.debug((Object)("readCurrent=" + this.readCurrent + " currentToGoHome=" + this.currentToGoHome));
                return this.currentToGoHome - DELTA <= this.readCurrent && this.readCurrent <= this.currentToGoHome + DELTA;
            }
            case CLOSELOADERHOOKS: {
                return this.position == this.targetPositionToClose;
            }
            case CLAMPLOADERHOOKS: {
                return this.currentToClamp - DELTA <= this.readCurrent && this.readCurrent <= this.currentToClamp + DELTA;
            }
            case OPENLOADERHOOKS: {
                return this.position == this.targetPositionToOpen;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.updateStateWithSensors();
        if (this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS) || this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.OPENLOADERHOOKS)) {
            this.position = this.hooksController.readPosition();
        } else if (this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION) || this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.GOTOCLAMPEDPOSITION) || this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS)) {
            this.readCurrent = this.hooksController.readCurrent();
            this.position = this.hooksController.readPosition();
            this.force = this.readForceSensor();
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case GOTOCLAMPEDPOSITION: {
                this.hooksController.enable();
                this.hooksController.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToClamp);
                this.hooksController.writeCurrent(this.currentToClamp);
                break;
            }
            case GOTOHOMEPOSITION: {
                this.hooksController.enable();
                this.hooksController.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToGoHome);
                this.hooksController.writeCurrent(this.currentToGoHome);
                break;
            }
            case CLOSELOADERHOOKS: {
                this.hooksController.enable();
                this.hooksController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.hooksController.writeParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.hooksController.writeTargetPosition(this.targetPositionToClose);
                this.hooksController.writeControlWord("3F");
                break;
            }
            case CLAMPLOADERHOOKS: {
                if (!this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                    throw new RejectedCommandException(this.getName() + ": Hooks have to be LOCKED before being LOCKED STRONGLY");
                }
                this.hooksController.enable();
                this.hooksController.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToClamp);
                this.hooksController.writeCurrent(this.currentToClamp);
                break;
            }
            case OPENLOADERHOOKS: {
                this.hooksController.enable();
                this.hooksController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.hooksController.writeParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.hooksController.writeTargetPosition(this.targetPositionToOpen);
                this.hooksController.writeControlWord("3F");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is ABORTING action " + action.toString() + " within delay " + delay));
        FCSLOG.info((Object)("Current Command: " + this.getSubsystem().getCurrentAction() + " " + this.getSubsystem().getState()));
        this.hooksController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is STOPPING action " + action.toString() + " within delay " + delay));
        FCSLOG.info((Object)("Current Command: " + this.getSubsystem().getCurrentAction() + " " + this.getSubsystem().getState()));
        this.hooksController.quickStop();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.hooksController.off();
        FCSLOG.info((Object)(this.getName() + ":" + action.toString() + " completed - doing postAction."));
        switch (action) {
            case GOTOCLAMPEDPOSITION: {
                if (!this.isLocked()) {
                    throw new FailedCommandException(this.getName() + ": check with sensors: clamp should be LOCKED.");
                }
                this.hooksController.defineAbsolutePosition(this.targetPositionToClamp);
                this.hooksController.off();
                this.updatePosition();
                this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
                this.initialized = true;
                this.publishData();
                this.loader.updateFCSState();
                break;
            }
            case GOTOHOMEPOSITION: {
                if (!this.isUnlocked()) {
                    throw new FailedCommandException(this.getName() + ": check with sensors: clamp should be UNLOCKED.");
                }
                this.hooksController.defineAbsolutePosition(0);
                this.hooksController.off();
                this.updatePosition();
                this.initialized = true;
                this.publishData();
                this.loader.updateFCSState();
                break;
            }
            case CLOSELOADERHOOKS: {
                if (this.isLocked()) break;
                throw new FailedCommandException(this.getName() + ": check with sensors: clamp should be LOCKED.");
            }
            case CLAMPLOADERHOOKS: {
                if (!this.isLocked() || !this.isAtClampedPosition()) break;
                this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
                this.publishData();
                break;
            }
            case OPENLOADERHOOKS: {
                if (this.isUnlocked()) break;
                throw new FailedCommandException(this.getName() + ": check with sensors: clamp should be UNLOCKED.");
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.loader.updateStateWithSensors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateWithSensors(String[] readHexaValues) {
        this.lock.lock();
        try {
            boolean inTravel;
            this.updatingState = true;
            this.hook1.updateStateWithSensors(readHexaValues);
            this.hook2.updateStateWithSensors(readHexaValues);
            this.hook3.updateStateWithSensors(readHexaValues);
            this.hook4.updateStateWithSensors(readHexaValues);
            boolean inError = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook2.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook3.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook4.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
            boolean locked = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
            boolean unlocked = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
            boolean bl = inTravel = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL;
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (locked ? FcsEnumerations.LockStatus.LOCKED : (unlocked ? FcsEnumerations.LockStatus.UNLOCKED : (inTravel ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN)));
            if (this.initialized && locked && this.isAtClampedPosition()) {
                this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    private int readForceSensor() {
        return 0;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp current in reading controller.")
    public void updateCurrent() {
        try {
            this.readCurrent = this.hooksController.readCurrent();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp position in reading controller.")
    public void updatePosition() {
        try {
            this.position = this.hooksController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String listHooks() {
        StringBuilder sb = new StringBuilder("Hooks status:");
        sb.append("\n");
        sb.append(this.hook1.toString());
        sb.append("/");
        sb.append(this.hook1.getLockStatus());
        sb.append("\n");
        sb.append(this.hook2.toString());
        sb.append("/");
        sb.append(this.hook2.getLockStatus());
        sb.append("\n");
        sb.append(this.hook3.toString());
        sb.append("/");
        sb.append(this.hook3.getLockStatus());
        sb.append("\n");
        sb.append(this.hook4.toString());
        sb.append("/");
        sb.append(this.hook4.getLockStatus());
        sb.append("\n");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp sensors values.")
    public String listSensorsValues() {
        StringBuilder sb = new StringBuilder(this.getName() + "Sensors values=");
        sb.append("/");
        sb.append(this.hook1.listSensorsValues());
        sb.append("/");
        sb.append(this.hook2.listSensorsValues());
        sb.append("/");
        sb.append(this.hook3.listSensorsValues());
        sb.append("/");
        sb.append(this.hook4.listSensorsValues());
        sb.append("/");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp sensors values.")
    public String listStatus() {
        StringBuilder sb = new StringBuilder("Clamp status:");
        sb.append(this.lockStatus);
        sb.append("\n");
        sb.append(this.hook1.getName());
        sb.append("/");
        sb.append(this.hook1.getLockStatus());
        sb.append("\n");
        sb.append(this.hook2.getName());
        sb.append("/");
        sb.append(this.hook2.getLockStatus());
        sb.append("\n");
        sb.append(this.hook3.getName());
        sb.append("/");
        sb.append(this.hook3.getLockStatus());
        sb.append("\n");
        sb.append(this.hook4.getName());
        sb.append("/");
        sb.append(this.hook4.getLockStatus());
        sb.append("\n");
        return sb.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Return a printed list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.isInitialized()) {
            sb.append(" is INITIALIZED.");
        } else {
            sb.append(" is NOT INITIALIZED.");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/timeoutForClosingHooks=");
        sb.append(this.timeoutForClosingHooks);
        sb.append("/timeoutForClosingHooksStrongly=");
        sb.append(this.timeoutForClampingHooks);
        sb.append("/timeoutForOpeningHooks=");
        sb.append(this.timeoutForOpeningHooks);
        return sb.toString();
    }

    public StatusDataPublishedByLoaderClamp getStatusData() {
        return this.createStatusDataPublishedByLoaderClamp();
    }

    public StatusDataPublishedByLoaderClamp createStatusDataPublishedByLoaderClamp() {
        StatusDataPublishedByLoaderClamp status = new StatusDataPublishedByLoaderClamp();
        status.setName(this.getName());
        status.setPosition(this.position);
        status.setCurrent(this.readCurrent);
        status.setClampState(this.lockStatus);
        status.setForce(this.force);
        status.setHomingDone(this.initialized);
        status.setStatusPublishedByHook1(this.hook1.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook2(this.hook2.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook3(this.hook3.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook4(this.hook4.createStatusDataPublishedByLoaderHook());
        return status;
    }

    @Override
    public void publishData() {
        StatusDataPublishedByLoaderClamp status = this.getStatusData();
        KeyValueData kvd = new KeyValueData("loaderClamp", (Serializable)status);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }
}

