/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class LoaderCarrierModule
extends MobileItemModule
implements MovedByEPOSController {
    protected NumericSensor storagePositionSensor0;
    protected NumericSensor handoffPositionSensor0;
    protected NumericSensor storagePositionSensor1;
    protected NumericSensor handoffPositionSensor1;
    private int position = 0;
    private int ssiPosition = 0;
    private int absoluteTargetPosition = 0;
    @ConfigurationParameter(description="Loader Handoff position in micron")
    private int handoffPosition = 1037000;
    @ConfigurationParameter(description="Loader Storage position in micron")
    private int storagePosition = 0;
    @ConfigurationParameter(description="For the Loader GUI : Maximum current to be sent to the Loader Carrier controller (in mA).")
    private int maxCurrent = 1000;
    @ConfigurationParameter(description="For the Loader GUI : Loader Carrier Maximum speed (in rpm/mn).")
    private int maxSpeed = 227;
    @ConfigurationParameter(description="timeout in milliseconds to go from storage to handoff on loader")
    private long timeoutForGoingToHandOff = 120000L;
    @ConfigurationParameter(description="timeout in milliseconds to go from handoff to storage on loader")
    private long timeoutForGoingToStorage = 120000L;
    private int speed;
    private int current;
    private EPOSController carrierController;
    private LoaderModule loader;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private boolean atStorage = false;
    private boolean atHandoff = false;
    private boolean storageSensorsInError = false;
    private boolean handoffSensorsInError = false;
    private boolean controllerInFault = false;
    private boolean limitSwitchDownInError = false;
    private boolean limitSwitchUpInError = false;
    private volatile boolean initialized = false;

    public LoaderCarrierModule(NumericSensor handoffPositionSensor, NumericSensor handoffPositionSensor1, NumericSensor storagePositionSensor, NumericSensor storagePositionSensor1) {
        this.storagePositionSensor0 = storagePositionSensor;
        this.handoffPositionSensor0 = handoffPositionSensor;
        this.storagePositionSensor1 = storagePositionSensor1;
        this.handoffPositionSensor1 = handoffPositionSensor1;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns carrier position.")
    public int getPosition() {
        return this.position;
    }

    public int getSsiPosition() {
        return this.ssiPosition;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getCurrent() {
        return this.current;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if carrierController is in Fault.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public String getControllerName() {
        return this.carrierController.getName();
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if carrier is initialized and ready to receive commands.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max speed in rpm/mn (format decimal).")
    public int getMaxSpeed() {
        return this.maxSpeed;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max current in mA (format decimal).")
    public int getMaxCurrent() {
        return this.maxCurrent;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the handoff position in microns (format decimal).")
    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the storage position in microns (format decimal).")
    public int getStoragePosition() {
        return this.storagePosition;
    }

    public NumericSensor getStoragePositionSensor0() {
        return this.storagePositionSensor0;
    }

    public NumericSensor getHandoffPositionSensor0() {
        return this.handoffPositionSensor0;
    }

    public NumericSensor getStoragePositionSensor1() {
        return this.storagePositionSensor1;
    }

    public NumericSensor getHandoffPositionSensor1() {
        return this.handoffPositionSensor1;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the timeout for going to Handoff in millis (format decimal).")
    public long getTimeoutForGoingToHandOff() {
        return this.timeoutForGoingToHandOff;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the timeout for going to Storage in millis (format decimal).")
    public long getTimeoutForGoingToStorage() {
        return this.timeoutForGoingToStorage;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Storage are equal.")
    public boolean isStorageSensorsInError() {
        return this.storageSensorsInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at HandOff are equal.")
    public boolean isHandoffSensorsInError() {
        return this.handoffSensorsInError;
    }

    public boolean isLimitSwitchDownInError() {
        return this.limitSwitchDownInError;
    }

    public boolean isLimitSwitchUpInError() {
        return this.limitSwitchUpInError;
    }

    @Override
    public void initModule() {
        ComponentLookup lookup = this.getComponentLookup();
        this.loader = (LoaderModule)lookup.getComponentByName("loader");
        this.carrierController = (EPOSController)lookup.getComponentByName("carrierController");
        this.listens(new Observable[]{(Observable)((Object)this.carrierController)});
    }

    public void tick() {
        this.publishData();
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        super.checkHardware();
        try {
            this.carrierController.initializeAndCheckHardware();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + ":"), (Throwable)ex);
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Override
    public boolean isCANDevicesReady() {
        return this.loader.isCANDevicesReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read the sensors and return true if a filter is in the loader.")
    public boolean checkFilterPresence() {
        this.updateStateWithSensors();
        return !this.isEmpty();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the loader. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        return this.loader.isEmpty();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at storage position. This command doesn't read again the sensors.")
    public boolean isAtStoragePosition() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.getName() + ": has been interrupted while waiting for end of update."), (Throwable)ex);
                }
            }
            boolean bl = this.atStorage;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at HANDOFF position. This command doesn't read again the sensors.")
    public boolean isAtHandoffPosition() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.getName() + ": has been interrupted while waiting for end of update."), (Throwable)ex);
                }
            }
            boolean bl = this.atHandoff;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected on the camera. This command doesn't read again the sensors.")
    public boolean isConnectedOnCamera() {
        return this.loader.isConnectedOnCamera();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the autochanger is holding the filter. This command doesn't read again the sensors.")
    public boolean isAutochangerHoldingFilter() {
        return this.loader.isAutochangerHoldingFilter();
    }

    @Command(type=Command.CommandType.ACTION, level=1, alias="goToHandoff", description="Move the carrier to Handoff position.")
    public String goToHandOff() {
        if (this.atHandoff) {
            throw new RejectedCommandException(this.getName() + " is already at Handoff position.");
        }
        this.loader.checkConditionsForCarrierMotion();
        return this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_HANDOFF, this.timeoutForGoingToHandOff);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the carrier to STORAGE position.")
    public String goToStorage() {
        if (this.atStorage) {
            throw new RejectedCommandException(this.getName() + " is already at STORAGE position.");
        }
        this.loader.checkConditionsForCarrierMotion();
        return this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_STORAGE, this.timeoutForGoingToStorage);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the carrier to absolute position given as argument (in decimal format).")
    public String goToAbsolutePosition(int absolutePosition) {
        this.updatePosition();
        if (this.position == absolutePosition) {
            throw new RejectedCommandException(this.getName() + " is already at position " + absolutePosition);
        }
        this.loader.checkConditionsForCarrierMotion();
        this.absoluteTargetPosition = absolutePosition;
        return this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, this.timeoutForGoingToStorage);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_LOADERCARRIER_TO_HANDOFF: {
                return this.position == this.handoffPosition;
            }
            case MOVE_LOADERCARRIER_TO_STORAGE: {
                return this.position == this.storagePosition;
            }
            case MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION: {
                return this.position == this.absoluteTargetPosition;
            }
        }
        assert (false);
        return false;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update carrier position in reading controller.")
    public void updatePosition() {
        this.position = this.carrierController.readPosition();
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="To update and display position for end user.Updates carrier position in reading controller and returns it.")
    public int readPosition() {
        this.updatePosition();
        return this.position;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update carrier current in reading controller.")
    public void updateCurrent() {
        this.current = this.carrierController.readCurrent();
        this.publishData();
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.carrierController.checkFault();
            this.position = this.carrierController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> SDO ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        try {
            this.updateStateWithSensors();
            this.current = this.carrierController.readCurrent();
            this.speed = this.carrierController.readProfileVelocity();
        }
        catch (SDORequestException | ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> SDO ERROR IN READING CONTROLLER:"), ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.loader.updateStateWithSensors();
    }

    protected void updateStateWithSensors(String[] readHexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.handoffPositionSensor0.updateValue(readHexaValues);
            this.handoffPositionSensor1.updateValue(readHexaValues);
            this.storagePositionSensor0.updateValue(readHexaValues);
            this.storagePositionSensor1.updateValue(readHexaValues);
            this.atStorage = this.storagePositionSensor0.getDigitalValue() == 1 && this.storagePositionSensor1.getDigitalValue() == 1;
            this.atHandoff = this.handoffPositionSensor0.getDigitalValue() == 1 && this.handoffPositionSensor1.getDigitalValue() == 1;
            this.storageSensorsInError = this.storagePositionSensor0.getDigitalValue() != this.storagePositionSensor1.getDigitalValue();
            this.handoffSensorsInError = this.handoffPositionSensor0.getDigitalValue() != this.handoffPositionSensor1.getDigitalValue();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.carrierController.checkFault();
        if (action.equals((Object)FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_HANDOFF)) {
            this.carrierController.enable();
            this.carrierController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.carrierController.writeTargetPosition(this.handoffPosition);
            this.carrierController.writeControlWord("3F");
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_STORAGE)) {
            this.carrierController.enable();
            this.carrierController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.carrierController.writeTargetPosition(this.storagePosition);
            this.carrierController.writeControlWord("3F");
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION)) {
            this.carrierController.enable();
            this.carrierController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.carrierController.writeTargetPosition(this.absoluteTargetPosition);
            this.carrierController.writeControlWord("3F");
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is ABORTING action " + action.toString() + " within delay " + delay));
        FCSLOG.info((Object)("Current Command: " + this.getSubsystem().getCurrentAction() + " " + this.getSubsystem().getState()));
        this.carrierController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is STOPPING action " + action.toString() + " within delay " + delay));
        FCSLOG.info((Object)("Current Command: " + this.getSubsystem().getCurrentAction() + " " + this.getSubsystem().getState()));
        this.carrierController.off();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.carrierController.off();
        FCSLOG.info((Object)(this.getName() + ":" + action.toString() + " completed - doing postAction."));
        switch (action) {
            case MOVE_LOADERCARRIER_TO_STORAGE: {
                if (this.isAtStoragePosition()) break;
                throw new FailedCommandException(this.getName() + ": check with sensors: storage sensors don't confirm carrier position.");
            }
            case MOVE_LOADERCARRIER_TO_HANDOFF: {
                if (this.isAtHandoffPosition()) break;
                throw new FailedCommandException(this.getName() + ": check with sensors: handoff sensors don't confirm carrier position.");
            }
            case MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION: {
                this.absoluteTargetPosition = 0;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Check if hardware is ready to be started.")
    public void initializeHardware() {
        if (!this.carrierController.isInitialized()) {
            throw new FcsHardwareException(this.getName() + ": carrierController has to be initialized.");
        }
        this.updateStateWithSensors();
        try {
            this.updatePosition();
        }
        catch (SDORequestException ex) {
            String msg = this.getName() + ": couldn't update position";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(this.getName(), (Throwable)ex);
        }
        if (this.isAtHandoffPosition() && this.position != this.handoffPosition && this.position <= this.handoffPosition) {
            throw new FcsHardwareException(this.getName() + ": handoff sensors don't confirm position read on carrierController.");
        }
        if (this.isAtStoragePosition() && this.position != this.storagePosition) {
            throw new FcsHardwareException(this.getName() + ": storage sensors don't confirm position read on carrierController.");
        }
        this.initialized = true;
        this.loader.updateFCSState();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Return a printed list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.isInitialized()) {
            sb.append(" is INITIALIZED.");
        } else {
            sb.append(" is NOT INITIALIZED.");
        }
        return sb.toString();
    }

    public StatusDataPublishedByLoaderCarrier getStatusData() {
        return this.createStatusDataPublishedByLoaderCarrier();
    }

    public StatusDataPublishedByLoaderCarrier createStatusDataPublishedByLoaderCarrier() {
        StatusDataPublishedByLoaderCarrier status = new StatusDataPublishedByLoaderCarrier(this.getName(), this.position, this.ssiPosition, this.speed, this.current, this.storagePositionSensor0.getDigitalValue(), this.storagePositionSensor1.getDigitalValue(), this.handoffPositionSensor0.getDigitalValue(), this.handoffPositionSensor1.getDigitalValue(), this.storageSensorsInError, this.handoffSensorsInError, this.controllerInFault);
        status.setLimitSwitchDownInError(this.limitSwitchDownInError);
        status.setLimitSwitchUpInError(this.limitSwitchUpInError);
        return status;
    }

    @Override
    public void processEmergencyMessage(EmergencyMessage msg) {
        MovedByEPOSController.super.processEmergencyMessage(msg);
        if ("ff06".equalsIgnoreCase(msg.getDeviceErrorCode())) {
            this.limitSwitchDownInError = true;
        } else if ("ff07".equals(msg.getDeviceErrorCode())) {
            this.limitSwitchUpInError = true;
        }
        this.publishData();
    }

    @Override
    public void processFaultReset() {
        MovedByEPOSController.super.processFaultReset();
        this.limitSwitchDownInError = false;
        this.limitSwitchUpInError = false;
    }

    @Override
    public void publishData() {
        StatusDataPublishedByLoaderCarrier status = this.getStatusData();
        KeyValueData kvd = new KeyValueData("loaderCarrier", (Serializable)status);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }
}

