/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.NumericSensor;

public class CanOpenNumericSensor
extends NumericSensor {
    @ConfigurationParameter(isFinal=true, description="The name of the Digital Input Output device where this sensor is plugged on.")
    private String dioName;
    @ConfigurationParameter(isFinal=true, range="0..7", description="The numero of input on DIO device where this sensor is plugged on.")
    private int inputNumero;
    @ConfigurationParameter(isFinal=true, range="0..15", description="The numero of the byte where the value of this sensor is stored in.")
    protected int byteNumero;

    public CanOpenNumericSensor(String dioName, int inputNumero) {
        this.dioName = dioName;
        this.inputNumero = inputNumero;
    }

    public CanOpenNumericSensor(String dioName, int inputNumero, int byteNumero) {
        this.dioName = dioName;
        this.inputNumero = inputNumero;
        this.byteNumero = byteNumero;
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public int getByteNumero() {
        return this.byteNumero;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1)
    public int getInputNumero() {
        return this.inputNumero;
    }

    @Override
    public synchronized void updateValue(String hex) {
        FCSCst.FCSLOG.finest((Object)(this.getName() + " INPUT NO=" + this.inputNumero));
        String bin = Integer.toBinaryString(Integer.parseInt(hex, 16));
        String s = String.format("%08d", Integer.parseInt(bin));
        FCSCst.FCSLOG.finest((Object)(this.getName() + " binary value=" + s));
        int myValue = Character.digit(s.charAt(7 - this.inputNumero), 16);
        FCSCst.FCSLOG.finest((Object)(this.getName() + " Value updated=" + myValue));
        this.digitalValue = myValue;
    }

    @Override
    public synchronized void updateValue(String[] hexaValues) {
        this.updateValue(hexaValues[this.byteNumero]);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="printValue")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/DIO module=");
        sb.append(this.dioName);
        sb.append("/Input numero=");
        sb.append(String.valueOf(this.inputNumero));
        sb.append("/byteNumero=");
        sb.append(String.valueOf(this.byteNumero));
        sb.append("/digitalValue=");
        sb.append(String.valueOf(this.digitalValue));
        return sb.toString();
    }
}

