/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.ClampsOrLatchesDisagreeException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class AutochangerTwoLatches
extends MobileItemModule {
    private AutoChangerModule autochanger;
    private final AutochangerLatchModule latchXminus;
    private final AutochangerLatchModule latchXplus;
    private volatile FcsEnumerations.LockStatus lockStatus;
    private volatile FcsEnumerations.FilterPresenceStatus filterPresenceStatus;
    private final long timeoutForClosing;
    private final long timeoutForOpening;
    private final Condition stateUpdated;
    protected volatile boolean updatingState;

    public AutochangerTwoLatches(AutochangerLatchModule latchXminus, AutochangerLatchModule latchXplus) {
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.latchXminus = latchXminus;
        this.latchXplus = latchXplus;
        this.timeoutForClosing = Math.max(latchXminus.getTimeoutForClosing(), latchXplus.getTimeoutForClosing());
        this.timeoutForOpening = Math.max(latchXminus.getTimeoutForOpening(), latchXplus.getTimeoutForOpening());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 2 latches are initialized.")
    public boolean isInitialized() {
        return this.latchXminus.isInitialized() && this.latchXplus.isInitialized();
    }

    public AutochangerLatchModule getLatchXminus() {
        return this.latchXminus;
    }

    public AutochangerLatchModule getLatchXplus() {
        return this.latchXplus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max time for closing in millisecond.")
    public long getTimeoutForClosing() {
        return this.timeoutForClosing;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max time for opening in millisecond.")
    public long getTimeoutForOpening() {
        return this.timeoutForOpening;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if both latches are LOCKED.")
    public boolean isLocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if both latches are UNLOCKED.")
    public boolean isUnlocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if one of the latches is in ERROR state.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if there is no filter is latches.")
    public boolean isEmpty() {
        return this.latchXminus.isEmpty() && this.latchXplus.isEmpty();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if autochanger is holding a filter.")
    public boolean isHoldingFilter() {
        return this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.ENGAGED && this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.autochanger = (AutoChangerModule)this.getComponentLookup().getComponentByName("autochanger");
    }

    @Override
    public boolean isCANDevicesReady() {
        return this.autochanger.isCANDevicesReady() && this.isInitialized();
    }

    void updateStateWithSensors(String[] readHexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.latchXminus.updateStateWithSensors(readHexaValues);
            this.latchXplus.updateStateWithSensors(readHexaValues);
            this.computeLockStatus();
            this.computeFilterPresenceStatus();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    private void computeLockStatus() {
        boolean disagree;
        boolean inError = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
        boolean locked = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
        boolean unlocked = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
        boolean inTravel = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL;
        boolean bl = disagree = this.latchXminus.getLockStatus() != this.latchXplus.getLockStatus();
        if (inError) {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            String msg = this.getName() + " sensors are in ERROR.";
            this.raiseAlarm("FCS_AC_Sensor", msg);
            throw new FcsHardwareException(msg);
        }
        if (disagree) {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            String msg = this.getName() + " sensors DISAGREE error: latchXminus state=" + this.latchXminus.getLockStatus() + " latchXplus state=" + this.latchXplus.getLockStatus();
            this.raiseAlarm("FCS_AC_Sensor", msg);
            throw new FcsHardwareException(msg);
        }
        this.lockStatus = locked ? FcsEnumerations.LockStatus.LOCKED : (unlocked ? FcsEnumerations.LockStatus.UNLOCKED : (inTravel ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN));
    }

    private void computeFilterPresenceStatus() {
        if (this.latchXminus.isEmpty() != this.latchXplus.isEmpty()) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            String msg = " Error in filterPresenceSensors of autochanger : the 2 sensors send different values. latchXminus.isEmpty=" + this.latchXminus.isEmpty() + " latchXplus.isEmpty=" + this.latchXplus.isEmpty();
            this.raiseAlarm("FCS_AC_Sensor", msg);
            throw new ClampsOrLatchesDisagreeException(msg);
        }
        this.filterPresenceStatus = this.latchXminus.isEmpty() && this.latchXplus.isEmpty() ? FcsEnumerations.FilterPresenceStatus.NOFILTER : (!this.latchXminus.isEmpty() && !this.latchXplus.isEmpty() ? FcsEnumerations.FilterPresenceStatus.ENGAGED : FcsEnumerations.FilterPresenceStatus.UNKNOWN);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update autochanger state in reading sensors.")
    public void updateStateWithSensors() {
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close latches.")
    public String close() {
        FCSLOG.info((Object)(this.getName() + " about to close."));
        this.updateStateWithSensors();
        if (this.lockStatus == FcsEnumerations.LockStatus.LOCKED) {
            throw new RejectedCommandException(this.getName() + " are already LOCKED.");
        }
        this.autochanger.checkConditionsForClosingLatches();
        return this.executeAction(FcsEnumerations.MobileItemAction.CLOSELATCHES, this.timeoutForClosing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open both latches.")
    public String open() {
        if (this.latchXminus.isUnlocked() && this.latchXplus.isUnlocked()) {
            throw new RejectedCommandException(this.getName() + " are already UNLOCKED.");
        }
        this.autochanger.checkConditionsForOpeningLatches();
        return this.executeAction(FcsEnumerations.MobileItemAction.OPENLATCHES, this.timeoutForOpening);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPENLATCHES: {
                this.latchXminus.getLatchController().enable();
                this.latchXplus.getLatchController().enable();
                this.latchXminus.getLatchController().writeCurrent(this.latchXminus.getCurrentToOpen());
                this.latchXplus.getLatchController().writeCurrent(this.latchXplus.getCurrentToOpen());
                break;
            }
            case CLOSELATCHES: {
                this.latchXminus.getLatchController().enable();
                this.latchXplus.getLatchController().enable();
                this.latchXminus.getLatchController().writeCurrent(-this.latchXminus.getCurrentToOpen());
                this.latchXplus.getLatchController().writeCurrent(-this.latchXplus.getCurrentToOpen());
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.latchXminus.getLatchController().off();
        this.latchXplus.getLatchController().off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.finest((Object)(this.getName() + " nothing to do in postAction"));
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPENLATCHES: {
                return this.latchXminus.isUnlocked() && this.latchXplus.isUnlocked();
            }
            case CLOSELATCHES: {
                return this.latchXminus.isLocked() && this.latchXplus.isLocked();
            }
        }
        assert (false) : action;
        return false;
    }

    public StatusDataPublishedByAutochangerTwoLatches getStatusData() {
        return this.createStatusDataPublishedByTwoLatches();
    }

    public StatusDataPublishedByAutochangerTwoLatches createStatusDataPublishedByTwoLatches() {
        StatusDataPublishedByAutochangerTwoLatches status = new StatusDataPublishedByAutochangerTwoLatches();
        status.setName(this.getName());
        status.setLockStatus(this.lockStatus);
        status.setFilterPresenceStatus(this.filterPresenceStatus);
        String filterName = this.autochanger.getFilterOnTrucksName() == null ? "NO FILTER" : this.autochanger.getFilterOnTrucksName();
        status.setFilterName(filterName);
        return status;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("autochangerLatches", (Serializable)this.getStatusData()));
    }
}

