/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class AutochangerThreeOnlineClamps
extends MobileItemModule {
    private AutoChangerModule autochanger;
    private final AutochangerOnlineClampModule onlineClampXminus;
    private final AutochangerOnlineClampModule onlineClampXplus;
    private final AutochangerOnlineClampModule onlineClampYminus;
    private FcsEnumerations.LockStatus lockStatus;
    private final Condition stateUpdated;
    protected volatile boolean updatingState;
    @ConfigurationParameter(description="timeout in milliseconds : if closing the clamps last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForLockingClamps;
    @ConfigurationParameter(description="timeout in milliseconds : if unlocking the clamps last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForUnlockingClamps;

    public AutochangerThreeOnlineClamps(AutochangerOnlineClampModule onlineClampXminus, AutochangerOnlineClampModule onlineClampXplus, AutochangerOnlineClampModule onlineClampY) {
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.timeoutForLockingClamps = 15000L;
        this.timeoutForUnlockingClamps = 15000L;
        this.onlineClampXminus = onlineClampXminus;
        this.onlineClampXplus = onlineClampXplus;
        this.onlineClampYminus = onlineClampY;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.getName() + ": interrupted in getLockStatus."), (Throwable)ex);
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED")
    public boolean isLocked() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED")
    public boolean isUnlocked() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR")
    public boolean isInError() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
    }

    @Override
    public void initModule() {
        this.autochanger = (AutoChangerModule)this.getComponentLookup().getComponentByName("autochanger");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready : controllers ready, controllers parameters checked and controllers configured.")
    public boolean isInitialized() {
        return this.onlineClampXminus.isInitialized() && this.onlineClampXplus.isInitialized() && this.onlineClampYminus.isInitialized();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Lock the online clamps.")
    public String lockClamps() {
        if (this.lockStatus == FcsEnumerations.LockStatus.LOCKED) {
            throw new RejectedCommandException(this.name + " is already LOCKED");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS, this.timeoutForLockingClamps);
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Unlock the online clamps.")
    public String unlockClamps() {
        if (this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED) {
            throw new RejectedCommandException(this.name + " is already UNLOCKED");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS, this.timeoutForUnlockingClamps);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready.")
    public boolean isCANDevicesReady() {
        return this.onlineClampXminus.isCANDevicesReady() && this.onlineClampXplus.isCANDevicesReady() && this.onlineClampYminus.isCANDevicesReady();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS) {
            return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
        }
        if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS) {
            return this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED;
        }
        throw new IllegalArgumentException(this.name + " invalid action:" + action);
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS) {
            this.onlineClampXminus.getController().enable();
            this.onlineClampXplus.getController().enable();
            this.onlineClampYminus.getController().enable();
            this.onlineClampXminus.getController().releaseBrake();
            this.onlineClampXplus.getController().releaseBrake();
            this.onlineClampYminus.getController().releaseBrake();
            this.onlineClampXminus.getController().writeCurrent(this.onlineClampXminus.getCurrentToLock());
            this.onlineClampXplus.getController().writeCurrent(this.onlineClampXplus.getCurrentToLock());
            this.onlineClampYminus.getController().writeCurrent(this.onlineClampYminus.getCurrentToLock());
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS) {
            this.onlineClampXminus.getController().enable();
            this.onlineClampXplus.getController().enable();
            this.onlineClampYminus.getController().enable();
            this.onlineClampXminus.getController().writeCurrent(this.onlineClampXminus.getCurrentToClamp());
            this.onlineClampXplus.getController().writeCurrent(this.onlineClampXplus.getCurrentToClamp());
            this.onlineClampYminus.getController().writeCurrent(this.onlineClampYminus.getCurrentToClamp());
            this.onlineClampXminus.getController().releaseBrake();
            this.onlineClampXplus.getController().releaseBrake();
            this.onlineClampYminus.getController().releaseBrake();
            this.onlineClampXminus.getController().writeCurrent(this.onlineClampXminus.getCurrentToUnlock());
            this.onlineClampXplus.getController().writeCurrent(this.onlineClampXplus.getCurrentToUnlock());
            this.onlineClampYminus.getController().writeCurrent(this.onlineClampYminus.getCurrentToUnlock());
        } else {
            throw new IllegalArgumentException(this.name + " invalid action:" + action);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.onlineClampXminus.abortAction(action, delay);
        this.onlineClampXplus.abortAction(action, delay);
        this.onlineClampYminus.abortAction(action, delay);
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
    }

    public StatusDataPublishedByAutochangerThreeClamps getStatusData() {
        return this.createStatusDataPublishedByThreeClamps();
    }

    public StatusDataPublishedByAutochangerThreeClamps createStatusDataPublishedByThreeClamps() {
        StatusDataPublishedByAutochangerThreeClamps status = new StatusDataPublishedByAutochangerThreeClamps();
        status.setName(this.getName());
        status.setLockStatus(this.lockStatus);
        return status;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("autochangerClamps", (Serializable)this.getStatusData()));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update autochanger state in reading sensors.")
    public void updateStateWithSensors() {
        this.autochanger.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.onlineClampXminus.updateStateWithSensors(hexaValues);
            this.onlineClampXplus.updateStateWithSensors(hexaValues);
            this.onlineClampYminus.updateStateWithSensors(hexaValues);
            this.computeLockStatus();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    private void computeLockStatus() {
        boolean inTravel;
        boolean inError = this.onlineClampXminus.isInError() || this.onlineClampXplus.isInError() || this.onlineClampYminus.isInError();
        boolean locked = this.onlineClampXminus.isLocked() && this.onlineClampXplus.isLocked() && this.onlineClampYminus.isLocked();
        boolean unlocked = this.onlineClampXminus.isUnlocked() && this.onlineClampXplus.isUnlocked() && this.onlineClampYminus.isUnlocked();
        boolean bl = inTravel = this.onlineClampXminus.isInTravel() && this.onlineClampXplus.isInTravel() && this.onlineClampYminus.isInTravel();
        this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (locked ? FcsEnumerations.LockStatus.LOCKED : (unlocked ? FcsEnumerations.LockStatus.UNLOCKED : (inTravel ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN)));
    }
}

