/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutochangerOnlineClampModule
extends MobileItemModule
implements MovedByEPOSController {
    private final int timeoutForLocking = 10000;
    private final int timeoutForUnlocking = 10000;
    private AutoChangerModule autochanger;
    private final EPOSController controller;
    private final NumericSensor lockSensor;
    private final NumericSensor lockSensorC;
    private final NumericSensor unlockSensor;
    private final NumericSensor unlockSensorC;
    @ConfigurationParameter(isFinal=true)
    private Map<String, Integer> paramsForCurrentToLock;
    @ConfigurationParameter(isFinal=true)
    private Map<String, Integer> paramsForCurrentToUnlock;
    @ConfigurationParameter(description="current to lock ONLINE clamp in mA")
    private int currentToLock = 300;
    @ConfigurationParameter(description="current to unlock ONLINE clamp, in mA")
    private int currentToUnlock = -300;
    @ConfigurationParameter(description="current to clamp ONLINE clamp, in mA")
    private int currentToClamp = 3000;
    @ConfigurationParameter(description="time to hold clamp, in millis")
    private long holdTime = 5000L;
    @ConfigurationParameter(description="time for clamp to lock, in millis")
    private long travelTime = 5000L;
    private boolean inError;
    private boolean lockSensorInError;
    private boolean unlockSensorInError;
    private FcsEnumerations.LockStatus lockStatus;
    private boolean controllerInFault;
    private volatile boolean initialized;
    private boolean controllerConfigured = false;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;

    public AutochangerOnlineClampModule(EPOSController onlineClampController, NumericSensor lockSensor0, NumericSensor lockSensor1, NumericSensor unlockSensor0, NumericSensor unlockSensor1, Map<String, Integer> paramsForCurrentToLock, Map<String, Integer> paramsForCurrentToUnlock) {
        super(3000);
        this.controller = onlineClampController;
        this.lockSensor = lockSensor0;
        this.lockSensorC = lockSensor1;
        this.unlockSensor = unlockSensor0;
        this.unlockSensorC = unlockSensor1;
        this.paramsForCurrentToLock = paramsForCurrentToLock;
        this.paramsForCurrentToUnlock = paramsForCurrentToUnlock;
    }

    public EPOSController getController() {
        return this.controller;
    }

    public int getCurrentToLock() {
        return this.currentToLock;
    }

    public int getCurrentToUnlock() {
        return this.currentToUnlock;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public long getTravelTime() {
        return this.travelTime;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if lockSensor and lockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isLockSensorInError() {
        return this.lockSensorInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if unlockSensor and unlockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isUnlockSensorInError() {
        return this.unlockSensorInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR, this means that lockSensor or unlockSensor is in ERROR or thatunlockSensor and lockSensor return non consistant values. Doesn't read again sensors.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED. Doesn't read again sensors.")
    public boolean isLocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED. Doesn't read again sensors.")
    public boolean isUnlocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=INTRAVEL. Doesn't read again sensors.")
    public boolean isInTravel() {
        return this.lockStatus == FcsEnumerations.LockStatus.INTRAVEL;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is in fault. Doesn't read controller CPU.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns controller name.")
    public String getControllerName() {
        return this.controller.getName();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if clamp is initialized : controller is booted, parameters in the controller CPU have been checked and controller is configured.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.autochanger = (AutoChangerModule)this.getComponentLookup().getComponentByName("autochanger");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        if (this.controller == null) {
            FCSLOG.error((Object)(this.getName() + "==>>> onlineController == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.getName() + "==>>> null onlineClampController - fix groovy description file.");
        }
        if (this.controller instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.controller)});
        }
    }

    public void tick() {
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is initialized and configured.")
    public boolean isCANDevicesReady() {
        return ((MainModule)this.getComponentLookup().getComponentByName("main")).isCANDevicesReady() && this.controller.isInitialized() && this.controllerConfigured;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionsForUnlocking() {
        this.checkConditionsForLocking();
        if (!this.autochanger.isHoldingFilter()) {
            throw new RejectedCommandException(this.name + " can't be UNLOCKED if autochanger is not HOLDING filter.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionsForLocking() {
        if (!this.autochanger.isAtOnline()) {
            throw new RejectedCommandException(this.name + " can't be LOCKED if autochanger trucks are not at ONLINE position.");
        }
        if (this.autochanger.isEmpty()) {
            throw new RejectedCommandException(this.name + " can't be LOCKED if there is no filter in autochanger trucks.");
        }
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        super.checkHardware();
        FCSLOG.debug((Object)(this.getName() + " checking hardware."));
        try {
            this.controller.initializeAndCheckHardware();
            this.configureController();
            this.controller.writeParameters(EPOSEnumerations.EposMode.CURRENT);
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        catch (FailedCommandException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        this.initialized = true;
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read in the CPU of the controller parameters for mode CURRENT.If a parameter has a different value than in configuration, throws an exception.")
    public void checkControllerBeforeAction() throws HardwareException {
        EPOSEnumerations.EposMode modeInCPU = this.controller.readMode();
        if (!modeInCPU.equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            String msg = this.getName() + " Controller is not in mode CURRENT";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        this.controller.checkParameters(EPOSEnumerations.EposMode.CURRENT);
        this.controller.checkFault();
        if (!this.controller.isParametersOK()) {
            String msg = this.getName() + " Some parameter values are not the same in CPU and configuration system.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        FCSLOG.debug((Object)(this.getName() + ":controller parameters are OK - ready for action."));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure controller.")
    public void configureController() throws HardwareException {
        try {
            this.controllerConfigured = false;
            this.controller.activateBrake();
            this.controller.shutdown();
            this.configureDigitalInputOfOnlineClamps();
            this.configureDigitalOutputOfOnlineClamps();
            this.controllerConfigured = true;
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)this.getName(), (Throwable)ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update online clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.autochanger.updateStateWithSensors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.lockSensor.updateValue(hexaValues);
            this.lockSensorC.updateValue(hexaValues);
            this.unlockSensor.updateValue(hexaValues);
            this.unlockSensorC.updateValue(hexaValues);
            boolean locked = this.lockSensor.getDigitalValue() == 1 && this.lockSensorC.getDigitalValue() == 0;
            boolean unlocked = this.unlockSensor.getDigitalValue() == 1 && this.unlockSensorC.getDigitalValue() == 0;
            boolean inTravel = !locked && !unlocked;
            this.lockSensorInError = this.lockSensor.getDigitalValue() == this.lockSensorC.getDigitalValue();
            this.unlockSensorInError = this.unlockSensor.getDigitalValue() == this.unlockSensorC.getDigitalValue();
            boolean bl = this.inError = this.lockSensorInError || this.unlockSensorInError || locked && unlocked;
            if (this.inError) {
                this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            } else if (locked) {
                this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
            } else if (unlocked) {
                this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
            } else if (inTravel) {
                this.lockStatus = FcsEnumerations.LockStatus.INTRAVEL;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP) {
            return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
        }
        if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP) {
            return this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED;
        }
        throw new IllegalArgumentException(this.name + " invalid action for ONLINE clamp:" + action);
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Lock the ONLINE clamp.")
    public void lock() {
        if (this.isLocked()) {
            throw new RejectedCommandException(this.name + " is already LOCKED.");
        }
        this.checkConditionsForLocking();
        this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP, 10000L);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock the ONLINE clamp.")
    public void unlock() {
        if (this.isUnlocked()) {
            throw new RejectedCommandException(this.name + " is already UNLOCKED.");
        }
        this.checkConditionsForUnlocking();
        this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP, 10000L);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case LOCK_ONLINECLAMP: {
                this.controller.enable();
                this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.controller.releaseBrake();
                this.controller.writeCurrent(this.currentToLock);
                break;
            }
            case UNLOCK_ONLINECLAMP: {
                this.controller.enable();
                this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.controller.writeCurrent(this.currentToClamp);
                this.controller.releaseBrake();
                this.slowDownCurrent();
                this.controller.writeCurrent(this.currentToUnlock);
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Lock online clamp for CPPM test bench.")
    public String testLock() throws HardwareException {
        try {
            FCSLOG.debug((Object)(this.getName() + "BEGIN testLock"));
            this.checkConditionsForLocking();
            FCSLOG.debug((Object)(this.getName() + ":condition for locking OK."));
            this.controller.enable();
            this.checkControllerBeforeAction();
            this.controller.releaseBrake();
            this.controller.writeCurrent(this.currentToLock);
            FCSLOG.debug((Object)(this.getName() + ": sent current to controller:" + this.currentToLock));
            FCSLOG.debug((Object)(this.getName() + ": sleeping for:" + this.travelTime));
            FCSLOG.debug((Object)(this.getName() + ":time=" + System.currentTimeMillis()));
            Thread.sleep(this.travelTime);
            FCSLOG.debug((Object)(this.getName() + ":time=" + System.currentTimeMillis()));
            this.controller.writeCurrent(this.currentToClamp);
            FCSLOG.debug((Object)(this.getName() + "==> current sent to controller=" + this.currentToClamp));
            FCSLOG.debug((Object)(this.getName() + ": sleeping for:" + this.holdTime));
            FCSLOG.debug((Object)(this.getName() + ":time=" + System.currentTimeMillis()));
            Thread.sleep(this.holdTime);
            FCSLOG.debug((Object)(this.getName() + ":time=" + System.currentTimeMillis()));
            this.controller.activateBrake();
            FCSLOG.debug((Object)(this.getName() + ": controller brake activated."));
            Thread.sleep(1000L);
            this.controller.writeCurrent(0);
            FCSLOG.debug((Object)(this.getName() + "==> current sent to controller=" + 0));
            this.controller.disable();
            FCSLOG.debug((Object)(this.getName() + "END testLock"));
            return this.getName() + " LOCKED";
        }
        catch (InterruptedException ex) {
            throw new FcsHardwareException("testLock was interrupted while sleeping", (Throwable)ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock online clamp for CPPM test bench.")
    public String testUnlock() throws HardwareException {
        try {
            FCSLOG.debug((Object)(this.getName() + "BEGIN testUnlock"));
            this.checkConditionsForUnlocking();
            FCSLOG.debug((Object)(this.getName() + ":controller parameters are OK."));
            this.controller.enable();
            this.checkControllerBeforeAction();
            this.controller.writeCurrent(this.currentToClamp);
            this.controller.releaseBrake();
            Thread.sleep(1000L);
            this.slowDownCurrent();
            this.controller.writeCurrent(this.currentToUnlock);
            Thread.sleep(this.travelTime + 3000L);
            this.controller.writeCurrent(0);
            Thread.sleep(10000L);
            this.controller.disable();
            FCSLOG.debug((Object)(this.getName() + "END testUnlock"));
            return this.getName() + " UNLOCKED";
        }
        catch (InterruptedException ex) {
            throw new FcsHardwareException("testUnlock was interrupted while sleeping", (Throwable)ex);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.controller.quickStop();
        this.controller.activateBrake();
        this.controller.disable();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case LOCK_ONLINECLAMP: {
                this.controller.writeCurrent(this.currentToClamp);
                try {
                    Thread.sleep(this.holdTime);
                }
                catch (InterruptedException ex) {
                    throw new FailedCommandException(this.getName() + " was interrupted during action " + action.toString());
                }
                this.controller.activateBrake();
                this.controller.writeCurrent(0);
                this.controller.disable();
                break;
            }
            case UNLOCK_ONLINECLAMP: {
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    private void slowDownCurrent() {
        int step = this.currentToClamp / 5;
        for (int curr = this.currentToClamp - step; curr > 0; curr -= step) {
            FCSLOG.debug((Object)("current=" + curr));
            this.controller.writeCurrent(curr);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                throw new RejectedCommandException(this.getName() + " was interrupted during action testLock." + ex.getMessage());
            }
            int actualCurrent = this.controller.readCurrent();
            if (actualCurrent == curr) continue;
            FCSLOG.error((Object)(this.getName() + ": CURRENT ERROR in slowDownCurrent actualCurrent=" + actualCurrent + ",curr=" + curr));
        }
        FCSLOG.debug((Object)"current=0");
        this.controller.writeCurrent(0);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalInputOfOnlineClamps() {
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, "0005");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, "0");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, "C20");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, "30");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalOutputOfOnlineClamps() {
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, "0");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "8001");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, "8001");
    }

    @Override
    public void processUpdate(Observable source, Module.ValueUpdate v) {
        FCSLOG.debug((Object)(this.getName() + ":processUpdate from source=" + source.toString() + " ValueUpdate=" + v.getName()));
        if (!(source instanceof EPOSController)) {
            return;
        }
        if (v.getValue() instanceof EmergencyMessage) {
            EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
            FCSLOG.debug((Object)(this.getName() + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()));
            this.processEmergencyMessage(emcyMsg);
        } else if (v.getValue() instanceof String) {
            EPOSController ctrl = (EPOSController)((Object)source);
            String msgFromController = (String)v.getValue();
            if (ctrl.getName().equals(this.controller.getName()) && "faultReset".equals(msgFromController)) {
                this.controllerInFault = false;
                this.publishData();
            }
        }
    }

    public StatusDataPublishedByAutochangerOnlineClamp getStatusData() {
        return this.createStatusDataPublishedByOnlineClamp();
    }

    public StatusDataPublishedByAutochangerOnlineClamp createStatusDataPublishedByOnlineClamp() {
        StatusDataPublishedByAutochangerOnlineClamp status = new StatusDataPublishedByAutochangerOnlineClamp();
        status.setName(this.getName());
        status.setLockSensorValue(this.lockSensor.getDigitalValue());
        status.setUnlockSensorValue(this.unlockSensor.getDigitalValue());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorInError(this.lockSensorInError);
        status.setUnlockSensorInError(this.unlockSensorInError);
        status.setInError(this.inError);
        status.setControllerInFault(this.controllerInFault);
        return status;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.getStatusData()));
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.controller.quickStop();
    }
}

