/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutochangerLatchModule
extends MobileItemModule
implements MovedByEPOSController {
    private AutoChangerModule autochanger;
    private final EPOSController latchController;
    private final NumericSensor filterEngagedSensor;
    private final NumericSensor filterEngagedSensorB;
    private final NumericSensor lockSensor;
    private final NumericSensor lockSensorB;
    private final NumericSensor unlockSensor;
    private final NumericSensor unlockSensorB;
    private volatile boolean filterEngaged = false;
    private boolean locked;
    private boolean unlocked;
    private boolean inError;
    private boolean inTravel;
    private boolean filterEngagedSensorsInError;
    private boolean lockSensorsInError;
    private boolean unlockSensorsInError;
    @ConfigurationParameter(description="in mA current to be sent to the controller to open the latch.")
    private int currentToOpen = 200;
    @ConfigurationParameter(description="timeout for opening a latch in milliseconds.")
    private long timeoutForOpening = 3000L;
    @ConfigurationParameter(description="timeout for closing a latch in milliseconds.")
    private long timeoutForClosing = 3000L;
    @ConfigurationParameter(description="min position value used by the GUI")
    private int minCurrent = -300;
    @ConfigurationParameter(description="max current value used by the GUI")
    private int maxCurrent = 300;
    private int readCurrent;
    private FcsEnumerations.LockStatus lockStatus;
    private volatile boolean initialized;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private boolean controllerInFault;

    public AutochangerLatchModule(EPOSController latchController, NumericSensor lockSensor, NumericSensor lockSensorB, NumericSensor unlockSensor, NumericSensor unlockSensorB, NumericSensor filterPresenceSensor, NumericSensor filterPresenceSensorB) {
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        this.latchController = latchController;
        this.lockSensor = lockSensor;
        this.lockSensorB = lockSensorB;
        this.unlockSensor = unlockSensor;
        this.unlockSensorB = unlockSensorB;
        this.filterEngagedSensor = filterPresenceSensor;
        this.filterEngagedSensorB = filterPresenceSensorB;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this latch controller name.")
    public String getControllerName() {
        return this.latchController.getName();
    }

    public EPOSController getLatchController() {
        return this.latchController;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if latchController is in Fault.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if latch is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    public long getTimeoutForOpening() {
        return this.timeoutForOpening;
    }

    public long getTimeoutForClosing() {
        return this.timeoutForClosing;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.getName() + ": interrupted in getLockStatus."), (Throwable)ex);
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED. Doesn't read again sensors.", alias="isClosed")
    public boolean isLocked() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED. Doesn't read again sensors.", alias="isOpen")
    public boolean isUnlocked() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR, this means that unlockSensor and lockSensor return non consistant values. Doesn't read again sensors.")
    public boolean isInError() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger is empty. Doesn't read again sensors.")
    public boolean isEmpty() {
        return !this.filterEngaged;
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getSubsystem().getComponentLookup();
        this.autochanger = (AutoChangerModule)lookup.getComponentByName("autochanger");
        if (this.latchController == null) {
            FCSLOG.error((Object)(this.getName() + "==>>> latchController == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.getName() + "==>>> null latchController - fix groovy description file.");
        }
        if (this.latchController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.latchController)});
        }
    }

    public void tick() {
        this.publishData();
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.latchController.initializeAndCheckHardware();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)this.getName(), (Throwable)ex);
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        this.initialized = true;
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update latch state in reading sensors.")
    public void updateStateWithSensors() {
        this.autochanger.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.filterEngagedSensor.updateValue(hexaValues);
            this.filterEngagedSensorB.updateValue(hexaValues);
            this.lockSensor.updateValue(hexaValues);
            this.lockSensorB.updateValue(hexaValues);
            this.unlockSensor.updateValue(hexaValues);
            this.unlockSensorB.updateValue(hexaValues);
            this.filterEngaged = this.filterEngagedSensor.getDigitalValue() == 1 && this.filterEngagedSensorB.getDigitalValue() == 0;
            this.filterEngagedSensorsInError = this.filterEngagedSensor.getDigitalValue() == this.filterEngagedSensorB.getDigitalValue();
            this.locked = this.lockSensor.getDigitalValue() == 1 && this.lockSensorB.getDigitalValue() == 0;
            this.lockSensorsInError = this.lockSensor.getDigitalValue() == this.lockSensorB.getDigitalValue();
            this.unlocked = this.unlockSensor.getDigitalValue() == 1 && this.unlockSensorB.getDigitalValue() == 0;
            this.unlockSensorsInError = this.unlockSensor.getDigitalValue() == this.unlockSensorB.getDigitalValue();
            boolean bl = this.inError = this.locked && this.unlocked || this.filterEngagedSensorsInError || this.lockSensorsInError || this.unlockSensorsInError;
            if (this.inError) {
                this.lockStatus = FcsEnumerations.LockStatus.ERROR;
                String msg = this.createSensorsErrorMsg();
                this.raiseAlarm("FCS_AC_Sensor", msg);
                throw new FcsHardwareException(msg);
            }
            if (this.locked && !this.unlocked) {
                this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
            } else if (this.unlocked && !this.locked) {
                this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
            } else if (!this.locked && !this.unlocked) {
                this.inTravel = true;
                this.lockStatus = FcsEnumerations.LockStatus.INTRAVEL;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    private String createSensorsErrorMsg() {
        String message = this.name + " sensors ERROR:";
        if (this.filterEngagedSensorsInError) {
            message = message + " the 2 filterEngaged sensors return same value " + this.filterEngagedSensor.getDigitalValue();
        }
        if (this.lockSensorsInError) {
            message = message + " the 2 lock sensors return same value " + this.lockSensor.getDigitalValue();
        }
        if (this.unlockSensorsInError) {
            message = message + " the 2 unlock sensors return same value " + this.unlockSensor.getDigitalValue();
        }
        if (this.locked && this.unlocked) {
            message = message + " latch is LOCKED AND UNLOCKED.";
        }
        return message;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update latch current in reading controller.")
    public void updateCurrent() {
        try {
            this.readCurrent = this.latchController.readCurrent();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger CANopen hardware is connected and ready.")
    public boolean isCANDevicesReady() {
        return this.autochanger.isCANDevicesReady();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close latch.")
    public String close() {
        if (this.inError) {
            throw new RejectedCommandException(this.getName() + " is in ERROR state. Can't close it.");
        }
        if (this.locked) {
            throw new RejectedCommandException(this.getName() + " is already LOCKED.");
        }
        this.autochanger.checkConditionsForClosingLatches();
        return this.executeAction(FcsEnumerations.MobileItemAction.CLOSE, this.timeoutForClosing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open latch.")
    public String open() {
        if (this.inError) {
            throw new RejectedCommandException(this.getName() + " is in ERROR state. Can't open it.");
        }
        if (this.unlocked) {
            throw new RejectedCommandException(this.getName() + " is already UNLOCKED.");
        }
        this.autochanger.checkConditionsForOpeningLatches();
        return this.executeAction(FcsEnumerations.MobileItemAction.OPEN, this.timeoutForOpening);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPEN: {
                return this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED;
            }
            case CLOSE: {
                return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPEN: {
                this.latchController.enable();
                this.latchController.writeCurrent(this.currentToOpen);
                break;
            }
            case CLOSE: {
                this.latchController.enable();
                this.latchController.writeCurrent(-this.currentToOpen);
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.latchController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.abortAction(action, delay);
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.latchController.off();
        this.publishData();
        FCSLOG.info((Object)(this.getName() + ":" + action.toString() + " completed - doing postAction."));
    }

    public StatusDataPublishedByAutochangerLatch getStatusData() {
        return this.createStatusDataPublishedByLatch();
    }

    public StatusDataPublishedByAutochangerLatch createStatusDataPublishedByLatch() {
        StatusDataPublishedByAutochangerLatch status = new StatusDataPublishedByAutochangerLatch();
        status.setName(this.getName());
        status.setLockSensorValue(this.lockSensor.getDigitalValue());
        status.setUnlockSensorValue(this.unlockSensor.getDigitalValue());
        status.setFilterPresenceSensorValue(this.filterEngagedSensor.getDigitalValue());
        status.setLockStatus(this.lockStatus);
        status.setControllerInFault(this.controllerInFault);
        status.setLockSensorsInError(this.lockSensorsInError);
        status.setUnlockSensorsInError(this.unlockSensorsInError);
        status.setFilterEngagedSensorsInError(this.filterEngagedSensorsInError);
        status.setInError(this.inError);
        return status;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Publish Data on the Status Bus.")
    public void publishData() {
        StatusDataPublishedByAutochangerLatch status = this.getStatusData();
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)status));
    }
}

