#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import CCS
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from java.lang import RuntimeException
from org.lsst.ccs.command import CommandInvocationException

#
CCS.setThrowExceptions(True);

sft = CCS.attachSubsystem("single-filter-test");

print "***single-filter-test switchToEngineeringMode";
sft.synchCommandLine(10,"switchToEngineeringMode");

carousel = CCS.attachSubsystem("single-filter-test/carousel");
autochanger = CCS.attachSubsystem("single-filter-test/autochanger");

print "***single-filter-test/carousel isHoldingFilterAtStandby"
isHoldingFilterAtStandby = carousel.synchCommandLine(10,"isHoldingFilterAtStandby");
if not isHoldingFilterAtStandby.getResult():
     raise Exception("carousel not holding a filter at standby");
print "single-filter-test/carousel isHoldingFilterAtStandby:",isHoldingFilterAtStandby.getResult();

#Test initial conditions of autochanger

print "***single-filter-test/autochanger isAtStandby"
isAtStandby = autochanger.synchCommandLine(10,"isAtStandby");
if isAtStandby.getResult():
     raise Exception("autochanger should not be at standby");
print "single-filter-test/autochanger isAtStandby:", isAtStandby.getResult();    

print "***single-filter-test/autochanger isAtStandback"
isAtStandback = autochanger.synchCommandLine(10,"isAtStandback");
if not isAtStandback.getResult():
     raise Exception("autochanger should be at standback");
print "single-filter-test/autochanger isAtStandback:", isAtStandback.getResult();

print "***single-filter-test/autochanger isHoldingFilterAtStandback"
isHoldingFilterAtStandback = autochanger.synchCommandLine(10,"isHoldingFilterAtStandback");
if isHoldingFilterAtStandback.getResult():
     raise Exception("autochanger should not be holding a filter at standback");
print "single-filter-test/autochanger isHoldingFilterAtStandback:", isHoldingFilterAtStandback.getResult();

#Test initial conditions
print "***single-filter-test/autochanger isHoldingFilterAtStandby"
isHoldingFilterAtStandby = autochanger.synchCommandLine(10,"isHoldingFilterAtStandby");
if isHoldingFilterAtStandby.getResult():
     raise Exception("autochanger should not be holding a filter at standby");
print "single-filter-test/autochanger isHoldingFilterAtStandby:", isHoldingFilterAtStandby.getResult() ;

CCS.setThrowExceptions(False);

#Test executeSequence1
print "**************************************";
print "***single-filter-test executeSequence1";
print "**************************************";
result = sft.synchCommandLine(60000, "executeSequence1 2");
if isinstance(result.getResult(), CommandInvocationException):
     raise Exception(result.getResult());
print "***Result of command executeSequence1:", result.getResult()
print "**************************************";
print "***   END  executeSequence1        ***";
print "**************************************";

#Tests on carousel
print "***single-filter-test/carousel unlockClamps";
result = carousel.synchCommandLine(10,"unlockClamps");
if not isinstance(result.getResult(),CommandInvocationException):
     raise Exception("unclamp the filter should throw an exception");

CCS.setThrowExceptions(True);

#sft = CCS.attachSubsystem("single-filter-test/autochanger");
print "***Moving autochanger to standby position";
autochanger.synchCommandLine(60,"goToStandby");

CCS.setThrowExceptions(False);

##this command should throw an Exception
print "***single-filter-test/carousel unlockClamps";
result = carousel.synchCommandLine(10,"unlockClamps");
if not isinstance(result.getResult(),CommandInvocationException):
     raise Exception("unclamp the filter should throw an exception");

CCS.setThrowExceptions(True);

print "***single-filter-test/autochanger closeLatchesAtStandby";
autochanger.synchCommandLine(10, "closeLatchesAtStandby");

#this command should not throw an Exception
print "***single-filter-test/carousel unlockClamps";
result = carousel.synchCommandLine(10,"unlockClamps");
print "single-filter-test/carousel unlockClamps:result=", result;

CCS.setThrowExceptions(False);

print "***single-filter-test/autochanger openLatchesAtStandby";
result = autochanger.synchCommandLine(10, "openLatchesAtStandby");
if not isinstance(result.getResult(), CommandInvocationException):
     raise Exception("openLatchesAtStandby should throw an exception");


