###############################################################
#Script to test the real hardware of autochanger trucks.
#Tested on CPPM test bench in september 2015.
###############################################################

from org.lsst.ccs.scripting import CCS
from java.lang import Exception
from java.lang import RuntimeException
from org.lsst.ccs.command import *
from time import sleep



 

CCS.setThrowExceptions(True)

cppm = CCS.attachSubsystem("testbenchCPPM")
#cppm = CCS.attachSubsystem("autochanger-standalone")

print "Connected to testbenchCPPM=> ", cppm
#print "Connected to autochanger-standalone=> ", cppm

ccsVersion= cppm.synchCommandLine(5,"getCCSVersions")
print "TESTS of autochanger trucks motion with CCS version number"
print ccsVersion.getResult()

#print "Date=", date

tcpProxy = CCS.attachSubsystem("testbenchCPPM/tcpProxy")
#tcpProxy = CCS.attachSubsystem("autochanger-standalone/tcpProxy")

result = tcpProxy.synchCommandLine(5,"isHardwareReady")

print "isHardwareReady=", result.getResult()

trucks = CCS.attachSubsystem("testbenchCPPM/trucks")
##################################INITIALIZATION

standbyPosition=int((trucks.synchCommandLine(5,"getStandbyPosition")).getResult())
print "STANDBY position=", standbyPosition

handoffPosition=int((trucks.synchCommandLine(5,"getHandoffPosition")).getResult())
print "HANDOFF position=", handoffPosition

onlinePosition=int((trucks.synchCommandLine(5,"getOnlinePosition")).getResult())
print "ONLINE position=", onlinePosition

waitTime = int(1)

######################################################################
# check that initial conditions are OK
######################################################################

#Read of the linearRailSlaveController mode
slaveCtl = CCS.attachSubsystem("testbenchCPPM/linearRailSlaveController")
#slaveCtl = CCS.attachSubsystem("autochanger-standalone/linearRailSlaveController")
slaveMode = slaveCtl.synchCommandLine(5,"readMode")
print "Slave Controller Mode=", slaveMode.getResult()

#Read of the linearRailMasterController mode
masterCtl = CCS.attachSubsystem("testbenchCPPM/linearRailMasterController")
#masterCtl = CCS.attachSubsystem("autochanger-standalone/linearRailMasterController")
masterMode = masterCtl.synchCommandLine(5,"readMode")
print "Master Controller Mode=", masterMode.getResult()

if str(slaveMode.getResult()) != 'MASTER_ENCODER' :
   #  raise Exception("ERROR on slave Controller mode")
   print "ERROR on slave Controller mode - have to change it."
   result = slaveCtl.synchCommandLine(5,"changeMode MASTER_ENCODER")
else:
   print "slave Controller is in mode", slaveMode.getResult()

if str(masterMode.getResult()) != 'PROFILE_POSITION' :
   #  raise Exception("ERROR on master Controller mode")
   print "ERROR on master Controller mode - have to change it."
   result = masterCtl.synchCommandLine(5,"changeMode PROFILE_POSITION")
else:
   print "master Controller is in mode", masterMode.getResult()

######################################################################
# Move Trucks to STANDBY position if trucks are not already at STANDBY
######################################################################

position = int((masterCtl.synchCommandLine(5,"readPosition")).getResult())
print "INITIAL POSITION Position=", position
if position > standbyPosition +5 or position < standbyPosition - 5:
   print "Going to INITIAL position STANDBY"
   resultMvt=trucks.synchCommandLine(10000,"goToStandby")
   print "resultMvt=", str(resultMvt)
   position = int((masterCtl.synchCommandLine(5,"readPosition")).getResult())
   print "Position=", position
   sleep(waitTime)
   print "END OF GOING TO INITIAL POSITION"

#####################################################################
# loop to move the trucks from STANDBY to HANDOFF
#####################################################################

for i in range(5):
   print "ITERATION number", i
   print "Going to HANDOFF"
   resultMvt=trucks.synchCommandLine(10000,"goToHandoff")
  #print "resultMvt=", str(resultMvt)
   position = int((masterCtl.synchCommandLine(5,"readPosition")).getResult())
   print "Position=", position
   print "Sleeping", waitTime, "s....."
   sleep(waitTime)
   print "Going to STANDBY"
   resultMvt=trucks.synchCommandLine(10000,"goToStandby")
  #print "resultMvt=", str(resultMvt)
   position = int((masterCtl.synchCommandLine(5,"readPosition")).getResult())
   print "Position=", position
   print "Sleeping", waitTime, "s....."
   sleep(waitTime)
   print "end ITERATION number", i

print "END LOOP"


  





