/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutoChangerTwoTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerMainModule;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLinearRailController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerStandalonePlutoGateway;

public class AutochangerTest
extends CcsTestCaseTemplate {
    private static final String PLUTOGATEWAY_NAME = "acPlutoGateway";
    private static Subsystem autochangerSubsystem = null;
    private static AutochangerMainModule main;
    private static AutoChangerModule autochanger;
    private static AutoChangerTwoTrucksModule trucks;
    private static AutochangerTwoLatches latches;
    private static AutochangerThreeOnlineClamps onlineClamps;
    private static SimuAutochangerLinearRailController linearRailMasterController;
    private static SimuAutochangerStandalonePlutoGateway plutoGateway;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF AUTOCHANGER IN STANDALONE MODE");
        System.out.println("***************************************");
        CCS.initializeScriptingEnvironment();
        autochangerSubsystem = BootUtils.getSubsystemFromFile((String)"autochanger__simulation");
        autochangerSubsystem.start();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = autochangerSubsystem.getComponentLookup();
        main = (AutochangerMainModule)lookup.getComponentByName("main");
        autochanger = (AutoChangerModule)lookup.getComponentByName("autochanger");
        autochanger.updateStateWithSensors();
        linearRailMasterController = (SimuAutochangerLinearRailController)lookup.getComponentByName("linearRailMasterController");
        trucks = (AutoChangerTwoTrucksModule)lookup.getComponentByName("autochangerTrucks");
        plutoGateway = (SimuAutochangerStandalonePlutoGateway)lookup.getComponentByName(PLUTOGATEWAY_NAME);
        plutoGateway.simulateAutochangerTrucksIsAtHandoff();
        trucks.updatePosition();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoffPosition());
        Assert.assertTrue((String)"Homing of AutochangerTrucks should be done during INITIALIZATION phase", (boolean)trucks.isHomingDone());
        Assert.assertTrue((String)"Initialization of AutochangerTrucks controllers should be done during INITIALIZATION phase", (boolean)trucks.isInitialized());
        latches = (AutochangerTwoLatches)lookup.getComponentByName("latches");
        onlineClamps = (AutochangerThreeOnlineClamps)lookup.getComponentByName("onlineClamps");
        Assert.assertTrue((String)"After initialization phase, simulated hardware should be ready.", (boolean)main.isCANDevicesReady());
    }

    @Before
    public void setUp() {
        System.out.println("***********  COUCOU    *******************");
        System.out.println("***go back to initial conditions: autochanger empty at HANDOFF");
        System.out.println("simulateAutochangerTrucksIsAtHandoff");
        plutoGateway.simulateAutochangerTrucksIsAtHandoff();
        trucks.updatePosition();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoffPosition());
        System.out.println("simulateAutochangerIsEmpty");
        plutoGateway.simulateAutochangerIsEmpty();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger should be empty", (boolean)autochanger.isEmpty());
        System.out.println("simulateAutochangerAreUnlocked");
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        System.out.println("simulateAutochangerOnlineClampsAreUnlocked");
        plutoGateway.simulateAutochangerOnlineClampsAreUnlocked();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Latches are UNLOCKED", (boolean)latches.isUnlocked());
        Assert.assertTrue((String)"ONLINE clamps are UNLOCKED", (boolean)onlineClamps.isUnlocked());
        System.out.println("simulateCarouselIsHoldingFilter");
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Carousel is holding filter", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
    }

    @Test
    public void testSimuAutochangerPlutoGateway() {
        System.out.println("****tests of SimuAutochangerPlutoGateway");
        System.out.println("simulateAutochangerTrucksIsAtStandby");
        plutoGateway.simulateAutochangerTrucksIsAtStandby();
        trucks.updatePosition();
        Assert.assertTrue((String)"AutochangerTrucks are at STANDBY", (boolean)trucks.isAtStandbyPosition());
        System.out.println("simulateAutochangerTrucksIsAtOnline");
        plutoGateway.simulateAutochangerTrucksIsOnline();
        trucks.updatePosition();
        Assert.assertTrue((String)"AutochangerTrucks are at ONLINE", (boolean)trucks.isAtOnlinePosition());
    }

    @Test
    public void testSimuAutochangerLinearRailController() {
        System.out.println("****tests of SimuAutochangerLinearRailController");
        int handoffPosition = autochanger.getHandoffPosition();
        Assert.assertEquals((String)("linearRailMasterController position is " + handoffPosition), (long)handoffPosition, (long)linearRailMasterController.readPosition());
        int pos = 1000;
        System.out.println("linearRailMasterController: move trucks to position " + pos);
        linearRailMasterController.writeTargetPosition(pos);
        Assert.assertEquals((String)("linearRailMasterController position is " + pos), (long)pos, (long)linearRailMasterController.readPosition());
        trucks.updatePosition();
        Assert.assertEquals((String)("trucks position is " + pos), (long)pos, (long)trucks.getPosition());
    }

    @Test
    public void testOfAutochangerTrucksMotion() {
        System.out.println("************************************************");
        System.out.println("****tests of Autochanger Trucks motion");
        System.out.println("****tests of goToHandOff and isAtHandoff");
        System.out.println("trucks.goToHandOff again - should be rejected");
        try {
            trucks.goToHandOff();
        }
        catch (RejectedCommandException ex) {
            System.out.println("RejectedCommandException=" + (Object)((Object)ex));
            Assert.fail((String)"trucks already at HANDOFF - should NOT raise a RejectedCommandException - should log and do nothing.");
        }
        System.out.println("****tests of goToOnline and isAtOnlinePosition");
        trucks.goToOnline();
        Assert.assertTrue((String)"AutochangerTrucks are at ONLINE", (boolean)trucks.isAtOnlinePosition());
        try {
            trucks.goToOnline();
        }
        catch (RejectedCommandException ex) {
            System.out.println("RejectedCommandException=" + (Object)((Object)ex));
            Assert.fail((String)"trucks already at ONLINE - should NOT raise a RejectedCommandException - should log and do nothing.");
        }
        trucks.goToHandOff();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoffPosition());
        System.out.println("****tests of goToStandby and isAtStandbyPosition");
        trucks.goToStandby();
        Assert.assertTrue((String)"AutochangerTrucks are at STANDBY", (boolean)trucks.isAtStandbyPosition());
        try {
            trucks.goToStandby();
        }
        catch (RejectedCommandException ex) {
            System.out.println("RejectedCommandException=" + (Object)((Object)ex));
            Assert.fail((String)"trucks already at STANDBY - should NOT raise a RejectedCommandException - should log and do nothing.");
        }
        System.out.println("****tests of moveToAbsoluteTargetPosition with arg=-1");
        try {
            int pos = -1;
            trucks.moveToAbsoluteTargetPosition(pos);
            Assert.fail((String)(pos + " is < minActualPositionValue - should raise an IllegalArgumentException"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("IllegalArgumentException=" + ex);
        }
        System.out.println("****tests of moveToAbsoluteTargetPosition with arg=965000");
        try {
            int pos = 965000;
            trucks.moveToAbsoluteTargetPosition(pos);
            Assert.fail((String)(pos + " > maxActualPositionValue - should raise an IllegalArgumentException"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("IllegalArgumentException=" + ex);
        }
    }

    @Test
    public void testMoveToRelativeTargetPosition() {
        int pos;
        System.out.println("****tests of moveToRelativeTargetPosition with arg out of range");
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoffPosition());
        try {
            pos = -2500;
            trucks.moveToRelativeTargetPosition(pos);
            Assert.fail((String)(pos + " < -2000 - should raise an IllegalArgumentException"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("IllegalArgumentException=" + ex);
        }
        try {
            pos = 2500;
            trucks.moveToRelativeTargetPosition(pos);
            Assert.fail((String)(pos + " > 2000 - should raise an IllegalArgumentException"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("IllegalArgumentException=" + ex);
        }
        plutoGateway.simulateAutochangerTrucksIsAtStandby();
        trucks.updatePosition();
        try {
            int pos2 = -2000;
            trucks.moveToRelativeTargetPosition(pos2);
            Assert.fail((String)("moveToRelativeTargetPosition(" + pos2 + ") - should raise an IllegalArgumentException"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("IllegalArgumentException=" + ex);
        }
        plutoGateway.simulateAutochangerTrucksIsOnline();
        trucks.updatePosition();
        try {
            int pos3 = 2000;
            trucks.moveToRelativeTargetPosition(pos3);
            Assert.fail((String)("moveToRelativeTargetPosition(" + pos3 + ") - should raise an IllegalArgumentException"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("IllegalArgumentException=" + ex);
        }
    }

    @Test
    public void testCheckFilterSafetyBeforeMotion() {
        System.out.println("****tests of checkFilterSecurityBeforeMotion");
        System.out.println("** tests with a filter in autochanger trucks and latches LOCKED");
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"autochanger should not be empty", (boolean)autochanger.isEmpty());
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"autochanger should NOT be holding filter", (boolean)autochanger.isHoldingFilter());
        String msg = "A filter is in trucks but NOT held by autochanger. Should raise a RejectedCommandException";
        this.checkFilterSafetyBeforeMotionShouldFail(msg);
        msg = "Trucks are ONLINE, latches are LOCKED and onlineClamps too. Should raise a RejectedCommandException";
        plutoGateway.simulateAutochangerTrucksIsOnline();
        trucks.updatePosition();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        plutoGateway.simulateAutochangerOnlineClampsAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are ONLINE", (boolean)autochanger.isAtOnline());
        Assert.assertTrue((String)"Autochanger latches are LOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"Autochanger ONLINE clamps are LOCKED", (boolean)autochanger.isOnlineClampsLocked());
        this.checkFilterSafetyBeforeMotionShouldFail(msg);
        msg = "Trucks are at STANDBY, latches are LOCKED and carousel is holding filter too. Should raise a RejectedCommandException";
        plutoGateway.simulateAutochangerTrucksIsAtStandby();
        trucks.updatePosition();
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are at STANDBY", (boolean)autochanger.isAtStandby());
        Assert.assertTrue((String)"Autochanger latches are LOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"Carousel is holding filter", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        this.checkFilterSafetyBeforeMotionShouldFail(msg);
        msg = "Trucks are at HANDOFF, latches are LOCKED and loader is holding filter too. Should raise a RejectedCommandException";
        plutoGateway.simulateAutochangerTrucksIsAtHandoff();
        trucks.updatePosition();
        plutoGateway.simulateLoaderIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are at HANDOFF", (boolean)autochanger.isAtHandoff());
        Assert.assertTrue((String)"Autochanger latches are LOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"Loader is holding filter", (boolean)autochanger.isLoaderHoldingFilterAtHandoff());
        this.checkFilterSafetyBeforeMotionShouldFail(msg);
        msg = "Trucks are at HANDOFF, latches are UNLOCKED and loader is holding filter too. Should not raise a RejectedCommandException ";
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are at HANDOFF", (boolean)autochanger.isAtHandoff());
        Assert.assertFalse((String)"Autochanger latches are UNLOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"Loader is holding filter", (boolean)autochanger.isLoaderHoldingFilterAtHandoff());
        this.checkFilterSafetyBeforeMotionShouldNotFail(msg);
        msg = "Trucks are at STANDBY, latches are UNLOCKED and carousel is holding filter too. Should not raise a RejectedCommandException ";
        plutoGateway.simulateAutochangerTrucksIsAtStandby();
        trucks.updatePosition();
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are at STANDBY", (boolean)autochanger.isAtStandby());
        Assert.assertFalse((String)"Autochanger latches are UNLOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"Carousel is holding filter", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        this.checkFilterSafetyBeforeMotionShouldNotFail(msg);
        msg = "Trucks are at ONLINE, latches are UNLOCKED and onlineClamps are LOCKED. Should not raise a RejectedCommandException ";
        plutoGateway.simulateAutochangerTrucksIsOnline();
        trucks.updatePosition();
        plutoGateway.simulateAutochangerOnlineClampsAreLocked();
        main.updateStateWithSensors();
        plutoGateway.simulateCarouselIsNotHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are ONLINE", (boolean)autochanger.isAtOnline());
        Assert.assertTrue((String)"Autochanger ONLINE clamps are LOCKED", (boolean)autochanger.isOnlineClampsLocked());
        Assert.assertFalse((String)"Autochanger latches are UNLOCKED", (boolean)autochanger.isHoldingFilter());
        this.checkFilterSafetyBeforeMotionShouldNotFail(msg);
    }

    private void checkFilterSafetyBeforeMotionShouldFail(String message) {
        System.out.println(message);
        try {
            autochanger.checkFilterSafetyBeforeMotion();
            Assert.fail((String)message);
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
    }

    private void checkFilterSafetyBeforeMotionShouldNotFail(String message) {
        System.out.println(message);
        try {
            autochanger.checkFilterSafetyBeforeMotion();
        }
        catch (RejectedCommandException ex) {
            System.out.println(message + (Object)((Object)ex));
        }
    }

    @Test
    public void testCheckConditionsForClosingLatches() {
        System.out.println("**** test of checkConditionsForClosingLatches ***");
        Assert.assertTrue((String)"autochanger is empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"autochanger is UNLOCKED", (boolean)latches.isUnlocked());
        this.checkConditionsForClosingLatchesShouldFail("Trucks empty - not allowed to close latches");
        Assert.assertTrue((String)"autochanger is UNLOCKED", (boolean)latches.isUnlocked());
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        plutoGateway.simulateAutochangerTrucksIsAtStandby();
        plutoGateway.simulateCarouselIsNotHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertFalse((String)"autochanger is NOT empty", (boolean)autochanger.isEmpty());
        this.closeLatchesShouldNotFail("A filter is in Trucks at HANDOFF - can close latches.");
        Assert.assertTrue((String)"autochanger latches are LOCKED", (boolean)latches.isLocked());
        Assert.assertFalse((String)"carousel is NOT holding filter at STANDBY", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        trucks.moveToAbsoluteTargetPosition(5000);
        this.checkConditionsForClosingLatchesShouldFail("A filter is in Trucks but is not at STANDBY neither at HANDOFF  - not allowed to close latches");
        Assert.assertTrue((String)"autochanger latches are still LOCKED", (boolean)latches.isLocked());
    }

    private void checkConditionsForClosingLatchesShouldFail(String message) {
        System.out.println(message);
        try {
            autochanger.checkConditionsForClosingLatches();
            Assert.fail((String)message);
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
    }

    @Test
    public void testCloseLatches() {
        System.out.println("**** test closeLatches ***");
        this.closeLatchesShouldFail("trucks emty");
        Assert.assertTrue((String)"autochanger is UNLOCKED", (boolean)latches.isUnlocked());
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        plutoGateway.simulateAutochangerTrucksIsAtStandby();
        trucks.updatePosition();
        Assert.assertFalse((String)"autochanger is NOT empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"autochanger is UNLOCKED", (boolean)latches.isUnlocked());
        this.closeLatchesShouldNotFail("trucks loaded at STANDBY");
        Assert.assertTrue((String)"autochanger is LOCKED", (boolean)latches.isLocked());
    }

    private void closeLatchesShouldFail(String message) {
        System.out.println(message);
        try {
            latches.close();
            Assert.fail((String)message);
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
    }

    private void closeLatchesShouldNotFail(String message) {
        System.out.println(message);
        try {
            latches.close();
        }
        catch (RejectedCommandException ex) {
            System.out.println(message + (Object)((Object)ex));
        }
        Assert.assertTrue((String)"Latches are LOCKED", (boolean)latches.isLocked());
    }

    @Test
    public void testCheckConditionsForOpeningLatches() {
        System.out.println("**** test of checkConditionsForOpeningLatches ***");
        String msg = "Trucks empty - not allowed to open latches";
        System.out.println(msg);
        Assert.assertTrue((String)"autochanger is empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"autochanger latches are UNLOCKED", (boolean)latches.isUnlocked());
        this.checkConditionsForOpeningLatchesShouldFail(msg);
        Assert.assertTrue((String)"autochanger latches are still UNLOCKED", (boolean)latches.isUnlocked());
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"autochanger trucks are loaded with a filter", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"autochanger latches are UNLOCKED", (boolean)latches.isUnlocked());
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"carousel is holding filter at STANDBY", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        this.checkConditionsForOpeningLatchesShouldNotFail("A filter is in Trucks at STANDBY and held by carousel - can open latches.");
        this.closeLatchesShouldNotFail("A filter is in Trucks at STANDBY and held by carousel - can close latches.");
        Assert.assertTrue((String)"autochanger latches are LOCKED", (boolean)latches.isLocked());
        plutoGateway.simulateCarouselIsNotHoldingFilter();
        main.updateStateWithSensors();
        trucks.moveToAbsoluteTargetPosition(5000);
        this.checkConditionsForOpeningLatchesShouldFail("Trucks are not at STANDBY neither at HANDOFF  - not allowed to open latches");
        trucks.goToHandOff();
        plutoGateway.simulateLoaderIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Loader is holding filter at HANDOFF", (boolean)autochanger.isLoaderHoldingFilterAtHandoff());
        this.checkConditionsForOpeningLatchesShouldNotFail("Trucks at HANDOFF and loader holds filter. latches can be opened.");
    }

    private void checkConditionsForOpeningLatchesShouldFail(String message) {
        System.out.println(message);
        try {
            autochanger.checkConditionsForOpeningLatches();
            Assert.fail((String)message);
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
    }

    private void checkConditionsForOpeningLatchesShouldNotFail(String message) {
        System.out.println(message);
        try {
            autochanger.checkConditionsForOpeningLatches();
        }
        catch (RejectedCommandException ex) {
            System.out.println(message + (Object)((Object)ex));
        }
    }

    @Test
    public void testOpenLatches() {
        System.out.println("**** test openLatches ***");
        this.openLatchesShouldFail("latches already UNLOCKED");
        Assert.assertTrue((String)"autochanger latches are UNLOCKED", (boolean)latches.isUnlocked());
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"carousel is holding filter at STANDBY", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        this.openLatchesShouldNotFail("filter is held by carousel at STANDBY - latches can be opened.");
        Assert.assertTrue((String)"autochanger latches are UNLOCKED", (boolean)latches.isUnlocked());
    }

    private void openLatchesShouldFail(String message) {
        System.out.println(message);
        try {
            latches.open();
            Assert.fail((String)message);
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
    }

    private void openLatchesShouldNotFail(String message) {
        System.out.println(message);
        try {
            latches.open();
        }
        catch (RejectedCommandException ex) {
            System.out.println(message + (Object)((Object)ex));
        }
        Assert.assertTrue((String)"Latches are UNLOCKED", (boolean)latches.isUnlocked());
    }

    @Test
    public void testGrabFilterAtStandby() {
        System.out.println("*** testGrabFilterAtStandby ***");
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"carousel is holding a filter at STANDBY", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        Assert.assertEquals((String)"when autochanger is empty, filterOnTrucksID==0", (long)0L, (long)autochanger.getFilterOnTrucksID());
        trucks.goToStandby();
        autochanger.grabFilterAtStandby();
        Assert.assertFalse((String)"a filter is now on autochanger trucks", (boolean)autochanger.isEmpty());
        Assert.assertEquals((String)"filterOnTrucksID==1", (long)1L, (long)autochanger.getFilterOnTrucksID());
        Assert.assertTrue((String)"trucks are at STANDBY", (boolean)autochanger.isAtStandby());
        Assert.assertTrue((String)"latches are LOCKED", (boolean)autochanger.isHoldingFilter());
    }

    @Test
    public void testSequence1() {
        System.out.println("****************************************************");
        System.out.println("*** execute sequence 1 for autochanger-standalone ***");
        System.out.println("*** step 1: go empty to STANDBY ***");
        Assert.assertEquals((String)"filterOnTrucksID==0", (long)0L, (long)autochanger.getFilterOnTrucksID());
        trucks.goToStandby();
        Assert.assertFalse((String)"autochanger is NO more empty because a filter is on carousel at STANDBY", (boolean)autochanger.isEmpty());
        Assert.assertEquals((String)"filterOnTrucksID==0", (long)0L, (long)autochanger.getFilterOnTrucksID());
        Assert.assertTrue((String)"trucks are at STANDBY", (boolean)autochanger.isAtStandby());
        System.out.println("*** step 2: grabFilterAtStandby ***");
        plutoGateway.simulateFilterID(1);
        autochanger.grabFilterAtStandby();
        Assert.assertFalse((String)"a filter is now on autochanger trucks", (boolean)autochanger.isEmpty());
        Assert.assertEquals((String)"filterOnTrucksID==1", (long)1L, (long)autochanger.getFilterOnTrucksID());
        Assert.assertTrue((String)"trucks are at STANDBY", (boolean)autochanger.isAtStandby());
        Assert.assertTrue((String)"latches are LOCKED", (boolean)autochanger.isHoldingFilter());
        System.out.println("*** step 3: simulateCarouselIsNotHoldingFilter ***");
        plutoGateway.simulateCarouselIsNotHoldingFilter();
        main.updateStateWithSensors();
        System.out.println("*** step 4: goToOnline with filter loaded on autochanger ***");
        trucks.goToOnline();
        Assert.assertFalse((String)"a filter is now on autochanger trucks", (boolean)autochanger.isEmpty());
        Assert.assertEquals((String)"filterOnTrucksID==1", (long)1L, (long)autochanger.getFilterOnTrucksID());
        Assert.assertTrue((String)"trucks are at ONLINE", (boolean)autochanger.isAtOnline());
        Assert.assertTrue((String)"latches are LOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"ONLINE clamps are UNLOCKED", (boolean)onlineClamps.isUnlocked());
        System.out.println("*** step 5: lock ONLINE clamps ***");
        onlineClamps.lockClamps();
        Assert.assertFalse((String)"a filter is on autochanger trucks", (boolean)autochanger.isEmpty());
        Assert.assertEquals((String)"filterOnTrucksID==1", (long)1L, (long)autochanger.getFilterOnTrucksID());
        Assert.assertTrue((String)"trucks are at ONLINE", (boolean)autochanger.isAtOnline());
        Assert.assertTrue((String)"latches are LOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"ONLINE clamps are LOCKED", (boolean)onlineClamps.isLocked());
        System.out.println("*** try to move trucks : it's not allowed ***");
        try {
            trucks.goToStandby();
            Assert.fail((String)"Can't go to STANDBY because filter is held by latches AND onlineClamps.");
        }
        catch (Exception ex) {
            System.out.println("Exception raised=" + ex);
        }
        System.out.println("*** step 6: unlock ONLINE clamps ***");
        onlineClamps.unlockClamps();
        Assert.assertFalse((String)"a filter is on autochanger trucks", (boolean)autochanger.isEmpty());
        Assert.assertEquals((String)"filterOnTrucksID==1", (long)1L, (long)autochanger.getFilterOnTrucksID());
        Assert.assertTrue((String)"trucks are at ONLINE", (boolean)autochanger.isAtOnline());
        Assert.assertTrue((String)"latches are LOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"ONLINE clamps are UNLOCKED", (boolean)onlineClamps.isUnlocked());
        System.out.println("*** step 7: go to STANDBY ***");
        trucks.goToStandby();
        Assert.assertFalse((String)"a filter is on autochanger trucks", (boolean)autochanger.isEmpty());
        Assert.assertEquals((String)"filterOnTrucksID==1", (long)1L, (long)autochanger.getFilterOnTrucksID());
        Assert.assertTrue((String)"trucks are at STANDBY", (boolean)autochanger.isAtStandby());
        Assert.assertTrue((String)"latches are LOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"ONLINE clamps are UNLOCKED", (boolean)onlineClamps.isUnlocked());
        System.out.println("*** step 8: simulateCarouselIsHoldingFilter ***");
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        System.out.println("*** step 9: ungrabFilterAtStandby ***");
        autochanger.ungrabFilterAtStandby();
        Assert.assertFalse((String)"filter is still there", (boolean)autochanger.isEmpty());
        Assert.assertEquals((String)"filterOnTrucksID==0", (long)0L, (long)autochanger.getFilterOnTrucksID());
        Assert.assertTrue((String)"trucks are at STANDBY", (boolean)autochanger.isAtStandby());
        Assert.assertFalse((String)"autochanger is NOT holding filter", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"carousel is holding filter", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        Assert.assertTrue((String)"ONLINE clamps are UNLOCKED", (boolean)onlineClamps.isUnlocked());
        System.out.println("*** step 10: go to HANDOFF empty ***");
        trucks.goToHandOff();
        Assert.assertTrue((String)"no morefilter on autochanger trucks", (boolean)autochanger.isEmpty());
        Assert.assertEquals((String)"filterOnTrucksID==0", (long)0L, (long)autochanger.getFilterOnTrucksID());
        Assert.assertTrue((String)"trucks are at HANDOFF", (boolean)autochanger.isAtHandoff());
        Assert.assertFalse((String)"autochanger is NOT holding filter", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"carousel is holding filter", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        Assert.assertTrue((String)"ONLINE clamps are UNLOCKED", (boolean)onlineClamps.isUnlocked());
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("****************************************************");
        System.out.println("*** shutdown of autochanger-standalone subsystem ***");
        System.out.println("****************************************************");
        autochangerSubsystem.shutdown();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Test
    public void launchScript() throws Exception {
        System.out.println("************************************************");
        System.out.println("*** Launch Python SCRIPT autochangerTest.py ***");
        System.out.println("************************************************");
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/autochangerTest.py", (String[])new String[0]);
    }
}

