/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutoChangerTwoTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerMainModule;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerStandalonePlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

public class AutochangerOnlineClampsTest
extends CcsTestCaseTemplate {
    private static final String PLUTOGATEWAY_NAME = "acPlutoGateway";
    private static Subsystem autochangerSubsystem = null;
    private static AutochangerMainModule main;
    private static AutoChangerModule autochanger;
    private static AutoChangerTwoTrucksModule trucks;
    private static AutochangerTwoLatches latches;
    private static AutochangerThreeOnlineClamps onlineClamps;
    private static AutochangerOnlineClampModule onlineClampXminus;
    private static SimuAutochangerStandalonePlutoGateway plutoGateway;
    private static SimuEPOSControllerModule onlineClampXminusController;
    private static CanOpenProxy tcpProxy;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("*************************************************************");
        System.out.println("    TESTS OF AUTOCHANGER ONLINE CLAMPS IN STANDALONE MODE    ");
        System.out.println("*************************************************************");
        autochangerSubsystem = BootUtils.getSubsystemFromFile((String)"autochanger__simulation");
        autochangerSubsystem.start();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = autochangerSubsystem.getComponentLookup();
        main = (AutochangerMainModule)lookup.getComponentByName("main");
        autochanger = (AutoChangerModule)lookup.getComponentByName("autochanger");
        autochanger.updateStateWithSensors();
        trucks = (AutoChangerTwoTrucksModule)lookup.getComponentByName("autochangerTrucks");
        plutoGateway = (SimuAutochangerStandalonePlutoGateway)lookup.getComponentByName(PLUTOGATEWAY_NAME);
        plutoGateway.simulateAutochangerTrucksIsAtHandoff();
        trucks.updatePosition();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoffPosition());
        Assert.assertTrue((String)"Homing of AutochangerTrucks should be done during INITIALIZATION phase", (boolean)trucks.isHomingDone());
        Assert.assertTrue((String)"Initialization of AutochangerTrucks controllers should be done during INITIALIZATION phase", (boolean)trucks.isInitialized());
        latches = (AutochangerTwoLatches)lookup.getComponentByName("latches");
        onlineClamps = (AutochangerThreeOnlineClamps)lookup.getComponentByName("onlineClamps");
        onlineClampXminus = (AutochangerOnlineClampModule)lookup.getComponentByName("onlineClampXminus");
        onlineClampXminusController = (SimuEPOSControllerModule)lookup.getComponentByName(onlineClampXminus.getControllerName());
        Assert.assertEquals((String)"onlineClampXminusController.getName()=onlineClampXminus.getControllerName()", (Object)onlineClampXminusController.getName(), (Object)onlineClampXminus.getControllerName());
        Assert.assertTrue((String)"After initialization phase, simulated hardware should be ready.", (boolean)main.isCANDevicesReady());
        tcpProxy = (CanOpenProxy)lookup.getComponentByName("tcpProxy");
    }

    @Before
    public void setUp() {
        System.out.println("***********  COUCOU    *******************");
        System.out.println("***go back to initial conditions: autochanger empty at HANDOFF");
        System.out.println("simulateAutochangerTrucksIsAtHandoff");
        plutoGateway.simulateAutochangerTrucksIsAtHandoff();
        trucks.updatePosition();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoffPosition());
        System.out.println("simulateAutochangerIsEmpty");
        plutoGateway.simulateAutochangerIsEmpty();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger should be empty", (boolean)autochanger.isEmpty());
        System.out.println("simulateAutochangerAreUnlocked");
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        System.out.println("simulateAutochangerOnlineClampsAreUnlocked");
        plutoGateway.simulateAutochangerOnlineClampsAreUnlocked();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Latches are UNLOCKED", (boolean)latches.isUnlocked());
        Assert.assertTrue((String)"ONLINE clamps are UNLOCKED", (boolean)onlineClamps.isUnlocked());
    }

    @Test
    public void test_lock_unlock_onlineClamps() throws HardwareException {
        System.out.println("*****************************************");
        System.out.println("*** test_lock_unlock_onlineClamps");
        System.out.println("*****************************************");
        Assert.assertTrue((String)"Online clamps are UNLOCKED", (boolean)onlineClamps.isUnlocked());
        Assert.assertTrue((String)"onlineClampXminusController is initialized", (boolean)onlineClampXminusController.isInitialized());
        Assert.assertTrue((String)"onlineClampXminus hardware is ready", (boolean)onlineClampXminus.isCANDevicesReady());
        Assert.assertTrue((String)"onlineClampXminus is initialized", (boolean)onlineClampXminus.isInitialized());
        Assert.assertTrue((String)"ONLINE clamps hardware is ready", (boolean)onlineClamps.isCANDevicesReady());
        Assert.assertTrue((String)"ONLINE clamps is initialized", (boolean)onlineClamps.isInitialized());
        System.out.println("*** test lock onlineClampXminus");
        System.out.println("*** test lock onlineClampXminus again - should fail");
        try {
            onlineClampXminus.lock();
            Assert.fail((String)"autochanger is at HANDOFF - can't lock clamps. Should raise a RejectedCommandException.");
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        plutoGateway.simulateAutochangerTrucksIsOnline();
        trucks.updatePosition();
        System.out.println("*** test lock onlineClampXminus again - should fail");
        try {
            onlineClampXminus.lock();
            Assert.fail((String)"onlineClampXminus can't be LOCKED if there is no filter in autochanger trucks. Should raise a RejectedCommandException.");
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"Autochanger is NO more empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Latches are LOCKED", (boolean)latches.isLocked());
        System.out.println("*** test lock onlineClampXminus again - should success");
        onlineClampXminus.lock();
        Assert.assertTrue((String)"onlineClampXminus is LOCKED", (boolean)onlineClampXminus.isLocked());
        System.out.println("*** test lock onlineClampXminus again - should fail");
        try {
            onlineClampXminus.lock();
            Assert.fail((String)"onlineClampXminus is already LOCKED should raise a RejectedCommandException.");
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        System.out.println("*** test unlock onlineClampXminus");
        onlineClampXminus.unlock();
        Assert.assertTrue((String)"onlineClampXminus is UNLOCKED", (boolean)onlineClampXminus.isUnlocked());
        System.out.println("*** test lock ONLINE clamps");
        onlineClamps.lockClamps();
        Assert.assertTrue((String)"ONLINE clamps are LOCKED", (boolean)onlineClamps.isLocked());
        System.out.println("test unlock ONLINE clamps");
        onlineClamps.unlockClamps();
        Assert.assertTrue((String)"ONLINE clamps are UNLOCKED", (boolean)onlineClamps.isUnlocked());
    }

    @Test
    public void testProcessUpdate() throws Exception {
        System.out.println("*****************************************");
        System.out.println("*** test processUpdate                ***");
        System.out.println("*****************************************");
        Assert.assertFalse((String)"onlineClampXminus controller is NOT in fault", (boolean)onlineClampXminus.isControllerInFault());
        String msg = "emcy," + onlineClampXminus.getController().getNodeID() + ",4210,04";
        System.out.println("message=" + msg);
        tcpProxy.processEmcyMessage(msg);
        Assert.assertTrue((String)"Subsystem is in ALARM State.", (boolean)autochangerSubsystem.isInState((Enum)AlertState.ALARM));
        System.out.println("onlineClampXminus nodeID=" + onlineClampXminus.getController().getNodeID());
        Thread.sleep(1000L);
        Assert.assertTrue((String)"onlineClampXminus controller is in fault", (boolean)onlineClampXminus.isControllerInFault());
    }

    @AfterClass
    public static void after() throws Exception {
        autochangerSubsystem.shutdown();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
    }
}

