/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import java.util.List;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;

/**
 * Main Module for the subsystem to test the carousel hardware at LPNHE.
 * @author virieux
 */
public class CarouselTestbenchMainModule extends Module {
    
    private final BridgeToHardware bridge;
    

    /**
     * A constructor to build this Main Module with a bridge.
     * @param bridge 
     */
    public CarouselTestbenchMainModule(BridgeToHardware bridge) {
        this.bridge = bridge;
    }

    
    /**
     * This method returns a String with the list of hardware that this bridge
     * manages.
     *
     * @return
     */
    @Command(level = Command.ENGINEERING1, description = "Return the list of CANopen hardware "
            + "that this subsystem manages.", type = Command.CommandType.QUERY)
    public String printHardwareList() {
        return this.bridge.getTcpProxy().printHardwareList();
    }
    
    /**
     * Print a list of names that this subsystem manages.
     * @return 
     */
    @Command(level = Command.ENGINEERING1, description = "Return names list of CANopen hardware "
            + "that this subsystem manages.", type = Command.CommandType.QUERY)
    public List<String> listHardwareNames() {
        return this.bridge.getTcpProxy().listHardwareNames();
    }
    
    
}
