/*
 * To change this template, choose Tools | Templates
 * and unlockClamps the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerTwoTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.InclinometerModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.drivers.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;

/**
 * This subsystem is to read some sensors in CPPM through the pluto gateway.
 *
 * @author virieux
 */
public class CPPMTestBenchMainModule extends MainModule {

    private final InclinometerModule inclinometer;

    private final String plutoGatewayName;
    private PlutoGatewayModule plutoGateway;

    private final AutochangerOnlineClampModule onlineClampXminus;
    private final AutochangerLatchModule latchXminus;
    private final AutoChangerTwoTrucksModule autochangerTrucks;

    /**
     * Build CPPMTestBenchMainModule
     * @param aBridge
     * @param plutoGatewayName
     * @param inclinometer
     * @param onlineClamp
     * @param latch
     * @param trucks 
     */
    public CPPMTestBenchMainModule(
            BridgeToHardware aBridge,
            String plutoGatewayName,
            InclinometerModule inclinometer,
            AutochangerOnlineClampModule onlineClamp,
            AutochangerLatchModule latch,
            AutoChangerTwoTrucksModule trucks
    ) {
        super(aBridge);
        this.plutoGatewayName = plutoGatewayName;
        this.inclinometer = inclinometer;
        this.onlineClampXminus = onlineClamp;
        this.latchXminus = latch;
        this.autochangerTrucks = trucks;

    }



    public PlutoGatewayModule getPlutoGateway() {
        return plutoGateway;
    }

    public AutoChangerTwoTrucksModule getAutochangerTrucks() {
        return autochangerTrucks;
    }

    public AutochangerOnlineClampModule getOnlineClampXminus() {
        return onlineClampXminus;
    }

    public AutochangerLatchModule getLatchXminus() {
        return latchXminus;
    }

    public EPOSController getOnlineClampXminusController() {
        return onlineClampXminus.getController();
    }

    public EPOSController getLatchXminusController() {
        return latchXminus.getLatchController();
    }

    @Override
    public void initModule() {
        super.initModule();
        this.plutoGateway = (PlutoGatewayModule) getComponentLookup().getComponentByName(plutoGatewayName);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
            description = "Update autochanger state in reading the sensors.")
    @Override
    public void updateStateWithSensors()  {
        super.updateStateWithSensors();

    }

}
