/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This represents the motor that moves an autochanger truck along its rail in
 * the single-filter-test test bench.
 *
 * @author virieux
 */
public class CanOpenTruckMotor extends SftTruckMotor {

    /**
     * The Digital Input-output which controls the motor.
     */
    private CompactIOModule dio;

    /**
     * This is the name of the DIO in the groovy file which is used in
     * initModule.
     *
     */
    @ConfigurationParameter(isFinal=true,
            description="The name of the DIO (Digital Input Output module) which controls this motor.")
    private final String dioName;

    /**
     * Number of the output on the DIO8 where the motor is plugged
     * Used only to be printed.
     */
    @ConfigurationParameter(range="0..7",
            description="The numero of the output of DIO where we send a current for the trucks to go to standby")
    private final int outputNumeroToStandby;
    
    /**
     * Number of the output on the DIO8 where the motor is plugged
     * Used only to be printed.
     */
    @ConfigurationParameter(range="0..7",
            description="The numero of the output of DIO where we send a current for the trucks to go to standback")
    private final int outputNumeroToStandback;
    
    /**
     * Creates a CanOpenTruckMotor with a tickMillis value.
     * 
     * @param dioName
     * @param outputNumeroToStandby
     * @param outputNumeroToStandback 
     */
    public CanOpenTruckMotor(
            String dioName, int outputNumeroToStandby, int outputNumeroToStandback) {
        this.dioName = dioName;
        this.outputNumeroToStandby = outputNumeroToStandby;
        this.outputNumeroToStandback = outputNumeroToStandback;
    }
    

    @Override
    public void initModule() {
        this.dio = (CompactIOModule) getComponentLookup().getComponentByName(dioName);
    }

    /**
     * Move SFT autochanger trucks to STANDBACK position.
     * @return
     * @throws CanOpenException
     * @throws FcsHardwareException 
     */
    @Override
    public String moveToStandback()  {
        this.setMovingToStandback(true);
        return dio.getTcpProxy().writeSDO(dio.getNodeID(), "6200", "1", "1", "1");

    }

    /**
     * Move SFT autochanger trucks to STANDBY position.
     * @return
     * @throws CanOpenException
     * @throws FcsHardwareException 
     */
    @Override
    public String moveToStandby()  {
        this.setMovingToStandby(true);
        return dio.getTcpProxy().writeSDO(dio.getNodeID(), "6200", "1", "1", "2");
    }

    @Override
    public String off()  {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return dio.getTcpProxy().writeSDO(dio.getNodeID(), "6200", "1", "1", "0");
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\noutputNumeroToStandby=");
        sb.append(outputNumeroToStandby);
        sb.append("\noutputNumeroToStandback=");
        sb.append(outputNumeroToStandback);
        return sb.toString();
    }

}
