/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.drivers.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.CanOpenNumericSensor;

/**
 * This class simulates the Can Open Pluto Gateway we use to communicate with
 * the sensors in the whole size prototype.
 *
 * @author virieux
 */
public class SimuPlutoGateway extends PlutoGatewayModule {

    /**
     * Build a new SimuPlutoGateway with a CANopen node ID and a serial number.
     * @param nodeID
     * @param serialNB 
     */
    public SimuPlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }


    @Override
    public void initModule() {
        super.initModule();
        for (int i=0; i<hexaValues.length; i++) {
            this.hexaValues[i] = "00";
        }
    }

    @Override
    public int readNewAnalogValue()  {
        throw new UnsupportedOperationException("Not supported yet."); 
    }

    /* 
     * @return simulated values in hexa 
     */
    @Override
    public String[] readNewHexaValues() {
        return hexaValues;
    }

    /**
     * Set the digital value for a sensor.
     *
     * @param sensor
     * @param digitalValue
     */
    public void replaceDigitalValues(CanOpenNumericSensor sensor, String digitalValue) {

        lock.lock();

        try {
            updatingValues = true;
            int byteNo = sensor.getByteNumero();
            FCSLOG.finest(getName() + "=> old hexa value = " + this.hexaValues[byteNo]);
            StringBuilder bin = new StringBuilder(FcsUtils.hexToBinary(this.hexaValues[byteNo]));
            bin.replace(7 - sensor.getInputNumero(), 7 - sensor.getInputNumero() + 1, digitalValue);
            String newDIOHexaValue = Integer.toHexString(Integer.parseInt(bin.toString(), 2));
            FCSLOG.finest(getName() + "=> new hexa value =" + newDIOHexaValue);
            this.hexaValues[byteNo] = newDIOHexaValue;
            FCSLOG.finest(getName() + " HEXA VALUE READ: hexaValues[0]=" + this.hexaValues[0]
                    + " hexaValues[1]=" + this.hexaValues[1]);

        } finally {

            updatingValues = false;
            valueUpdated.signal();
            lock.unlock();

        }
    }





}
