/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.List;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.CanOpenNumericSensor;

/**
 *
 * @author virieux
 */
public interface SimuFilterIDPlutoGatewayInterface {
    
    List<CanOpenNumericSensor> getFilterIDSensors();
    
    /**
     * Simulates that filterID value in decimal format is the value given as argument.
     * The simulation changes the value returned by filterID sensors.
     * Example :
     * if decimal = 3 (filterR), 
     * filterIDSensor0=1, 
     * filterIDSensor1=1,
     * and the other sensors return 0.
     * 
     * @param decimal 
     */
    @Command(type = Command.CommandType.ACTION, 
            description="Simulates that filterID value in decimal format is the value given as argument")
    default void simulateFilterID(int decimal) {
        if (decimal <= 0 || decimal > 63) {
            throw new IllegalArgumentException("decimal="+decimal+ " should be >0 and < 64 because filterID is coded on 6 bits.");
        }
        boolean un;
        for (int i=0; i<6; i++) {
            un = ((decimal >> i) & 0x1) == 1;
            if (un) {
                replaceDigitalValues(getFilterIDSensors().get(i),"1");
            } else {
                replaceDigitalValues(getFilterIDSensors().get(i),"0");
            }
        }
    }
    
    void replaceDigitalValues(CanOpenNumericSensor sensor, String digitalValue);
    
}
