/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposMode;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * To simulate a controller which can open carousel clamps.
 * @author virieux
 */
public class SimuCarouselClampController extends SimuEPOSControllerModule {

    private CarouselModule carousel;
    
    /**
     * Build a new SimuCarouselClampController
     * @param nodeID
     * @param serialNB
     * @param paramsForCurrent
     * @param paramsForProfilePosition
     * @param paramsForHoming 
     */
    public SimuCarouselClampController( 
            String nodeID, String serialNB, 
            Map<String, Integer> paramsForCurrent, 
            Map<String, Integer> paramsForProfilePosition, 
            Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, 
                paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        setTickMillis(3000);
    }
    
    @Override
    public void initModule() {
        super.initModule();
        this.carousel = (CarouselModule) getComponentLookup().getComponentByName("carousel");
        this.mode = EposMode.CURRENT;
    }

    /**
     * Write current to the simulated controller.
     * @param currentValue
     * @throws SDORequestException 
     */
    @Override
    public void writeCurrent(int currentValue) {

        FCSLOG.debug(getName() + "==========> ACTUATOR ON");

        //the clamp is now UNLOCKED : we have to simulate that.
        CarouselClampModule clamp;
        if (getName().contains("Xminus")) {
            clamp = this.carousel.getClampXminus();
        } else if (getName().contains("Xplus")) {
            clamp = this.carousel.getClampXplus();
        } else {
            throw new RejectedCommandException(getName() + ":couldn't find the clamp to unlock");
        }
        ((SimuCarouselClampLockSensor) clamp.getLockSensor()).simulateClampIsUNLOCKED();

        //we have to publish on status bus the sentValue (for the GUI)
        //not done in CanOPenEPOS
        this.publishData();
    }

    @Override
    public String off()  {
        FCSLOG.debug(getName() + "==========> ACTUATOR OFF");
        //the clamp is now LOCKED : we have to simulate that.
        CarouselClampModule clamp;
        if (getName().contains("Xminus")) {
            clamp = this.carousel.getClampXminus();
        } else if (getName().contains("Xplus")) {
            clamp = this.carousel.getClampXplus();
        } else {
            throw new FailedCommandException(getName() + ": unable to find the clamp to unlock.");
        }
        ((SimuCarouselClampLockSensor) clamp.getLockSensor()).simulateClampIsLOCKED();
        turnedOff = true;
        this.publishData();
        return getName() + " is turned OFF.";
    }    
    
    
}
