
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

/**
 *
 * @author virieux
 */
public class LoaderCanOpenPlutoGateway extends CanOpenPlutoGateway {

    public LoaderCanOpenPlutoGateway(String nodeID, String serialNB, String station_addr) {
        super(nodeID, serialNB, station_addr);
    }
    
    @Override
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1,
            description = "Initialize the Gateway.")
    public String initializeAndCheckHardware()  {
        if (!isBooted()) {
            throw new FcsHardwareException(getName() + " is not booted - can't be initialized.");
        }
        try {
            FCSLOG.info(getName() + " BEGIN initializeHardware");
            this.initialized = true;
            FCSLOG.info(getName() + " is INITIALIZED.");
            //publishData for the LoaderHardwareGUI
            this.tcpProxy.publishHardwareData(this);
            return getName() + " is INITIALIZED.";

        } catch (SDORequestException | FailedCommandException ex) {
            throw new FcsHardwareException(getName(),ex);
        }
    }
    
        /* 
     * @return values in hexa read on the device
     */
    @Override
    public String[] readNewHexaValues()  {

        if (!isBooted()) {
            throw new FcsHardwareException(getName()
                    + " is not booted - can't read new values.");
        }
        try {
            //FOR THE LOADER TEST BENCH
            hexaValues[0] = tcpProxy.readSDO(getNodeID(), "6000", "03");
            FCSLOG.finest(String.format("%s : first byte read in hexaValue= %s", getName(), hexaValues[0]));
            hexaValues[1] = tcpProxy.readSDO(getNodeID(), "6000", "04");
            FCSLOG.finest(String.format("%s : second byte read in hexaValue= %s", getName(), hexaValues[1]));
          } catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning(getName() + "=> ERROR IN READING SENSOR:" + ex);

        } catch (SDORequestException ex) {
            String message = getName() + "=> ERROR IN READING SENSOR:";
            this.raiseAlarm("FCS004:"+getName(), message,ex);
        }
        return hexaValues;
    }

}
