/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 * This class deviceErrorFile a utility class to load the property files we need
 * to monitor a Can Open device : - device error codes - error register codes -
 * communication errors
 *
 * @author virieux
 */
public final class CanOpenErrorsTable {

    /**
     * ******************************
     */
    /*Methods to handle errors       */
    /**
     * ******************************
     */

    /*Device Error Code (index 1003)*/
    private static final Properties deviceErrorCodes = new Properties();
    //the file maxonMotorDeviceErrors.properties deviceErrorFile in the directory : org-lsst-ccs-subsystem-fcs/trunk/src/main/resources
    private static final String DEVICE_ERROR_CODES_FILENAME = "/maxonMotorDeviceErrors.properties";
    private static final InputStream deviceErrorFile = CanOpenErrorsTable.class.getResourceAsStream(DEVICE_ERROR_CODES_FILENAME);

    /*Error Register Code (index 1001)*/
    private static final Properties errorRegisterCodes = new Properties();
    //the file errorRegister.properties deviceErrorFile in the directory : org-lsst-ccs-subsystem-fcs/trunk/src/main/resources
    private static final String ERROR_REGISTER_CODES_FILENAME = "/errorRegister.properties";
    private static final InputStream errorRegisterFile = CanOpenErrorsTable.class.getResourceAsStream(ERROR_REGISTER_CODES_FILENAME);

    /*Communication Error Code (index 1003)*/
    private static final Properties commErrorCodes = new Properties();
    //the file maxonMotorDeviceErrors.properties deviceErrorFile in the directory : org-lsst-ccs-subsystem-fcs/trunk/src/main/resources
    private static final String COMM_ERROR_CODES_FILENAME = "/commErrors.properties";
    private static final InputStream commErrorFile = CanOpenErrorsTable.class.getResourceAsStream(COMM_ERROR_CODES_FILENAME);

    /**
     * A private constructor to hide the implicit public one.
     */
    private CanOpenErrorsTable() {
    }

    
    /**
     * Load the property file of the device error codes.
     * @throws DeploymentException 
     */
    public static void loadDeviceErrorTable()  {
        try {
            FCSLOG.debug("DEVICE ERROR TABLE= " + deviceErrorFile.toString());
            deviceErrorCodes.load(deviceErrorFile);
            int size = deviceErrorCodes.size();
            FCSLOG.debug("Size of the maxon device error codes table = " + size);
        } catch (IOException ex) {
            throw new DeploymentException("Error in reading file: " + DEVICE_ERROR_CODES_FILENAME,ex);
        }

    }
    
    /**
     * Loader the property file for the error register table.
     * @throws DeploymentException 
     */
    public static void loadErrorRegisterTable()  {
        try {
            FCSLOG.debug("ERROR REGISTER TABLE=" + errorRegisterFile.toString());
            errorRegisterCodes.load(errorRegisterFile);
            int size = errorRegisterCodes.size();
            FCSLOG.debug("Size of the error register codes table = " + size);
        } catch (IOException ex) {
            FCSLOG.error("Error in reading file: " + ERROR_REGISTER_CODES_FILENAME + ex);
            throw new DeploymentException("Error in reading file: " + ERROR_REGISTER_CODES_FILENAME , ex);
        }

    }
    
    /**
     * Load the property file for the communication errors.
     * @throws DeploymentException 
     */
    public static void loadCommunicationErrorTable()  {
        try {
            FCSLOG.debug("COMMUNICATION ERROR TABLE=" + commErrorFile.toString());
            commErrorCodes.load(commErrorFile);
            int size = commErrorCodes.size();
            FCSLOG.debug("Size of the error register codes table = " + size);
        } catch (IOException ex) {
            FCSLOG.error("Error in reading file: " + COMM_ERROR_CODES_FILENAME + ex);
            throw new DeploymentException("Error in reading file: " + COMM_ERROR_CODES_FILENAME , ex);
        }

    }

    /**
     * Return the name of an error code given as a parameter in reading in the
     * error codes table.
     *
     * @param aCode error in hexa
     * @return the name
     */
    public static String getDeviceErrorNameByCode(String aCode) {

        String deviceErrorName = deviceErrorCodes.getProperty(aCode.toUpperCase());
        if (deviceErrorName == null) {
            deviceErrorName = aCode.toUpperCase() + "=device error code not found in deviceErrorCodes";
        }
        return deviceErrorName;
        
    }
    
    

    
     /**
     * Return the name of an error register given as a parameter in reading in the
     * error register table.
     *
     * @param aCode error register in hexa
     * @return the name
     */
    public static String getErrorRegisterNameByCode(String aCode) {

        String errorRegisterName = errorRegisterCodes.getProperty(aCode.toUpperCase());
        if (errorRegisterName == null) {
            errorRegisterName = aCode.toUpperCase() + "=error register code not found in errorRegisterCodes";
        }
        return errorRegisterName;        
    }
    

    
    /**
     * Return the name of a communication error code given as a parameter in reading in the
     * communication error table.
     *
     * @param aCode error register in hexa
     * @return the name
     */
    public static String getCommErrorNameByCode(String aCode) {

        String commErrorName = commErrorCodes.getProperty(aCode.toUpperCase());
        if (commErrorName == null) {
            commErrorName = aCode.toUpperCase() + "=communication error code not found in commErrorCodes";
        }
        return commErrorName;        
    }






}
