/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.List;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;

/**
 * This interface has to be implemented by classes which start a tcpip server
 * to communicate with real hardware or by classes which simulate the communication
 * with hardware.
 * 
 * @author virieux
 */
public interface TcpProxyInterface {

    /**
     * checkNewHardware is called by command checkStarted() in higher level
     * Modules and is executed when a command completeInitialization is sent to
     * the subsystem. The command completeInitialization is sent by the end-user
     * to complete the initialization phase when the subsystem was stopped
     * during this phase because of an error (HardwareException).
     *
     * @throws org.lsst.ccs.HardwareException
     */
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL, 
            description = "Retrieve information for booted devices and " + "checks if CANopen node ID and serial number match those" + "in description file .")
    void checkNewHardware() throws HardwareException;

    /**
     * This method is used when the loader CANbus is connected.
     * @throws HardwareException 
     */
    void connectHardware() throws HardwareException;

    /**
     * This methods stops the CWrapper client, and the TCP server.
     */
    void disconnectHardware();

    /**
     * Return a String with the list of hardware expected in this subsystem.
     * For debug purpose.
     * @return
     */
    String printHardwareList();
    
    /**
     * Return a printed list of hardware with the initialization state.
     * For debug purpose.
     * @return 
     */
    String printHardwareState();

    /**
     * Return an Array containing hardware names handled by this component.
     * @return
     */
    List<String> listHardwareNames();

    /**
     * Publish Data on status bus for trending data base and GUIs.
     */
    void publishData();
    
}
