/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.UsesSubsystem;

/**
 * This is an interface for a piece of hardware on a can open network. //TODO :
 * should be renamed CanOpenDevice
 *
 * @author virieux
 */
public interface PieceOfHardware extends UsesSubsystem {


    String getSerialNB();

    String getNodeID();

    /**
     * @return true If this piece of hardware is booted and the nodeID on the
     * hardware is the same than the one in the Configuration DB.
     */
    boolean isBooted();

    void setBooted(boolean aBoolean);

    /**
     * @return true if the hardware has been initialized with success, false
     * otherwise.
     */
    boolean isInitialized();

    /**
     * This methods write some configuration data on the hardware CPU.
     *
     * @return a message for the end user if evering is OK otherwise throws an
     * exception.
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    String initializeAndCheckHardware();
    
    default String printState() {
        StringBuilder sb = new StringBuilder("name="+getName());
        sb.append(" nodeID=");
        sb.append(getNodeID());
        sb.append(" serial number=");
        sb.append(getSerialNB());
        if (isBooted()) {
            sb.append(" is BOOTED");
        } else {
            sb.append(" is NOT BOOTED");
        }
        if (isInitialized()) {
            sb.append(" and INITIALIZED");
        } else {
            sb.append(" and NOT INITIALIZED");
        }        
        return sb.toString();
    }
    
}
