
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.bus.data.Alert;
import static org.lsst.ccs.bus.states.AlertState.ALARM;
import static org.lsst.ccs.bus.states.AlertState.WARNING;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 * This interface is implemented by each class 
 * @author virieux
 */
public interface AlertRaiser extends UsesSubsystem {
    
    default void raiseAlarm(String fcsErrorID, String message, String cause) {
        FCSLOG.error(message);
        this.getSubsystem().raiseAlert(new Alert(fcsErrorID,message), ALARM, cause);
    }    
    
    default void raiseAlarm(String fcsErrorID, String message) {
        raiseAlarm(fcsErrorID,message,message);
    }
    
    default void raiseAlarm(String fcsErrorID, String message, Exception ex) {
        FCSLOG.error(message,ex);
        this.getSubsystem().raiseAlert(new Alert(fcsErrorID,message), ALARM, message+ex);
    }
    
    default void raiseWarning(String fcsErrorID, String message, String cause) {
        FCSLOG.warning(message);
        this.getSubsystem().raiseAlert(new Alert(fcsErrorID,message), WARNING, cause);
    }
    
    default void raiseWarning(String fcsErrorID, String message) {
        raiseWarning(fcsErrorID,message,message);
    }
    
    default void raiseWarning(String fcsErrorID, String message, Exception ex) {
        FCSLOG.warning(message);
        this.getSubsystem().raiseAlert(new Alert(fcsErrorID,message), WARNING, message);
    }    
    
 
    
}
