package fcs

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.description.groovy.CCSBuilder


CCSBuilder builder = ["fcs"]
//********************************************************************************//
//Carousel variables
//********************************************************************************//
//for each socket we define a position on the carousel : positionOnCarouselSocket
//and the position of the socket when it is at STANDBY position.
def positionOnCarouselSocket = [0,72,144,216,288] as int[]

def standbyPositionSocket = [0, 288, 216, 144, 72] as int[]


//Carousel Can Open Devices (CAN-CBX-AI814)
def adcName = "ai814"

//Carousel clamps controllers name
def clampXminusControllerName = "clampXminusController" //controller to unlock clamp on the side Xminus
def clampXplusControllerName =  "clampXplusController" //controller to unlock clamp on the side Xplus
//********************************************************************************//

//********************************************************************************//
//Autochanger variables
//********************************************************************************//
def acPlutoGatewayName = "acPlutoGateway" // to monitor the autochanger sensors
//********************************************************************************//

//********************************************************************************//
//Loader variables
//********************************************************************************//
def loaderTcpProxyName = "loaderTcpProxy"
def loaderPlutoGatewayName = "loaderPlutoGateway" // to monitor the loader sensors
//********************************************************************************//

builder.
    main(org.lsst.ccs.subsystems.fcs.FcsMainModule,
    bridge:ref("bridge"),   
    bridgeToLoader:ref("bridgeToLoader"),
    filterMg:ref("filterManager"),
    carousel:ref("carousel"),
    autochanger:ref("autochanger"),
    loader:ref("loader")) {
    //begin description of Main submodules
    //-------------------------
    // BEGIN Filter Manager description
    filterManager(FilterManager) {
        //begin description of filter manager's children
        filterU (Filter, 
            filterID:1,weight:38,socketName:"socket1")
        filterG (Filter,
            filterID:2,weight:33,socketName:"socket2")
        filterR (Filter,
            filterID:3,weight:30,socketName:"socket3")
        filterI (Filter,
            filterID:4,weight:28,socketName:"socket4")
        filterZ (Filter,
            filterID:5,weight:28,socketName:"socket5")
        filterY (Filter,
            filterID:6,weight:22.5,socketName:"OUT")
        dummyFilter (Filter,
            filterID:10,weight:44.5,socketName:"OUT")
    }//end description of filter manager's children
    // END Filter Manager description
    // ------------------------------
    
    //-------------------------
    // BEGIN Filter Identificator description
    
    filterIdentificator(FilterIdentificator,
        plutoGatewayName:acPlutoGatewayName)
    {//begin description of filter Identificator's children
        filterIDSensor0 ( CanOpenNumericSensor ,
            dioName:acPlutoGatewayName,inputNumero: 0,byteNumero: 5)
        filterIDSensor1 ( CanOpenNumericSensor ,
            dioName:acPlutoGatewayName,inputNumero: 1,byteNumero: 5)
        filterIDSensor2 ( CanOpenNumericSensor ,
            dioName:acPlutoGatewayName,inputNumero: 2,byteNumero: 5)
        filterIDSensor3 ( CanOpenNumericSensor ,
            dioName:acPlutoGatewayName,inputNumero: 3,byteNumero: 5)
        filterIDSensor4 ( CanOpenNumericSensor ,
            dioName:acPlutoGatewayName,inputNumero: 4,byteNumero: 5)  
        filterIDSensor5 ( CanOpenNumericSensor ,
            dioName:acPlutoGatewayName,inputNumero: 5,byteNumero: 5) 
    }//end description of filter identificator's children
    // END Filter Identificator description
    //-------------------------
    // BEGIN Bridge To CHANGER description
    // Bridge
    bridge (SimuBridgeToCanOpenHardware,
        tcpProxy:ref("tcpProxy"))
    {//begin description of bridgeToChanger's children          
        // tcp Proxy
        tcpProxy (SimuCanOpenProxy,
            portNumber:54321,fieldBusTimeout:2000,clientName:"TestBench",
            hardwareBootTimeout:2500)
        //Carousel controllers
        "$clampXminusControllerName" (SimuCarouselClampController,
            nodeID:"1a",serialNB:"79003317",
            paramsForCurrent:[
                MotorType:11, PositionSensorType:3,PolePairNumber:8,
                ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:25],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])  
        
        "$clampXplusControllerName" (SimuCarouselClampController,
            nodeID:"1b",serialNB:"79003313",
            paramsForCurrent:[MotorType:11, PositionSensorType:3,PolePairNumber:8,
                ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:25],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        
        carouselController (SimuCarouselController,
            nodeID:"1c",serialNB:"7900xxxxx",
            paramsForCurrent:[
                ContinuousCurrentLimit:3440,
                OutputCurrentLimit:6880,
                MaxSpeedInCurrentMode:2000,
                MotorType:10,PolePairNumber:1,
                PositionSensorType:1],
            paramsForProfilePosition:[
                MinPositionLimit:-300,
                MaxPositionLimit:550000,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        
        // can open devices to read carousel clamps sensors
        hyttc580 (CanOpenDevice,nodeID:"1d",serialNB:"44110125008180")
        
        // can open devices to read carousel brakes sensors and temperatures
        ai814 (SimuCanOpenADC,nodeID:"1e",serialNB:"c7yyyyyy",transmissionType:"1")
        
        // can open devices to read carousel brakes sensors and temperatures
        pt100 (CanOpenDevice, nodeID:"1f",serialNB:"c7zzzzzz")
        
        // autochanger can open devices
        "$acPlutoGatewayName" (SimuAutochangerPlutoGateway,
            nodeID:"30",serialNB:"2071"/*,station_addr","01")*/)
        
        // autochanger can open devices
        linearRailMasterController (SimuAutochangerLinearRailController, 
            nodeID:"2a", serialNB:"80001881",
            plutoGatewayName:acPlutoGatewayName,
            paramsForCurrent:[
                MotorType:10, PositionSensorType:260,PolePairNumber:1,
                ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                ThermalTimeConstantWinding:187,
                MaxSpeedInCurrentMode:9140],
            paramsForProfilePosition:[
                ProfileAcceleration:1207,
                ProfileDeceleration:1207,
                MaxProfileVelocity:322,
                QuickStopDeceleration:1207,
                MaxFollowingError:200000,//on verra plus tard
                ProfileVelocity:281,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        
        // autochanger can open devices
        linearRailSlaveController (SimuAutochangerLinearRailController, 
            nodeID:"2b",serialNB:"80001932",plutoGatewayName:acPlutoGatewayName,
            paramsForCurrent:[
                MotorType:10, PositionSensorType:1,PolePairNumber:1,
                ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                ThermalTimeConstantWinding:187,
                MaxSpeedInCurrentMode:9140],
            paramsForProfilePosition:[
                ProfileAcceleration:30000,
                ProfileDeceleration:30000,
                ProfileVelocity:7000,
                QuickStopDeceleration:30000,
                MaxFollowingError:7000,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        
        // autochanger can open devices   
        latchXminusController (SimuAutochangerLatchController,  //CanOpenEPOS24-3
            nodeID:"4",serialNB:"84004711",latchName:"latchXminus",
            plutoGatewayName:acPlutoGatewayName,
            paramsForCurrent:[
                MotorType:1, PositionSensorType:0,PolePairNumber:2,
                ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                ThermalTimeConstantWinding:40,
                MaxSpeedInCurrentMode:100],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        
        // autochanger can open devices
        latchXplusController (SimuAutochangerLatchController,  //CanOpenEPOS24-3
            nodeID:"5",serialNB:"999XXXX",latchName:"latchXplus",
            plutoGatewayName:acPlutoGatewayName,
            paramsForCurrent:[
                MotorType:1, PositionSensorType:0,PolePairNumber:2,
                ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                ThermalTimeConstantWinding:40,
                MaxSpeedInCurrentMode:100],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        
        // autochanger can open devices
        onlineClampXminusController (SimuAutochangerOnlineClampController, 
            nodeID:"3a",serialNB:"79011616",onlineClampName:"onlineClampXminus",
            paramsForCurrent:[
                MotorType:1, PositionSensorType:0,PolePairNumber:1,
                ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[
                ProfileAcceleration:30000,
                ProfileDeceleration:30000,
                ProfileVelocity:7000,
                QuickStopDeceleration:10000,
                MaxFollowingError:2000,
                MotionProfileType:0],
            paramsForHoming:[
                HomeOffset:0, MaxProfileVelocity:6930,
                SpeedForSwitchSearch:100,
                SpeedForZeroSearch:10,
                HomingAcceleration:1000,
                CurrentThresholdHomingMode:500,
                HomePosition:0
            ])
        
        // autochanger can open devices
        onlineClampXplusController (SimuAutochangerOnlineClampController, 
            nodeID:"3b",serialNB:"xxxx99999",onlineClampName:"onlineClampXplus",
            paramsForCurrent:[
                MotorType:1, PositionSensorType:0,PolePairNumber:1,
                ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[
                ProfileAcceleration:30000,
                ProfileDeceleration:30000,
                ProfileVelocity:7000,
                QuickStopDeceleration:10000,
                MaxFollowingError:2000,
                MotionProfileType:0],
            paramsForHoming:[
                HomeOffset:0, MaxProfileVelocity:6930,
                SpeedForSwitchSearch:100,
                SpeedForZeroSearch:10,
                HomingAcceleration:1000,
                CurrentThresholdHomingMode:500,
                HomePosition:0
            ])
        
        // autochanger can open devices
        onlineClampYminusController (SimuAutochangerOnlineClampController, 
            nodeID:"3c",serialNB:"xxxx99999",onlineClampName:"onlineClampYminus",
            paramsForCurrent:[
                MotorType:1, PositionSensorType:0,PolePairNumber:1,
                ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[
                ProfileAcceleration:30000,
                ProfileDeceleration:30000,
                ProfileVelocity:7000,
                QuickStopDeceleration:10000,
                MaxFollowingError:2000,
                MotionProfileType:0],
            paramsForHoming:[
                HomeOffset:0, MaxProfileVelocity:6930,
                SpeedForSwitchSearch:100,
                SpeedForZeroSearch:10,
                HomingAcceleration:1000,
                CurrentThresholdHomingMode:500,
                HomePosition:0])
    }//end description of bridgeToChanger's children
    //----------------------------------------------
    // END Bridge To CHANGER description
    //----------------------------------------------                //-------------------------------------------------
    // BEGIN Bridge To LOADER description
    //-------------------------------------------------
    // Bridge to loader
    //bridgeToLoader (BridgeToLoader,
    bridgeToLoader (SimuBridgeToCanOpenHardware,
        tcpProxy:ref("$loaderTcpProxyName"))
    {//begin description of children of Loader's bridge         
        // Loader tcp Proxy
        //loaderTcpProxy (LoaderCanOpenProxy,
            "$loaderTcpProxyName" (SimuCanOpenProxy, //works
            //loaderTcpProxyName (SimuCanOpenProxy, //DOES NOT work
            //loaderTcpProxy (SimuCanOpenProxy, //works
            portNumber:51000,fieldBusTimeout:2000,clientName:"TestBench",
            hardwareBootTimeout:1000)
        hooksController (SimuLoaderClampController,
            nodeID:"1b",serialNB:"79007141",
            plutoGatewayName:loaderPlutoGatewayName,
            paramsForCurrent:[
                ContinuousCurrentLimit:3440,
                OutputCurrentLimit:6880,
                MaxSpeedInCurrentMode:2000,
                MotorType:10,PolePairNumber:1,
                PositionSensorType:1],
            paramsForProfilePosition:[
                MinPositionLimit:-300,
                MaxPositionLimit:550000,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        carrierController (SimuLoaderCarrierController,
            nodeID:"1a",serialNB:"80003184",
            plutoGatewayName:"$loaderPlutoGatewayName",
            paramsForCurrent:[
                ContinuousCurrentLimit:7290,
                OutputCurrentLimit:14580,
                MaxSpeedInCurrentMode:9840,
                MotorType:10,
                PositionSensorType:4,
                ThermalTimeConstantWinding:187,
                PolePairNumber:1],
            paramsForProfilePosition:[
                MinPositionLimit:-250,
                MaxPositionLimit:1037700,
                MotionProfileType:0,
                MaxFollowingError:6000,
                MaxProfileVelocity:227, 
                ProfileVelocity:120,
                ProfileAcceleration:100,
                ProfileDeceleration:100,
                QuickStopDeceleration:10000],
            paramsForHoming:[
                HomeOffset:0,
                HomingAcceleration:1000,
                CurrentThresholdHomingMode:500])
        
        // description of plutoGateway
            "$loaderPlutoGatewayName" (SimuLoaderPlutoGateway, 
            nodeID:"1",serialNB:"22d6")
    }//end description of Loader bridge's children
    //----------------------------------------------
    // END Bridge To LOADER description
    //----------------------------------------------
    /**********************************************************************/
    /*                BEGIN OF CAROUSEL DESCRIPTION                       */
    /**********************************************************************/
    //----------------------------
    // BEGIN Carousel description
    carousel (CarouselModule) {
        ////begin description of carousel's children
        for (int i = 1; i<6;i++) {
            "socket${i}"( CarouselSocket,
                clampXminus:ref("clampXminus${i}"),
                clampXplus:ref("clampXplus${i}"),
                position: positionOnCarouselSocket[i-1],
                standbyPosition: standbyPositionSocket[i-1]) {   
                //-------------------------
                // BEGIN clampXminus description
            "clampXminus${i}" (CarouselClampModule,
                    filterPresenceSensor:ref("filterPresenceXminus${i}"),
                    lockSensor:ref("lockSensorXminus${i}"),
                    thermometer:ref("thermometerXminus${i}")) 
                {
                    "filterPresenceXminus${i}" (SimuCarouselClampFilterPresenceSensor,
                        adcName:adcName, numOfAnalogInput:5)
                    
                    "lockSensorXminus${i}" (SimuCarouselClampLockSensor,
                        adcName:adcName, numOfAnalogInput:7) 
                    
                    "thermometerXminus${i}" (SimuThermometer)
                    //                            //adcName:adcName),
                    //                        )
                    
                }
                //-------------------------
                // END clampXminus description
                
                //-------------------------
                // BEGIN clampXplus description
            "clampXplus${i}" (CarouselClampModule,
                    filterPresenceSensor:ref("filterPresenceXplus${i}"),
                    lockSensor:ref("lockSensorXplus${i}"),
                    thermometer:ref("thermometerXplus${i}")) {
                    "filterPresenceXplus${i}" (SimuCarouselClampFilterPresenceSensor,
                        adcName:adcName, numOfAnalogInput:1)
                    
                    "lockSensorXplus${i}" (SimuCarouselClampLockSensor,
                        adcName:adcName, numOfAnalogInput:3)
                    
                    "thermometerXplus${i}" (SimuThermometer)
                    //                         
                    //                            //adcName:adcName),
                    //                        )
                }
                //-------------------------
                // END clampXplus description
            } // END carouselSocket /*SOCKET1*/ description 
        }
        // END carouselSocket /*SOCKET5*/ description
    }
    ////end description of carousel's children
    //END Carousel description
    // ------------------------
    
    
    //**************************************************************************//
    //**************************************************************************//
    // autochanger
    //**************************************************************************//
    //**************************************************************************//
    autochanger(AutoChangerModule,
        plutoGatewayName:acPlutoGatewayName,
        loaderConnectedSensor0:ref("loaderConnectedSensor0"),
        loaderConnectedSensor1:ref("loaderConnectedSensor1"),
        trucks:ref("autochangerTrucks"),   
        latches:ref("latches"),
        onlineClamps:ref("onlineClamps")) {
            loaderConnectedSensor0 ( CanOpenNumericSensor ,
                dioName:acPlutoGatewayName,inputNumero: 4,byteNumero: 2)
            loaderConnectedSensor1 ( CanOpenNumericSensor ,
                dioName:acPlutoGatewayName,inputNumero: 5,byteNumero: 2)  
            //**************************************************************************//
            // autochanger trucks description
            //**************************************************************************//
            autochangerTrucks (AutoChangerTwoTrucksModule, 
                truckXminus:ref("acTruckXminus"),truckXplus:ref("acTruckXplus")) {
                
                acTruckXminus (AutochangerTruckModule, 
                    handoffPositionSensor:ref("handoffPositionSensorXminus"),
                    handoffPositionSensorB:ref("handoffPositionSensorBXminus"),
                    onlinePositionSensor:ref("onlinePositionSensorXminus"),
                    onlinePositionSensorB:ref("onlinePositionSensorBXminus"),
                    standbyPositionSensor:ref("standbyPositionSensorXminus"),
                    standbyPositionSensorB:ref("standbyPositionSensorBXminus")) {
                    
                    handoffPositionSensorXminus ( CanOpenNumericSensor ,
                        dioName:acPlutoGatewayName,inputNumero: 0,byteNumero: 1)
                    handoffPositionSensorBXminus ( CanOpenNumericSensor ,
                        dioName:acPlutoGatewayName,inputNumero: 1,byteNumero: 1)
                    onlinePositionSensorXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName,inputNumero: 2,byteNumero: 1)
                    onlinePositionSensorBXminus ( CanOpenNumericSensor ,
                        dioName:acPlutoGatewayName,inputNumero: 3,byteNumero: 1)
                    standbyPositionSensorXminus ( CanOpenNumericSensor ,
                        dioName:acPlutoGatewayName,inputNumero: 6,byteNumero: 0)
                    standbyPositionSensorBXminus ( CanOpenNumericSensor ,
                        dioName:acPlutoGatewayName,inputNumero: 7,byteNumero: 0)                                       
                }//end description of autochanger acTruckXminus children
                
                acTruckXplus (AutochangerTruckModule, 
                    handoffPositionSensor:ref("handoffPositionSensorXplus"),
                    handoffPositionSensorB:ref("handoffPositionSensorBXplus"),
                    onlinePositionSensor:ref("onlinePositionSensorXplus"),
                    onlinePositionSensorB:ref("onlinePositionSensorBXplus"),
                    standbyPositionSensor:ref("standbyPositionSensorXplus"),
                    standbyPositionSensorB:ref("standbyPositionSensorBXplus")
                ) {
                    handoffPositionSensorXplus ( CanOpenNumericSensor ,
                        dioName:acPlutoGatewayName,inputNumero: 0,byteNumero: 9)
                    handoffPositionSensorBXplus ( CanOpenNumericSensor ,
                        dioName:acPlutoGatewayName,inputNumero: 1,byteNumero: 9)
                    onlinePositionSensorXplus ( CanOpenNumericSensor ,
                        dioName:acPlutoGatewayName,inputNumero: 2,byteNumero: 9)
                    onlinePositionSensorBXplus ( CanOpenNumericSensor ,
                        dioName:acPlutoGatewayName,inputNumero: 3,byteNumero: 9)
                    standbyPositionSensorXplus ( CanOpenNumericSensor ,
                        dioName:acPlutoGatewayName,inputNumero: 6,byteNumero: 8)
                    standbyPositionSensorBXplus ( CanOpenNumericSensor ,
                        dioName:acPlutoGatewayName,inputNumero: 7,byteNumero: 8)                                       
                }//end description of autochanger acTruckXplus children
            }//end description of autochanger trucks children            
            //**************************************************************************//
            // end of autochanger trucks description
            //**************************************************************************//
            
            //**************************************************************************//
            // autochanger latches description
            //**************************************************************************//
            latches (AutochangerTwoLatches, 
                latchXminus:ref("latchXminus"),latchXplus:ref("latchXplus")) {
                //*************************************//
                // autochanger latchXminus description
                //*************************************//
                latchXminus (AutochangerLatchModule,
                    latchController:ref("latchXminusController"),
                    lockSensor:ref("lockSensorLatchXminus"),
                    lockSensorB:ref("lockSensorBLatchXminus"),
                    unlockSensor:ref("unlockSensorLatchXminus"),
                    unlockSensorB:ref("unlockSensorBLatchXminus"),
                    filterPresenceSensor:ref("filterEngagedSensorLatchXminus"),
                    filterPresenceSensorB:ref("filterEngagedSensorBLatchXminus")
                ) {//begin description of autochanger latchXminus children
                    lockSensorLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:2, byteNumero:0)
                    lockSensorBLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:3, byteNumero:0)
                    unlockSensorLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:0, byteNumero:0)
                    unlockSensorBLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:1, byteNumero:0)
                    filterEngagedSensorLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:4, byteNumero:0)
                    filterEngagedSensorBLatchXminus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:5, byteNumero:0)
                }//end description of autochanger latchXminus children
                //**********************************************//
                // end of autochanger latchXminus description   //
                //**********************************************//
                //*************************************//
                // autochanger latchXplus description
                //*************************************//
                latchXplus (AutochangerLatchModule,
                    latchController:ref("latchXplusController"),
                    lockSensor:ref("lockSensorLatchXplus"),
                    lockSensorB:ref("lockSensorBLatchXplus"),
                    unlockSensor:ref("unlockSensorLatchXplus"),
                    unlockSensorB:ref("unlockSensorBLatchXplus"),
                    filterPresenceSensor:ref("filterEngagedSensorLatchXplus"),
                    filterPresenceSensorB:ref("filterEngagedSensorBLatchXplus")
                ) {//begin description of autochanger latchXplus children
                    //latchCloseXp
                    lockSensorLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:2, byteNumero:8)
                    //latchCloseXp_b
                    lockSensorBLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:3, byteNumero:8)
                    //latchOpenXp
                    unlockSensorLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:0, byteNumero:8) 
                    //latchOpenXp_b
                    unlockSensorBLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:1, byteNumero:8) 
                    filterEngagedSensorLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:4, byteNumero:8)
                    filterEngagedSensorBLatchXplus ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero:5, byteNumero:8)
                }//end description of autochanger latchXplus children
                //**********************************************//
                // end of autochanger latchXplus description   //
                //**********************************************//
            }//end description of autochanger latches children
            //*****************************************************************************//
            // end of autochanger latches description
            //*****************************************************************************//
            
            //**************************************************************************//
            //**************************************************************************//
            // autochanger onlineClamps description
            //**************************************************************************//
            //**************************************************************************//
            onlineClamps (AutochangerThreeOnlineClamps, 
                onlineClampXminus:ref("onlineClampXminus"), 
                onlineClampXplus:ref("onlineClampXplus"), 
                onlineClampY:ref("onlineClampYminus")) {//begin description of autochanger onlineClamps children
                
                onlineClampXminus(AutochangerOnlineClampModule ,
                    onlineClampController:ref("onlineClampXminusController"),
                    lockSensor0:ref("onlineClampXminusLockSensor"),
                    lockSensor1:ref("onlineClampXminusCLockSensor"),
                    unlockSensor0:ref("onlineClampXminusUnlockSensor"),
                    unlockSensor1:ref("onlineClampXminusCUnlockSensor"),
                    paramsForCurrentToLock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],
                    paramsForCurrentToUnlock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930])
                {//begin description of autochanger onlineClampXminus children
                    onlineClampXminusLockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero: 6, byteNumero: 1)
                    onlineClampXminusCLockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero: 7, byteNumero: 1)
                    onlineClampXminusUnlockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero: 4, byteNumero: 1)
                    onlineClampXminusCUnlockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero: 5, byteNumero: 1)
                }//end of  description of autochanger onlineClampXminus children
                
                onlineClampXplus(AutochangerOnlineClampModule ,
                    onlineClampController:ref("onlineClampXplusController"),
                    lockSensor0:ref("onlineClampXplusLockSensor"),
                    lockSensor1:ref("onlineClampXplusCLockSensor"),
                    unlockSensor0:ref("onlineClampXplusUnlockSensor"),
                    unlockSensor1:ref("onlineClampXplusCUnlockSensor"),
                    paramsForCurrentToLock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],
                    paramsForCurrentToUnlock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930]
                )
                {//begin description of autochanger onlineClampXplus children
                    onlineClampXplusLockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero: 4, byteNumero: 3)
                    onlineClampXplusCLockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero: 5, byteNumero: 3)
                    onlineClampXplusUnlockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName,inputNumero: 6, byteNumero: 3)
                    onlineClampXplusCUnlockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero: 7, byteNumero: 3)
                }//end of  description of autochanger onlineClampXplus children
                
                onlineClampYminus(AutochangerOnlineClampModule ,
                    onlineClampController:ref("onlineClampYminusController"),
                    lockSensor0:ref("onlineClampYminusLockSensor"),
                    lockSensor1:ref("onlineClampYminusCLockSensor"),
                    unlockSensor0:ref("onlineClampYminusUnlockSensor"),
                    unlockSensor1:ref("onlineClampYminusCUnlockSensor"),
                    paramsForCurrentToLock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],
                    paramsForCurrentToUnlock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930]
                ) {
                    onlineClampYminusLockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero: 2, byteNumero: 2)
                    onlineClampYminusCLockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero: 3, byteNumero: 2)
                    onlineClampYminusUnlockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero: 0, byteNumero: 2)
                    onlineClampYminusCUnlockSensor ( CanOpenNumericSensor,
                        dioName:acPlutoGatewayName, inputNumero: 1, byteNumero: 2)
                }//end of  description of autochanger onlineClampYminus children
            }//end of  description of autochanger onlineClamps children
            //**************************************************************************//
            // end of autochanger onlineClamps description
            //**************************************************************************//
            
        }//end description of autochanger children
        //*****************************************************************************//
        //*****************************************************************************//
        // end of autochanger description
        //*****************************************************************************//
        //*****************************************************************************//
        //
        //begin description of loader
        loader(LoaderModule,
            carrier:ref("carrier"),
            clamp:ref("clamp"),
            plutoGatewayName:loaderPlutoGatewayName,
            filterPresenceSensor0:ref("loaderFilterPresenceSensor0"),
            filterPresenceSensor1:ref("loaderFilterPresenceSensor1"),
            loaderOnCameraSensor0:ref("loaderOnCameraSensor0"),
            loaderOnCameraSensor1:ref("loaderOnCameraSensor1")) {
            
            carrier(LoaderCarrierModule,
                handoffPositionSensor:ref("loaderHandoffPositionSensor0"),
                handoffPositionSensor1:ref("loaderHandoffPositionSensor1"),
                storagePositionSensor:ref("loaderStoragePositionSensor0"),
                storagePositionSensor1:ref("loaderStoragePositionSensor1")) {
                
                loaderHandoffPositionSensor0 ( CanOpenNumericSensor ,
                    dioName:loaderPlutoGatewayName, inputNumero: 6, byteNumero: 1)
                loaderHandoffPositionSensor1 ( CanOpenNumericSensor ,
                    dioName:loaderPlutoGatewayName, inputNumero: 7, byteNumero: 1)
                loaderStoragePositionSensor0 ( CanOpenNumericSensor ,
                    dioName:loaderPlutoGatewayName, inputNumero: 4, byteNumero: 1)
                loaderStoragePositionSensor1 ( CanOpenNumericSensor ,
                    dioName:loaderPlutoGatewayName,inputNumero: 5, byteNumero: 1)                                       
            }//end description of loader carrier's children
            
            clamp(LoaderClampModule,
                hook1:ref("hook1"),hook2:ref("hook2"),hook3:ref("hook3"),hook4:ref("hook4"),
                paramsForCurrentToClamp:[
                    ContinuousCurrentLimit:500,
                    OutputCurrentLimit:1000,
                    MaxSpeedInCurrentMode:500],
                paramsForCurrentToGoHomePosition:[
                    ContinuousCurrentLimit:500,
                    OutputCurrentLimit:1000,
                    MaxSpeedInCurrentMode:500]) {
                
                hook1(LoaderHookModule,
                    lockSensor:ref("loaderLockSensor1"),
                    unlockSensor:ref("loaderUnlockSensor1"))
                {
                    loaderLockSensor1 ( CanOpenNumericSensor ,
                        dioName:loaderPlutoGatewayName,inputNumero: 4,byteNumero: 0)
                    loaderUnlockSensor1 ( CanOpenNumericSensor ,
                        dioName:loaderPlutoGatewayName,inputNumero: 0,byteNumero: 0)
                }
                
                hook2(LoaderHookModule,
                    lockSensor:ref("loaderLockSensor2"),
                    unlockSensor:ref("loaderUnlockSensor2"))
                {
                    loaderLockSensor2 ( CanOpenNumericSensor ,
                        dioName:loaderPlutoGatewayName,inputNumero: 5,byteNumero: 0)
                    loaderUnlockSensor2 ( CanOpenNumericSensor ,
                        dioName:loaderPlutoGatewayName,inputNumero: 1,byteNumero: 0)
                }
                
                hook3(LoaderHookModule,
                    lockSensor:ref("loaderLockSensor3"),
                    unlockSensor:ref("loaderUnlockSensor3"))
                {
                    loaderLockSensor3 ( CanOpenNumericSensor ,
                        dioName:loaderPlutoGatewayName,inputNumero: 6,byteNumero: 0)
                    loaderUnlockSensor3 ( CanOpenNumericSensor ,
                        dioName:loaderPlutoGatewayName,inputNumero: 2,byteNumero: 0)
                }
                
                hook4(LoaderHookModule,
                    lockSensor:ref("loaderLockSensor4"),
                    unlockSensor:ref("loaderUnlockSensor4"))
                {
                    loaderLockSensor4 ( CanOpenNumericSensor ,
                        dioName:loaderPlutoGatewayName,inputNumero: 7,byteNumero: 0)
                    loaderUnlockSensor4 ( CanOpenNumericSensor ,
                        dioName:loaderPlutoGatewayName,inputNumero: 3,byteNumero: 0)
                }
                
                loaderFilterPresenceSensor0(CanOpenNumericSensor ,
                    dioName:loaderPlutoGatewayName,inputNumero: 0,byteNumero: 1)
                
                loaderFilterPresenceSensor1(CanOpenNumericSensor ,
                    dioName:loaderPlutoGatewayName,inputNumero: 1,byteNumero: 1)
                
                loaderOnCameraSensor0(CanOpenNumericSensor ,
                    dioName:loaderPlutoGatewayName,inputNumero: 2,byteNumero: 1)
                
                loaderOnCameraSensor1(CanOpenNumericSensor ,
                    dioName:loaderPlutoGatewayName,inputNumero: 3,byteNumero: 1)
            }//end description of loader's children
            
        }    // main
    }
