/*******************************************************************************/
/*        Description file for the carousel in standalone mode                 */
/*                                                                             */
/*******************************************************************************/


/*******************************************************************************/
/* The file carousel__simulation.groovy is generated with the script :         */
/* generateCarouselDescription.sh                                              */
/* from the files carousel-standalone_head,     socket__simulation__model      */
/* DO NOT MODIFY carousel__simulation.groovy : the changes will be lost after  */
/* the next generation.                                                        */
/*******************************************************************************/

package carouselSimulation

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.singlefiltertest.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.framework.Configurable
import org.lsst.ccs.description.groovy.CCSBuilder

//for each socket we define a position on the carousel : positionOnCarouselSocket
//and the position of the socket when it is at STANDBY position.
def positionOnCarouselSocket = [0,72,144,216,288] as int[]

def standbyPositionSocket = [0, 288, 216, 144, 72] as int[]

//Carousel Can Open Devices (CAN-CBX-AI814) for Carousel brakes status + brakes temperatures
def adcName = "ai814"

//Carousel clamps controllers name
def clampXminusControllerName = "clampXminusController" //controller to unlock clamp on the side Xminus
def clampXplusControllerName =  "clampXplusController" //controller to unlock clamp on the side Xplus

def plutoGatewayName = "fakePlutoGateway" // to monitor the fake autochanger sensors

CCSBuilder builder = ["carousel-standalone"]

builder.
    main ( CarouselMainModule, bridge:ref("bridge"), filterMg:ref("filterManager"), plutoGatewayName:plutoGatewayName) {       

    bridge (SimuBridgeToCanOpenHardware, tcpProxy:ref("tcpProxy")) {
        
        tcpProxy (SimuCanOpenProxy,
            portNumber: 54321, fieldBusTimeout: 2000, clientName:"TestBench",
            hardwareBootTimeout:2500)        
        
        clampXminusController (SimuCarouselClampController,
            nodeID:"1a", serialNB:"79003317",
            paramsForCurrent: [
                MotorType:11, 
                PositionSensorType:3,
                PolePairNumber:8,
                ContinuousCurrentLimit:2360,
                OutputCurrentLimit:4720,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:25],
            paramsForProfilePosition: [MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        
        clampXplusController (SimuCarouselClampController,
            nodeID:"1b", serialNB:"79003313",
            paramsForCurrent: [
                MotorType:11, 
                PositionSensorType:3,
                PolePairNumber:8,
                ContinuousCurrentLimit:2360,
                OutputCurrentLimit:4720,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:25],
            paramsForProfilePosition: [MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        
        carouselController (SimuCarouselController,
            nodeID:"1c", serialNB:"7900xxxxx",
            paramsForCurrent:[
                ContinuousCurrentLimit:3440,
                OutputCurrentLimit:6880,
                MaxSpeedInCurrentMode:2000,
                MotorType:10,PolePairNumber:1,
                PositionSensorType:1],
            paramsForProfilePosition: [
                MinPositionLimit:-300,
                MaxPositionLimit:550000,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        
        // can open devices to read clamps sensors
        hyttc580 (CanOpenDevice, nodeID:"1d", serialNB:"44110125008180")
        
        // can open devices to read brakes sensors and temperatures
        ai814 (SimuCanOpenADC, nodeID:"1e", serialNB:"c7yyyyyy", transmissionType:"1")
        
        // can open devices to read brakes sensors and temperatures
        pt100 (CanOpenDevice, nodeID:"1f", serialNB:"c7zzzzzz")  
        
        // description of plutoGateway 
        //this has to be changed because in carousel we don't have a plutoGateway.
        "$plutoGatewayName" (SimuCarouselStandalonePlutoGateway, nodeID:"1", serialNB:"22d6")
    } //end of carousel's bridge hardware
    //**************************************************************************//
    // end of Bridge
    //**************************************************************************//
    //-------------------------
    // BEGIN Filter Manager description
    filterManager(FilterManager)
    {//begin description of filter manager's children
        filterU (Filter,filterID:1, weight:38, socketName:"socket1")
        filterG (Filter,filterID:2, weight:33, socketName:"socket2")
        filterR (Filter,filterID:3, weight:30, socketName:"socket3")
        filterI (Filter,filterID:4, weight:28, socketName:"socket4")
        filterZ (Filter,filterID:5, weight:28, socketName:"socket5")
        filterY (Filter,filterID:6, weight:22.5,socketName:"OUT")
        dummyFilter (Filter,filterID:10,weight:44.5,socketName:"OUT")
    }//end description of filter manager's children
    // END Filter Manager description
    // ------------------------------
    
    /**********************************************************************/
    /*                FAKE AUTOCHANGER DESCRIPTION                       */
    /**********************************************************************/
    //in the carousel standalone subsystem the fake autochanger is a switch which
    //simulate that autochanger holds a filter at STANDBY 
    
    autochanger(FakeFilterHolder,
        plutoGatewayName: plutoGatewayName,
        holdingFilterSensor:ref("autochangerHoldingFilterSensor"))
        {//begin description of fakeAutochanger's children 
            autochangerHoldingFilterSensor(CanOpenNumericSensor ,
                dioName:plutoGatewayName, inputNumero: 5, byteNumero: 4)
        }//end description of fakeAutochanger's children

        /**********************************************************************/
        /*                END of FAKE AUTOCHANGER DESCRIPTION                 */
        /**********************************************************************/

        /**********************************************************************/
        /*                BEGIN OF CAROUSEL DESCRIPTION                       */
        /**********************************************************************/

    //----------------------------
    // BEGIN Carousel description
    carousel(CarouselModule)
    {//begin description of carousel's children
        /**********************************************************************/
        /*DO NOT MODIFY socket description in file carousel__simulation.groovy*/
        /*MODIFY socket description in socket__simulation_model.groovy        */
        /**********************************************************************/
        /*SOCKET1*/
        for (int i = 1; i<6;i++ ) {
            "socket${i}" ( CarouselSocket,
                clampXminus:ref("clampXminus${i}"),
                clampXplus:ref("clampXplus${i}"),
                position: positionOnCarouselSocket[i-1],
                standbyPosition: standbyPositionSocket[i-1])
            {   
                //-------------------------
                // BEGIN clampXminus description
                "clampXminus${i}" (CarouselClampModule,
                    filterPresenceSensor:ref("filterPresenceXminus${i}"),
                    lockSensor:ref("lockSensorXminus${i}"),
                    thermometer:ref("thermometerXminus${i}")) 
                {
                    "filterPresenceXminus${i}" (SimuCarouselClampFilterPresenceSensor,
                        adcName:adcName, numOfAnalogInput:5)
                    
                    "lockSensorXminus${i}" (SimuCarouselClampLockSensor,
                        adcName:adcName, numOfAnalogInput:7) 
                    
                    "thermometerXminus${i}" (SimuThermometer)
                    //                            //adcName:adcName),
                    //                        )
                    
                }
                //-------------------------
                // END clampXminus description
                
                //-------------------------
                // BEGIN clampXplus description
                "clampXplus${i}" (CarouselClampModule,
                    filterPresenceSensor:ref("filterPresenceXplus${i}"),
                    lockSensor:ref("lockSensorXplus${i}"),
                    thermometer:ref("thermometerXplus${i}"))
                {
                    "filterPresenceXplus${i}" (SimuCarouselClampFilterPresenceSensor,
                        adcName:adcName, numOfAnalogInput:1)
                    
                    "lockSensorXplus${i}" (SimuCarouselClampLockSensor,
                        adcName:adcName, numOfAnalogInput:3)
                    
                    "thermometerXplus${i}" (SimuThermometer)
                    //                         
                    //                            //adcName:adcName),
                    //                        )
                }
                //-------------------------
                // END clampXplus description
            } // END carouselSocket /*SOCKET1*/ description
        }
    }//end description of carousel's children
    //END Carousel description
    // ------------------------
}    // main
