package autochanger

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.description.groovy.CCSBuilder



def acPlutoGatewayName = "acPlutoGateway" // to monitor the autochanger sensors

CCSBuilder builder = ["autochanger-standalone"]

builder.
    main (AutochangerMainModule, 
    bridge:ref("bridge"), autochanger:ref("autochanger"), inclinometer:ref("inclinometer"))
//begin description of Main submodules
{  
    //-------------------------
    // BEGIN Filter Manager description
    
    filterManager(FilterManager) {//begin description of filter manager's children
        filterU (Filter,filterID:1, weight:38, socketName:"socket1")
        filterG (Filter,filterID:2, weight:33, socketName:"socket2")
        filterR (Filter,filterID:3, weight:30, socketName:"socket3")
        filterI (Filter,filterID:4, weight:28, socketName:"socket4")
        filterZ (Filter,filterID:5, weight:28, socketName:"socket5")
        filterY (Filter,filterID:6, weight:22.5,socketName:"OUT")
        dummyFilter (Filter,filterID:10,weight:44.5,socketName:"OUT")
    }//end description of filter manager's children
    // END Filter Manager description
    // ------------------------------
    
    //-------------------------
    // BEGIN Filter Identificator description
    filterIdentificator(FilterIdentificator,plutoGatewayName: acPlutoGatewayName)
    {//begin description of filter Identificator's children
        filterIDSensor0 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:0,byteNumero:5)
        
        filterIDSensor1 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:1,byteNumero:5)
        
        filterIDSensor2 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:2,byteNumero:5)
        
        filterIDSensor3 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:3,byteNumero:5)
        
        filterIDSensor4 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:4,byteNumero:5)
        
        filterIDSensor5 ( CanOpenNumericSensor,
            dioName:acPlutoGatewayName,inputNumero:5,byteNumero:5)
    }//end description of filter identificator's children
    // END Filter Identificator description
    //**************************************************************************//
    // Bridge
    //**************************************************************************//
    bridge (SimuBridgeToCanOpenHardware,tcpProxy:ref("tcpProxy"))
    //************************************//
    {//begin description of bridge's children
        //************************************//
        
        // tcp Proxy
        tcpProxy (SimuCanOpenProxy,
            portNumber:50000,fieldBusTimeout:2000,clientName:"TestBench",
            hardwareBootTimeout:1000
        )
        
        // can open devices
        "$acPlutoGatewayName" (SimuAutochangerStandalonePlutoGateway,
                nodeID:"30",serialNB:"2071"/*,station_addr:"01")*/)
        
        // can open devices
        linearRailMasterController (SimuAutochangerLinearRailController, 
            nodeID:"2a",serialNB:"80001881",plutoGatewayName:acPlutoGatewayName,
            paramsForCurrent:[
                MotorType:10, PositionSensorType:260,PolePairNumber:1,
                ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                ThermalTimeConstantWinding:187,
                MaxSpeedInCurrentMode:9140],
            paramsForProfilePosition:[
                ProfileAcceleration:1207, ProfileDeceleration:1207,
                MaxProfileVelocity:322, QuickStopDeceleration:1207,
                MaxFollowingError:200000,//on verra plus tard
                ProfileVelocity:281,MotionProfileType:0],
            paramsForHoming:[HomeOffset:0]
        )

        // can open devices
        linearRailSlaveController (SimuAutochangerLinearRailController, 
            nodeID:"2b",serialNB:"80001932",plutoGatewayName:acPlutoGatewayName,
            paramsForCurrent:[
                MotorType:10, PositionSensorType:1,PolePairNumber:1,
                ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                ThermalTimeConstantWinding:187,MaxSpeedInCurrentMode:9140],
            paramsForProfilePosition: [
                ProfileAcceleration:30000,
                ProfileDeceleration:30000,
                ProfileVelocity:7000,
                QuickStopDeceleration:30000,
                MaxFollowingError:7000,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])

        latchXminusController (SimuAutochangerLatchController,  //CanOpenEPOS24-3
            nodeID:"4",serialNB:"84004711",latchName:"latchXminus",plutoGatewayName:acPlutoGatewayName,
            paramsForCurrent:[MotorType:1, PositionSensorType:0,PolePairNumber:2,
                ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                ThermalTimeConstantWinding:40,
                MaxSpeedInCurrentMode:100],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0],
        )

        // can open devices
        latchXplusController (SimuAutochangerLatchController,  //CanOpenEPOS24-3
            nodeID:"5", serialNB:"999XXXX", latchName:"latchXplus", plutoGatewayName:acPlutoGatewayName,
            paramsForCurrent:[
                MotorType:1, PositionSensorType:0,PolePairNumber:2,
                ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                ThermalTimeConstantWinding:40,MaxSpeedInCurrentMode:100],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])

        // can open devices
        onlineClampXminusController (SimuAutochangerOnlineClampController, 
            nodeID:"3a",serialNB:"79011616",onlineClampName:"onlineClampXminus",
            paramsForCurrent: [
                MotorType:1, PositionSensorType:0,PolePairNumber:1,
                ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:160,MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[ 
                ProfileAcceleration:30000, ProfileDeceleration:30000,
                ProfileVelocity:7000, QuickStopDeceleration:10000,
                MaxFollowingError:2000, MotionProfileType:0],
            paramsForHoming:[
                HomeOffset:0, MaxProfileVelocity:6930,
                SpeedForSwitchSearch:100, SpeedForZeroSearch:10,
                HomingAcceleration:1000,CurrentThresholdHomingMode:500,
                HomePosition:0]
        )
        // can open devices
        onlineClampXplusController (SimuAutochangerOnlineClampController, 
            nodeID:"3b", serialNB:"xxxx99999", onlineClampName:"onlineClampXplus",
            paramsForCurrent: [
                MotorType:1, 
                PositionSensorType:0,
                PolePairNumber:1,
                ContinuousCurrentLimit:5000,
                OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:160, 
                MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[
                ProfileAcceleration:30000, 
                ProfileDeceleration:30000,
                ProfileVelocity:7000, 
                QuickStopDeceleration:10000,
                MaxFollowingError:2000, 
                MotionProfileType:0],
            paramsForHoming:[
                HomeOffset:0, 
                MaxProfileVelocity:6930, 
                SpeedForSwitchSearch:100,
                SpeedForZeroSearch:10, 
                HomingAcceleration:1000,
                CurrentThresholdHomingMode:500, 
                HomePosition:0]
        )
        // can open devices
        onlineClampYminusController (SimuAutochangerOnlineClampController, 
            nodeID:"3c", serialNB:"xxxx99999", onlineClampName:"onlineClampYminus",
            paramsForCurrent:[
                MotorType:1, PositionSensorType:0,PolePairNumber:1,
                ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:160, MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[
                ProfileAcceleration:30000,
                ProfileDeceleration:30000,
                ProfileVelocity:7000,
                QuickStopDeceleration:10000,
                MaxFollowingError:2000,
                MotionProfileType:0],
            paramsForHoming:[
                HomeOffset:0, MaxProfileVelocity:6930,
                SpeedForSwitchSearch:100,
                SpeedForZeroSearch:10,
                HomingAcceleration:1000,
                CurrentThresholdHomingMode:500,
                HomePosition:0]
        )
        //************************************//            
    }//end description of bridge's children
    //************************************//
    //**************************************************************************//
    // end of Bridge
    //**************************************************************************//
    
    inclinometer (InclinometerModule, plutoGatewayName:acPlutoGatewayName)
    
    /**********************************************************************/
    /*                FAKE CAROUSEL DESCRIPTION                       */
    /**********************************************************************/
    //in the autochanger standalone subsystem the fake carousel is a switch which
    //simulates that carousel holds a filter at STANDBY 
    
    carousel(FakeFilterHolder,
        plutoGatewayName:acPlutoGatewayName, holdingFilterSensor:ref("carouselHoldingFilterSensor"))
    {//begin description of fakeCarousel's children 
        carouselHoldingFilterSensor(CanOpenNumericSensor ,
            dioName:acPlutoGatewayName, inputNumero:5,byteNumero:4)
    }//end description of fakeCarousel's children
    
        /**********************************************************************/
        /*                END of FAKE CAROUSEL DESCRIPTION                 */
        /**********************************************************************/

        /**********************************************************************/
        /*                FAKE LOADER DESCRIPTION                       */
        /**********************************************************************/
        //in the autochanger standalone subsystem the fake loader is a switch which
        //simulate that loader holds a filter at HANDOFF 

    loader(FakeFilterHolder, plutoGatewayName:acPlutoGatewayName, holdingFilterSensor:ref("loaderHoldingFilterSensor"))
    {//begin description of fakeAutochanger's children 
        loaderHoldingFilterSensor(CanOpenNumericSensor ,
            dioName:acPlutoGatewayName, inputNumero:4, byteNumero:5)
    }//end description of fakeLoader's children
    
    /**********************************************************************/
    /*                END of FAKE AUTOCHANGER DESCRIPTION                 */
    /**********************************************************************/
    
    //**************************************************************************//
    //**************************************************************************//
    // autochanger
    //**************************************************************************//
    //**************************************************************************//
    autochanger(AutoChangerModule,
        plutoGatewayName:acPlutoGatewayName,
        loaderConnectedSensor0:ref("loaderConnectedSensor0"),
        loaderConnectedSensor1:ref("loaderConnectedSensor1"),
        trucks:ref("autochangerTrucks"),
        latches:ref("latches"),
        onlineClamps:ref("onlineClamps"))
    {//begin description of autochanger children
        loaderConnectedSensor0 ( CanOpenNumericSensor ,
            dioName:acPlutoGatewayName, inputNumero:4, byteNumero:2)
        loaderConnectedSensor1 ( CanOpenNumericSensor ,
            dioName:acPlutoGatewayName, inputNumero:5, byteNumero:2)
        //**************************************************************************//
        // autochanger trucks description
        //**************************************************************************//
        autochangerTrucks (AutoChangerTwoTrucksModule, 
            truckXminus:ref("acTruckXminus"), truckXplus:ref("acTruckXplus"))
        {//begin description of autochanger trucks children
            acTruckXminus (AutochangerTruckModule, 
                handoffPositionSensor:ref("handoffPositionSensorXminus"),
                handoffPositionSensorB:ref("handoffPositionSensorBXminus"),
                onlinePositionSensor:ref("onlinePositionSensorXminus"),
                onlinePositionSensorB:ref("onlinePositionSensorBXminus"),
                standbyPositionSensor:ref("standbyPositionSensorXminus"),
                standbyPositionSensorB:ref("standbyPositionSensorBXminus"))
            {//begin description of autochanger truckXminus children

                handoffPositionSensorXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:0, byteNumero:1)
                handoffPositionSensorBXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:1, byteNumero:1)
                onlinePositionSensorXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:2, byteNumero:1)
                onlinePositionSensorBXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName,inputNumero:3, byteNumero:1)
                standbyPositionSensorXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:6, byteNumero:0)
                standbyPositionSensorBXminus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:7, byteNumero:0)
            }//end description of autochanger acTruckXminus children
            acTruckXplus (AutochangerTruckModule, 
                handoffPositionSensor:ref("handoffPositionSensorXplus"),
                handoffPositionSensorB:ref("handoffPositionSensorBXplus"),
                onlinePositionSensor:ref("onlinePositionSensorXplus"),
                onlinePositionSensorB:ref("onlinePositionSensorBXplus"),
                standbyPositionSensor:ref("standbyPositionSensorXplus"),
                standbyPositionSensorB:ref("standbyPositionSensorBXplus"))
            {//begin description of autochanger truckXplus children
                handoffPositionSensorXplus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero: 0, byteNumero:9)                                    
                handoffPositionSensorBXplus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:1, byteNumero:9)
                onlinePositionSensorXplus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:2, byteNumero:9)
                onlinePositionSensorBXplus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:3, byteNumero:9)
                standbyPositionSensorXplus( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:6, byteNumero:8)
                standbyPositionSensorBXplus ( CanOpenNumericSensor ,
                    dioName:acPlutoGatewayName, inputNumero:7, byteNumero:8)
            }//end description of autochanger acTruckXplus children
            
        }//end description of autochanger trucks children            
        //**************************************************************************//
        // end of autochanger trucks description
        //**************************************************************************//
        
        //**************************************************************************//
        // autochanger latches description
        //**************************************************************************//
        latches (AutochangerTwoLatches, latchXminus:ref("latchXminus"), latchXplus:ref("latchXplus"))
        {//begin description of autochanger latches children
            //*************************************//
            // autochanger latchXminus description
            //*************************************//
            latchXminus (AutochangerLatchModule,
                latchController:ref("latchXminusController"),
                lockSensor:ref("lockSensorLatchXminus"),
                lockSensorB:ref("lockSensorBLatchXminus"),
                unlockSensor:ref("unlockSensorLatchXminus"),
                unlockSensorB:ref("unlockSensorBLatchXminus"),
                filterPresenceSensor:ref("filterEngagedSensorLatchXminus"),
                filterPresenceSensorB:ref("filterEngagedSensorBLatchXminus")
            )
            {//begin description of autochanger latchXminus children
                lockSensorLatchXminus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:2, byteNumero:0)
                lockSensorBLatchXminus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:3, byteNumero:0)
                unlockSensorLatchXminus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:0, byteNumero:0)
                unlockSensorBLatchXminus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:1, byteNumero:0)
                filterEngagedSensorLatchXminus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:4, byteNumero:0)
                filterEngagedSensorBLatchXminus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:5, byteNumero:0)
            }//end description of autochanger latchXminus children
            //**********************************************//
            // end of autochanger latchXminus description   //
            //**********************************************//
            //*************************************//
            // autochanger latchXplus description
            //*************************************//
            latchXplus (AutochangerLatchModule,
                latchController:ref("latchXplusController"),
                lockSensor:ref("lockSensorLatchXplus"),
                lockSensorB:ref("lockSensorBLatchXplus"),
                unlockSensor:ref("unlockSensorLatchXplus"),
                unlockSensorB:ref("unlockSensorBLatchXplus"),
                filterPresenceSensor:ref("filterEngagedSensorLatchXplus"),
                filterPresenceSensorB:ref("filterEngagedSensorBLatchXplus")
            )
            {//begin description of autochanger latchXplus children
                //latchCloseXp
                lockSensorLatchXplus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:2, byteNumero:8)
                //latchCloseXp_b
                lockSensorBLatchXplus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:3, byteNumero:8)
                //latchOpenXp
                unlockSensorLatchXplus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:0, byteNumero:8) 
                //latchOpenXp_b
                unlockSensorBLatchXplus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:1, byteNumero:8) 
                filterEngagedSensorLatchXplus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:4, byteNumero:8)
                filterEngagedSensorBLatchXplus ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero:5, byteNumero:8)
            }//end description of autochanger latchXplus children
            //**********************************************//
            // end of autochanger latchXplus description   //
            //**********************************************//
        }//end description of autochanger latches children
        //*****************************************************************************//
        // end of autochanger latches description
        //*****************************************************************************//
        
        //**************************************************************************//
        //**************************************************************************//
        // autochanger onlineClamps description
        //**************************************************************************//
        //**************************************************************************//
        onlineClamps (AutochangerThreeOnlineClamps, 
            onlineClampXminus:ref("onlineClampXminus"), 
            onlineClampXplus:ref("onlineClampXplus"), 
            onlineClampY:ref("onlineClampYminus")) {//begin description of autochanger onlineClamps children
            
            onlineClampXminus(AutochangerOnlineClampModule ,
                onlineClampController:ref("onlineClampXminusController"),
                lockSensor0:ref("onlineClampXminusLockSensor"),
                lockSensor1:ref("onlineClampXminusCLockSensor"),
                unlockSensor0:ref("onlineClampXminusUnlockSensor"),
                unlockSensor1:ref("onlineClampXminusCUnlockSensor"),
                paramsForCurrentToLock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],
                paramsForCurrentToUnlock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930])
            {//begin description of autochanger onlineClampXminus children
                onlineClampXminusLockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 6, byteNumero: 1)
                onlineClampXminusCLockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 7, byteNumero: 1)
                onlineClampXminusUnlockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 4, byteNumero: 1)
                onlineClampXminusCUnlockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 5, byteNumero: 1)
            }//end of  description of autochanger onlineClampXminus children
            
            onlineClampXplus(AutochangerOnlineClampModule ,
                onlineClampController:ref("onlineClampXplusController"),
                lockSensor0:ref("onlineClampXplusLockSensor"),
                lockSensor1:ref("onlineClampXplusCLockSensor"),
                unlockSensor0:ref("onlineClampXplusUnlockSensor"),
                unlockSensor1:ref("onlineClampXplusCUnlockSensor"),
                paramsForCurrentToLock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],
                paramsForCurrentToUnlock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930]
            )
            {//begin description of autochanger onlineClampXplus children
                onlineClampXplusLockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 4, byteNumero: 3)
                onlineClampXplusCLockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 5, byteNumero: 3)
                onlineClampXplusUnlockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName,inputNumero: 6, byteNumero: 3)
                onlineClampXplusCUnlockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 7, byteNumero: 3)
            }//end of  description of autochanger onlineClampXplus children
            
            onlineClampYminus(AutochangerOnlineClampModule ,
                onlineClampController:ref("onlineClampYminusController"),
                lockSensor0:ref("onlineClampYminusLockSensor"),
                lockSensor1:ref("onlineClampYminusCLockSensor"),
                unlockSensor0:ref("onlineClampYminusUnlockSensor"),
                unlockSensor1:ref("onlineClampYminusCUnlockSensor"),
                paramsForCurrentToLock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],
                paramsForCurrentToUnlock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930]
            )
            {//begin description of autochanger onlineClampYminus children
                onlineClampYminusLockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 2, byteNumero: 2)
                onlineClampYminusCLockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 3, byteNumero: 2)
                onlineClampYminusUnlockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 0, byteNumero: 2)
                onlineClampYminusCUnlockSensor ( CanOpenNumericSensor,
                    dioName:acPlutoGatewayName, inputNumero: 1, byteNumero: 2)
            }//end of  description of autochanger onlineClampYminus children
        }//end of  description of autochanger onlineClamps children
        //**************************************************************************//
        // end of autochanger onlineClamps description
        //**************************************************************************//
        
    }//end description of autochanger children
    //*****************************************************************************//
    //*****************************************************************************//
    // end of autochanger description
    //*****************************************************************************//
    //*****************************************************************************//
    
}    // main
