// see documentation on single-filter-test on : https://confluence.slac.stanford.edu/display/LSSTCAM/Single+Filter+Test
package sftSimulation

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.singlefiltertest.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.startup.CCSBuilder ;


import static org.lsst.gruth.jutils.MapArgs.*


//Carousel Can Open Devices (CAN-CBX-AI814)
def adcName = "ai814"

//Carousel clamps controllers name
def clampXminusControllerName = "clampXminusController" //controller to unlock clamp on the side Xminus
def clampXplusControllerName =  "clampXplusController" //controller to unlock clamp on the side Xplus

//Autochanger Can Open Devices
def dacName = "ao412"  // to control the latches actuator
def railsSensorsDIOName = "dio8n1"  // to control the trucks and monitor the rails sensors
def filterSensorsDIOName = "dio8n2" // to monitor the filter sensors

CCSBuilder builder = ["single-filter-test"]

builder.
        "Main Module" ( SftMainModule,
                argMap(a("name", "main"),
                        anInt("tickMillis", 3000),
                        ref("bridge"),
                        ref("dummyFilter")
                        ))
            
            {//begin description of Main submodules      
                //-------------------------
                // BEGIN Bridge description
                // Bridge
                bridge (SimuBridgeToSFTHardware,
                    argMap(aString("name", "bridge"),
                            anInt("tickMillis", 1000),
                            ref("tcpProxy"),
                            ref("ai814"),
                            ref("ao412"),
                            ref("dio8n1"),
                            ref("dio8n2"),
                            ref("clampXminusController"),
                            ref("clampXplusController")
                        ))

                    {//begin description of bridge's children 
                    // can open devices
                            // tcp Proxy
                            tcpProxy (SimuCanOpenProxy,
                                argMap(aString("name", "tcpProxy"),
                                    anInt("tickMillis", 1000),
                                    anInt("portNumber", 54321,[static:true, 
                                            constraints:1024..99000]),
                                    aString("myClientName","TestBench",[static:true]),
                                    anInt("hardwareBootTimeout",2500, 
                                            [description:"A timeout for the harwdare booting process",
                                            constraints:1000..10000])))
        
                            ai814 (SimuADCDevice, 
                                    argMap(aString("name", "ai814"),
                                        anInt("tickMillis", 3000),
                                        aString("nodeID","21"),
                                        aString("serialNB","c7c40234"),
                                    ))

                            ao412 (SimuADCDevice,
                                    argMap(aString("name", "ao412"),
                                        anInt("tickMillis", 1000),
                                        aString("nodeID","22"),
                                        aString("serialNB","c7c60307")
                                    ))            
            
                            "dio8n1" ( SimuCompactIOModule , 
                                        argMap(a("name", railsSensorsDIOName) ,
                                            anInt("tickMillis", 3000),
                                            aString("nodeID", "23"),
                                            aString("serialNB", "c7ca0914"),
                                            aString("initialHexaValue", "50")
                                        ))
                                    
                            "dio8n2" ( SimuCompactIOModule , 
                                        argMap(a("name", filterSensorsDIOName) ,
                                            anInt("tickMillis", 3000),
                                            aString("nodeID", "24"),
                                            aString("serialNB", "c7ca0913"),
                                            aString("initialHexaValue", "44")
                                        ))
                                    
                            clampXminusController (SimuCarouselClampController,    
                                argMap( a("name", clampXminusControllerName),
                                anInt("tickMillis",3000),
                                aString("nodeID","1a"),
                                aString("serialNB","79003317"),
                                aMap("paramsForCurrent", [MotorType:11, PositionSensorType:3,PolePairNumber:8,
                                        ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                                        ThermalTimeConstantWinding:160,
                                        MaxSpeedInCurrentMode:25]),
                                aMap("paramsForProfilePosition", [MotionProfileType:0]),
                                aMap("paramsForHoming",[HomeOffset:0]),
                                ))  

                            clampXplusController (SimuCarouselClampController,
                                argMap( a("name", clampXplusControllerName),
                                anInt("tickMillis",3000),
                                aString("nodeID","1b"),
                                aString("serialNB","79003313"),
                                aMap("paramsForCurrent", [MotorType:11, PositionSensorType:3,PolePairNumber:8,
                                        ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                                        ThermalTimeConstantWinding:160,
                                        MaxSpeedInCurrentMode:25]),
                                aMap("paramsForProfilePosition", [MotionProfileType:0]),
                                aMap("paramsForHoming",[HomeOffset:0]),                              
                                ))
                            

                    }


                //-------------------------
                // BEGIN Filter description

                dummyFilter (Filter, argMap(aString("name", "dummyFilter"),
                                        anInt("filterID", 10),
                                        aDbl("weight", "44"))) //ok

                // END Filter description
                // ------------------------

                //----------------------------
                // BEGIN Carousel description
                carousel (SimuSftCarouselModule,
                        argMap( a("name", "carousel"),
                                anInt("tickMillis",5000),
                                ref("socket1")

                            ))
                        
                {//begin description of carousel's children
                    "socket1" ( SimuCarouselSocket,
                            argMap(a("name", "socket1"),
                                    anInt("tickMillis",5000),
                                    aRef("clampXminus", "clampXminus"),
                                    aRef("clampXplus", "clampXplus"),
                                    aDbl("position", "0.0"),
                                    aDbl("standbyPosition", "0.0")
                                ))

                            {   
                                //-------------------------
                                // BEGIN clampXminus description
                                 "clampXminus" (SimuCarouselClampXminus,
                                         argMap( a("name", "clampXminus"),
                                                anInt("tickMillis",5000),
                                                aRef("filterPresenceSensor","filterPresenceXminus"),
                                                aRef("lockSensor", "lockSensorXminus"),
                                                aRef("thermometer", "thermometerXminus"),

                                                anInt("filterPositionValueA", 1500, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                                                anInt("filterPositionValueB", 24400, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                                                anInt("filterPositionValueC", 32000 , [description:"above valueC, there is NOFILTER",constraints:0..32768]),
                                                anInt("filterPositionOffset", 0 , [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),

                                                anInt("lockSensorValueA", 5000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                                                anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                                                anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                                                anInt("lockSensorOffset", 0 , [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),

                                                anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                                                anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),

                                                anInt("currentToUnlock", 1500),
                                                anInt("currentToMaintainUnlocked", 200),
                                                ))
                                {
                                    "filterPresenceXminus" (SimuClampFilterPresenceSensor,
                                            argMap( a("name", "filterPresenceXminus"),
                                                anInt("tickMillis",1000),
                                                //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                //anInt("value",5000,[description:"when the simulated sft starts the filter is LOCKABLE",constraints:0..32768])
                                                ))


                                    "lockSensorXminus" (SimuClampLockSensor,
                                            argMap( a("name", "lockSensorXminus"),
                                                anInt("tickMillis",1000),
                                                //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),                                                  
                                                //anInt("value",29000, [description:"when the simulated sft starts the clamps are LOCKED",constraints:0..32768])
                                                ))

                                    "thermometerXminus" (SimuThermometer,
                                            argMap( a("name", "thermometerXminus"),
                                                anInt("tickMillis",1000),
                                                //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                //anInt("value",3000, [description:"an initial temperature",constraints:0..32768])
                                                ))

                                }
                                //-------------------------
                                // END clampXminus description

                                //-------------------------
                                // BEGIN clampXplus description
                                "clampXplus" (SimuCarouselClamp,
                                        argMap( aString("name", "clampXplus"),
                                                anInt("tickMillis",5000),
                                                aRef("filterPresenceSensor","filterPresenceXplus"),
                                                aRef("lockSensor", "lockSensorXplus"),
                                                aRef("thermometer", "thermometerXplus"),

                                                anInt("filterPositionValueA", 1355, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                                                anInt("filterPositionValueB", 10500, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                                                anInt("filterPositionValueC", 32000, [description:"above valueC, there is NOFILTER",constraints:0..32768] ),
                                                anInt("filterPositionOffset", 0, [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),

                                                anInt("lockSensorValueA", 6000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                                                anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                                                anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                                                anInt("lockSensorOffset", 0, [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),

                                                anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                                                anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),

                                                anInt("currentToUnlock", 1500),
                                                anInt("currentToMaintainUnlocked", 200),
                                                ))

                                {
                                    "filterPresenceXplus" (SimuClampFilterPresenceSensor,
                                            argMap( a("name", "filterPresenceXplus"),
                                                    anInt("tickMillis",1000),
                                                    //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                    //anInt("value",5000,[description:"when the simulated sft starts the filter is LOCKABLE"])
                                                    ))


                                    "lockSensorXplus" (SimuClampLockSensor,
                                            argMap( a("name", "lockSensorXplus"),
                                                    anInt("tickMillis",1000),
                                                    //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                    //anInt("value",29000, [description:"when the simulated sft starts the clamps are LOCKED",constraints:0..32768])
                                                    ))

                                    "thermometerXplus" (SimuThermometer,
                                            argMap( a("name", "thermometerXplus"),
                                                    anInt("tickMillis",1000),
                                                    //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                    //anInt("value",3000, [description:"an initial temperature",constraints:0..32768])
                                                    ))


                                }
                                //-------------------------
                                // END clampXplus description

                            } // END carouselSocket description

            }//end description of carousel's children
            //END Carousel description
            // ------------------------

            // ------------------------
            //BEGIN AUTO CHANGER
            autochanger (SftAutoChangerModule,
                    argMap( a("name", "autochanger"),
                            anInt("tickMillis",5000),
                            ref("latchXminus"),
                            ref("latchXplus"),
                            ref("truckXminus"),
                            ref("truckXplus"),
                            aString("railsSensorsDIOName",railsSensorsDIOName,[description:"The name of the DIO where the rails sensors are plugged."]),
                            aString("filterSensorsDIOName",filterSensorsDIOName,[description:"The name of the DIO where the filter sensors are plugged."]),
                            ref("sftTrucksMotor"),
                            anInt("timeToConfortAPosition",2000),
                            anInt("timeToGoToStandby",10000),
                            anInt("timeToGoToStandback",10000),
                            //anInt("timeToWaitForCompleteClose", 2000),
                            //anInt("timeToWaitForCompleteOpen", 2000),
                        ))

            {//begin description of autochanger's children

                // ------------------------
                //BEGIN  SFT TRUCKS MOTOR (AUTOCHANGER)
                sftTrucksMotor(SimuTruckMotorModule,
                        argMap( a("name","sftTrucksMotor"),
                                anInt("tickMillis", 5000)))


                //END  SFT TRUCKS MOTOR
                // ------------------------



                // ------------------------
                //BEGIN  latchMinux    (AUTOCHANGER)
                "latchXminus" (SftFilterLatchModule,
                    argMap( a ("name", "latchXminus") ,
                            anInt("tickMillis", 5000),
                            //aBool("locked")
                            anInt("timeoutForClosing",4000,[description:"timeout in milliseconds : if closing the latches last more than this amount of time, then the subsystem goes in ERROR."]),
                            anInt("timeoutForOpening",4000,[description:"timeout in milliseconds : if opening the latches last more than this amount of time, then the subsystem goes in ERROR."]),
                            //anInt("timeToWaitForCompleteClose", 2000),
                            //anInt("timeToWaitForCompleteOpen", 2000),
                            aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                            aRef("lockSensor","lockSensorLatchXminus"),
                            aRef("unlockSensor","unlockSensorLatchXminus"),
                            aRef("filterPresenceSensor","filterPresenceSensorLatchXminus"),
                            aRef("latchActuator","latchActuatorXminus")))
                    {
                        "lockSensorLatchXminus" ( SimuNumericSensor ,
                            argMap(a ("name", "lockSensorLatchXminus") ,
                                //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))

                        "unlockSensorLatchXminus" ( SimuNumericSensor ,
                            argMap( a("name", "unlockSensorLatchXminus"),
                                //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                        "filterPresenceSensorLatchXminus" ( SimuNumericSensor ,
                            argMap( a("name", "filterPresenceSensorLatchXminus") ,
                                //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                        "latchActuatorXminus" (SimuLatchActuatorModule,
                                argMap(a("name", "latchActuatorXminus") ,
                                        anInt("tickMillis", 3000),
                                            aDbl("speedVoltageInVolt", 4,[description:"decimal value of the voltage (in Volt) to send to the actuator to determine the speed",constraints:-10..10]),
                                            aDbl("currentLimitInVolt", 0.150),
                                            anInt("speedVoltageMaxValue", 10),
                                            anInt("speedVoltageMinValue", -10),
                                            aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                                            ))
                    }
                    // ------------------------
                    //END  latchXminus    (AUTOCHANGER)

                    // ------------------------
                    //BEGIN  latchXplus    (AUTOCHANGER)
                    "latchXplus" (SftFilterLatchModule,
                            argMap( a ("name", "latchXplus") ,
                                    anInt("tickMillis", 5000),
                                    anInt("timeoutForClosing",6000,[description:"timeout in milliseconds : if closing the latches last more than this amount of time, then the subsystem goes in ERROR."]),
                                    anInt("timeoutForOpening",6000,[description:"timeout in milliseconds : if opening the latches last more than this amount of time, then the subsystem goes in ERROR."]),
                                    //anInt("timeToWaitForCompleteClose", 2000),
                                    //anInt("timeToWaitForCompleteOpen", 2000),
                                    aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                                    aRef("lockSensor","lockSensorLatchXplus"),
                                    aRef("unlockSensor","unlockSensorLatchXplus"),
                                    aRef("filterPresenceSensor","filterPresenceSensorLatchXplus"),
                                    aRef("latchActuator","latchActuatorXplus")))

                            {
                                "lockSensorLatchXplus" ( SimuNumericSensor ,
                                    argMap(a ("name", "lockSensorLatchXplus") ,
                                        //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                        anInt("inputNumero", 6, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                                "unlockSensorLatchXplus" ( SimuNumericSensor ,
                                        argMap( a("name", "unlockSensorLatchXplus"),
                                            //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 7, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                                "filterPresenceSensorLatchXplus" ( SimuNumericSensor ,
                                        argMap( a("name", "filterPresenceSensorLatchXplus") ,
                                            //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 5, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))

                                "latchActuatorXplus" (SimuLatchActuatorModule,
                                        argMap(a("name", "latchActuatorXplus") ,
                                            anInt("tickMillis", 3000),
                                            aDbl("speedVoltageInVolt", 4,[description:"decimal value of the voltage (in Volt) to send to the actuator to determine the speed",constraints:-10..10]),
                                            aDbl("currentLimitInVolt", 0.150),
                                            anInt("speedVoltageMaxValue", 10),
                                            anInt("speedVoltageMinValue", -10),                                            
                                            aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                                            ))

                            }
                            //END  LATCH   (AUTOCHANGER)
                            // ------------------------

                    // ------------------------
                    //BEGIN  TRUCK   (AUTOCHANGER)
                    "truckXminus" (  SimuTruckModule ,
                        argMap(  a("name", "truckXminus") ,
                                    anInt("tickMillis", 3000),
                                    aRef("railSensorStandback", "railSensorStandbackXminus"),
                                    aRef("railSensorStandby", "railSensorStandbyXminus") ))
                       {

                           "railSensorStandbackXminus" (  SimuNumericSensor ,
                                   argMap( a("name", "railSensorStandbackXminus"),
                                       //aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                       anInt("inputNumero", 5, [description:"The numero of the input of the DIO where this sensor is plugged."]) ))

                           "railSensorStandbyXminus" (  SimuNumericSensor ,
                                    argMap( a("name", "railSensorStandbyXminus"),
                                       //aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                       anInt("inputNumero", 6 , [description:"The numero of the input of the DIO where this sensor is plugged."]) ))
                       }

                    "truckXplus" (  SimuTruckModule ,
                        argMap(  a("name", "truckXplus") ,
                                anInt("tickMillis", 3000),
                                aRef("railSensorStandback", "railSensorStandbackXplus"),
                                aRef("railSensorStandby", "railSensorStandbyXplus")))
                        {


                            "railSensorStandbackXplus" (  SimuNumericSensor ,
                                    argMap( a("name", "railSensorStandbackXplus"),
                                        //aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                        anInt("inputNumero", 7, [description:"The numero of the input of the DIO where this sensor is plugged."]) ))


                            "railSensorStandbyXplus" (  SimuNumericSensor ,
                                    argMap( a("name", "railSensorStandbyXplus"),
                                        //aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                        anInt("inputNumero", 8, [description:"The numero of the input of the DIO where this sensor is plugged."] ) ))



                        }
                    //END  TRUCK   (AUTOCHANGER)
                    // ------------------------


            }//END AUTO CHANGER
             // ------------------------ 
                      




        //end description of Main submodules
        }

                


