// see documentation on single-filter-test on : https://confluence.slac.stanford.edu/display/LSSTCAM/Single+Filter+Test
package sftHardware

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.singlefiltertest.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.startup.CCSBuilder ;


import static org.lsst.gruth.jutils.MapArgs.*

//Carousel Can Open Devices (CAN-CBX-AI814)
def adcName = "ai814"

//Autochanger Can Open Devices
def dacName = "ao412"  // to control the latches actuator
def railsSensorsDIOName = "dio8n1"  // to control the trucks and monitor the rails sensors
def filterSensorsDIOName = "dio8n2" // to monitor the filter sensors

CCSBuilder builder = ["single-filter-test"]

builder.
        "Main Module" ( SftMainModule,
                argMap(a("name", "main"),
                        anInt("tickMillis", 3000),
                        ref("bridge"),
                        ref("dummyFilter")))
                 


            
            {//begin description of Main submodules       
                //-------------------------
                // BEGIN Bridge description
                // Bridge
                bridge (BridgeToSFTHardware,
                        argMap(aString("name", "bridge"),
                            anInt("tickMillis", 1000),
                            ref("tcpProxy"),
                            ref("ai814"),
                            ref("ao412"),
                            ref("dio8n1"),
                            ref("dio8n2"),
                            ref("clampXminusController"),
                            ref("clampXplusController")))

                {//begin description of bridge's children          

                        // tcp Proxy
                        tcpProxy (CanOpenProxy,
                                argMap(aString("name", "tcpProxy"),
                                    anInt("tickMillis", 1000),
                                    anInt("portNumber", 50000,[static:true, constraints:1024..99000]),
                                    aString("myClientName","TestBench",[static:true]),                                  
                                    anInt("hardwareBootTimeout",1000, [description:"A timeout for the harwdare booting process",constraints:1000..10000])))

                        // can open devices
                        ai814 (CanOpenADC, 
                                argMap(aString("name", "ai814"),
                                    anInt("tickMillis", 3000),
                                    aString("nodeID","21"),
                                    aString("serialNB","c7c40234"),
                                    aString("transmissionType","1")))

                        ao412 (CanOpenDAC,
                                argMap(aString("name", "ao412"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","22"),
                                    aString("serialNB","c7c60307")))

                        dio8n1 (CompactIOModule,
                            argMap(a ("name", "dio8n1"),
                                anInt("tickMillis", 3000),
                                aString("nodeID", "23"),
                                aString("serialNB", "c7ca0914")))

                        dio8n2 (CompactIOModule,
                                    argMap(a ("name", "dio8n2"),
                                    anInt("tickMillis", 3000),
                                    aString("nodeID", "24"),
                                    aString("serialNB", "c7ca0913")))

                        clampXminusController (CanOpenEPOS24,    
                                argMap( a("name", "clampXminusController"),
                                anInt("tickMillis",3000),
                                aString("nodeID","1a"),
                                aString("serialNB","79003317"),
                                aMap("paramsForCurrent", [MotorType:11, PositionSensorType:3,PolePairNumber:8,
                                        ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                                        ThermalTimeConstantWinding:160,
                                        MaxSpeedInCurrentMode:25]),
                                aMap("paramsForProfilePosition", [MotionProfileType:0]),
                                aMap("paramsForHoming",[HomeOffset:0]),
                                ))  

                        clampXplusController (CanOpenEPOS24,
                                argMap( a("name", "clampXplusController"),
                                anInt("tickMillis",3000),
                                aString("nodeID","1b"),
                                aString("serialNB","79003313"),
                                aMap("paramsForCurrent", [MotorType:11, PositionSensorType:3,PolePairNumber:8,
                                        ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                                        ThermalTimeConstantWinding:160,
                                        MaxSpeedInCurrentMode:25]),
                                aMap("paramsForProfilePosition", [MotionProfileType:0]),
                                aMap("paramsForHoming",[HomeOffset:0]),
                                ))
  

                            
                }//end description of bridge's children
                // END Bridge description
                // ------------------------

                //-------------------------
                // BEGIN Filter description

                dummyFilter (Filter, argMap(aString("name", "dummyFilter"),
                                        anInt("filterID", 10),
                                        aDbl("weight", "44")))
                                
                // END Filter description
                // ------------------------

                //----------------------------
                // BEGIN Carousel description
                carousel (SftCarouselModule,
                        argMap( a("name", "carousel"),
                                anInt("tickMillis",5000),
                                ref ("socket1")
                            ))
                        
                {//begin description of carousel's children
                    "socket1" ( CarouselSocket,
                        argMap(  a("name", "socket1"),
                                 anInt("tickMillis",5000),
                                 aRef("clampXminus", "clampXminus"),
                                 aRef("clampXplus", "clampXplus"),
                                 aDbl("position", "0.0"),
                                 aDbl("standbyPosition", "0.0")
                                ))
                              //-------------------------
                            { // BEGIN clampXminus description  
                                
                                
                                 "clampXminus" (CarouselClampXminus,
                                         argMap( a("name", "clampXminus"),
                                                anInt("tickMillis",5000),
                                                aRef("filterPresenceSensor","filterPresenceXminus"),
                                                aRef("lockSensor", "lockSensorXminus"),
                                                aRef("thermometer", "thermometerXminus"),

                                                anInt("filterPositionValueA", 1500, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                                                anInt("filterPositionValueB", 24400, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                                                anInt("filterPositionValueC", 32000 , [description:"above valueC, there is NOFILTER",constraints:0..32768]),
                                                anInt("filterPositionOffset", 0 , [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),

                                                anInt("lockSensorValueA", 5000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                                                anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                                                anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                                                anInt("lockSensorOffset", 0 , [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),

                                                anInt("timeoutForReleasing",1500,[description:"timeout in milliseconds : if closing the clamp last more than this amount of time, then the subsystem goes in ERROR."]),
                                                anInt("timeoutForUnlocking",1500,[description:"timeout in milliseconds : if opening the clamp last more than this amount of time, then the subsystem goes in ERROR."]),

                                                anInt("currentToUnlock", 1500),
                                                anInt("currentToMaintainUnlocked", 200),

                                                ))
                                {
                                    "filterPresenceXminus" (CanOpenSensor14bits,
                                            argMap( a("name", "filterPresenceXminus"),
                                                anInt("tickMillis",5000),
                                                aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                anInt("numOfAnalogInput",5, [description:"The numero of the input of ADC where this sensor is plugged",constraints:1..8])))


                                    "lockSensorXminus" (CanOpenSensor14bits,
                                            argMap( a("name", "lockSensorXminus"),
                                                anInt("tickMillis",5000),
                                                aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                anInt("numOfAnalogInput",7, [description:"The numero of the input of ADC where this sensor is plugged",constraints:1..8])))


                                    "thermometerXminus" ( CanOpenThermometer,
                                            argMap( a("name", "thermometerXminus"),
                                                anInt("tickMillis",5000),
                                                aString("adcName",adcName,[static:true,description:"The name of the ADC where this thermometer is plugged."]),
                                                anInt("numOfAnalogInput","6", [description:"The numero of the input of ADC where this thermometer is plugged",constraints:1..8])))





                                }
                                //-------------------------
                                // END clampXminus description

                                //-------------------------
                                // BEGIN clampXplus description  
                                "clampXplus" (CarouselClampModule,
                                        argMap( a("name", "clampXplus"),
                                                anInt("tickMillis",5000),
                                                aRef("filterPresenceSensor","filterPresenceXplus"),
                                                aRef("lockSensor", "lockSensorXplus"),
                                                aRef("thermometer", "thermometerXplus"),

                                                anInt("filterPositionValueA", 1355, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                                                anInt("filterPositionValueB", 10500, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                                                anInt("filterPositionValueC", 32000, [description:"above valueC, there is NOFILTER",constraints:0..32768] ),
                                                anInt("filterPositionOffset", 0 , [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),

                                                anInt("lockSensorValueA", 6000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                                                //FV 20/03/2015 change lockSensorValueB from 28800 to 28500 because single filter test was moved.
                                                anInt("lockSensorValueB", 28500, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                                                anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                                                anInt("lockSensorOffset", 0 , [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),

                                                anInt("timeoutForReleasing",1500,[description:"timeout in milliseconds : if closing the clamp last more than this amount of time, then the subsystem goes in ERROR."]),
                                                anInt("timeoutForUnlocking",1500,[description:"timeout in milliseconds : if opening the clamp last more than this amount of time, then the subsystem goes in ERROR."]),

                                                anInt("currentToUnlock", 1500),
                                                anInt("currentToMaintainUnlocked", 200),
                                                ))
                                {//begin description of children of clampXplus
                                    "filterPresenceXplus" (CanOpenSensor14bits,
                                            argMap( a("name", "filterPresenceXplus"),
                                                anInt("tickMillis",5000),
                                                    aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                    anInt("numOfAnalogInput",1,[description:"The numero of the input of ADC where this sensor is plugged",constraints:1..8])))


                                    "lockSensorXplus" (CanOpenSensor14bits,
                                            argMap( a("name", "lockSensorXplus"),
                                                    anInt("tickMillis",5000),
                                                    aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                    anInt("numOfAnalogInput",3,[description:"The numero of the input of ADC where this sensor is plugged",constraints:1..8])))


                                    "thermometerXplus" ( CanOpenThermometer,
                                            argMap( a("name", "thermometerXplus"),
                                                    anInt("tickMillis",5000),
                                                    aString("adcName",adcName,[static:true,description:"The name of the ADC where this thermometer is plugged."]),
                                                    anInt("numOfAnalogInput",2,[description:"The numero of the input of ADC where this thermometer is plugged",constraints:1..8])))

                                }
                                //-------------------------
                                // END clampXplus description
                            }

                }//end description of carousel's children
                //END Carousel description
                // ------------------------

                // ------------------------
                //BEGIN AUTO CHANGER
                autochanger (SftAutoChangerModule,
                        argMap( a("name", "autochanger"),
                                anInt("tickMillis",5000),
                                ref("latchXminus"),
                                ref("latchXplus"),
                                ref("truckXminus"),
                                ref("truckXplus"),
                                aString("railsSensorsDIOName",railsSensorsDIOName,[description:"The name of the DIO where the rails sensors are plugged."]),
                                aString("filterSensorsDIOName",filterSensorsDIOName,[description:"The name of the DIO where the filter sensors are plugged."]),
                                ref("sftTrucksMotor"),
                                anInt("timeToConfortAPosition",5000),
                                anInt("timeToGoToStandby",15000),
                                anInt("timeToGoToStandback",15000),                     
                            ))
                        
                {//begin description of autochanger's children

                    // ------------------------
                    //BEGIN  SFT TRUCKS MOTOR (AUTOCHANGER)
                    sftTrucksMotor(CanOpenTruckMotor,
                            argMap( a("name","sftTrucksMotor"),
                                    anInt("tickMillis", 5000),
                                    aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) which controls this motor."]),
                                    anInt("outputNumeroToStandby",2,[description:"The numero of the output of DIO where we send a current for the trucks to go to standby",
                                            constraints:0..7]),
                                    anInt("outputNumeroToStandback",1,[description:"The numero of the output of DIO where we send a current for the trucks to go to standback",
                                            constraints:0..7]) )) //OK

                    //END  SFT TRUCKS MOTOR
                    // ------------------------



                    // ------------------------
                    //BEGIN  latchMinux    (AUTOCHANGER)
                    "latchXminus" (SftFilterLatchModule,
                        argMap( a ("name", "latchXminus") ,
                                anInt("tickMillis", 5000),
                                anInt("timeoutForClosing",6000,[description:"timeout in milliseconds : if closing the latches lasts more than this amount of time, then the subsystem goes in ERROR."]),
                                anInt("timeoutForOpening",6000,[description:"timeout in milliseconds : if opening the latches lasts more than this amount of time, then the subsystem goes in ERROR."]),
                                //aBool("locked")
                                aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                                aRef("lockSensor","lockSensorLatchXminus"),
                                aRef("unlockSensor","unlockSensorLatchXminus"),
                                aRef("filterPresenceSensor","filterPresenceSensorLatchXminus"),
                                aRef("latchActuator","latchActuatorXminus")))
                        
        
                        {
                            "lockSensorLatchXminus" ( CanOpenNumericSensor ,
                                argMap(a ("name", "lockSensorLatchXminus") ,
                                    aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 1, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))
                                    
                            "unlockSensorLatchXminus" ( CanOpenNumericSensor ,
                                argMap( a("name", "unlockSensorLatchXminus"),
                                    aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 1, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                            "filterPresenceSensorLatchXminus" ( CanOpenNumericSensor ,
                                argMap( a("name", "filterPresenceSensorLatchXminus") ,
                                    aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 0, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 1, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))


                            "latchActuatorXminus" (CanOpenLatchActuatorModule,
                                    argMap(a("name", "latchActuatorXminus") ,
                                            anInt("tickMillis", 1000),   
                                            aDbl("currentLimitInVolt", 0.150,[description:"decimal value of the current limit (in Ampere) to determine the couple"]),
                                            aDbl("speedVoltageInVolt", 4,[description:"decimal value of the voltage (in Volt) to send to the actuator to determine the speed",constraints:-10..10]),
                                            anInt("speedVoltageMaxValue", 10, [description:"maximal decimal value of the speed voltage (used for the GUI)"]),
                                            anInt("speedVoltageMinValue", -10,[description:"minimal decimal value of the speed voltage (used for the GUI)"]),
                                            aString("dacName",dacName,[static:true,description:"The name of the DAC where this actuator is plugged."]),     
                                            anInt("numOfAnalogOutputForSpeedVoltage", 1),
                                            anInt("numOfAnalogOutputForCurrentLimit", 2),
                                        ))
                        }
                        // ------------------------
                        //END  latchXminus    (AUTOCHANGER)

                        // ------------------------
                        //BEGIN  latchXplus    (AUTOCHANGER)
                        "latchXplus" (SftFilterLatchModule,
                                argMap( a ("name", "latchXplus") ,
                                        anInt("tickMillis", 5000),
                                        anInt("timeoutForClosing",10000,[description:"timeout in milliseconds : if closing the latches last more than this amount of time, then the subsystem goes in ERROR."]),
                                        anInt("timeoutForOpening",10000,[description:"timeout in milliseconds : if opening the latches last more than this amount of time, then the subsystem goes in ERROR."]),
                                        aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                                        aRef("lockSensor","lockSensorLatchXplus"),
                                        aRef("unlockSensor","unlockSensorLatchXplus"),
                                        aRef("filterPresenceSensor","filterPresenceSensorLatchXplus"),
                                        aRef("latchActuator","latchActuatorXplus")))

                                {
                                    "lockSensorLatchXplus" ( CanOpenNumericSensor ,
                                        argMap(a ("name", "lockSensorLatchXplus") ,
                                            aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 5, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte where the value of this sensor is stored."]),
                                        ))


                                    "unlockSensorLatchXplus" ( CanOpenNumericSensor ,
                                            argMap( a("name", "unlockSensorLatchXplus"),
                                                aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                                anInt("inputNumero", 6, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                                anInt("byteNumero", 1, [description:"The numero of the byte where the value of this sensor is stored."]),
                                            ))


                                    "filterPresenceSensorLatchXplus" ( CanOpenNumericSensor ,
                                            argMap( a("name", "filterPresenceSensorLatchXplus") ,
                                                aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                                anInt("inputNumero", 4, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                                anInt("byteNumero", 1, [description:"The numero of the byte where the value of this sensor is stored."]),
                                            ))


                                    "latchActuatorXplus" (CanOpenLatchActuatorModule,
                                            argMap(a("name", "latchActuatorXplus") ,
                                                anInt("tickMillis", 3000),
                                                aDbl("currentLimitInVolt", 0.150,[description:"decimal value of the current limit (in Ampere) to determine the couple"]),
                                                aDbl("speedVoltageInVolt", 4,[description:"decimal value of the voltage (in Volt) to send to the actuator to determine the speed",constraints:-10..10]),
                                                anInt("speedVoltageMaxValue", 10,[description:"maximal decimal value of the voltage (used for the GUI)"]),
                                                anInt("speedVoltageMinValue", -10,[description:"minimal decimal value of the voltage (used for the GUI)"]),
                                                aString("dacName",dacName,[static:true,description:"The name of the DAC where this actuator is plugged."]),
                                                anInt("numOfAnalogOutputForSpeedVoltage", 3),
                                                anInt("numOfAnalogOutputForCurrentLimit", 4),
                                            ))

                                }
                                //END  LATCH   (AUTOCHANGER)
                                // ------------------------

                        // ------------------------
                        //BEGIN  TRUCK   (AUTOCHANGER)
                        "truckXminus" (  TruckModule ,
                            argMap(  a("name", "truckXminus") ,
                                        anInt("tickMillis", 3000),
                                        aRef("railSensorStandback", "railSensorStandbackXminus"),
                                        aRef("railSensorStandby", "railSensorStandbyXminus")))
                           {
                               
                               "railSensorStandbackXminus" (  CanOpenNumericSensor ,
                                       argMap( a("name", "railSensorStandbackXminus"),
                                           aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                           anInt("inputNumero", 4, [description:"The numero of the input of the DIO where this sensor is plugged."]),
                                           anInt("byteNumero", 1, [description:"The numero of the byte where the value of this sensor is stored."]),
                                       ))
                                   
                                "railSensorStandbyXminus" (  CanOpenNumericSensor ,
                                        argMap( a("name", "railSensorStandbyXminus"),
                                           aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                           anInt("inputNumero", 5 , [description:"The numero of the input of the DIO where this sensor is plugged."]),
                                           anInt("byteNumero", 1, [description:"The numero of the byte where the value of this sensor is stored."]),
                                       ))
                           }

                        "truckXplus" (  TruckModule ,
                            argMap(  a("name", "truckXplus") ,
                                    anInt("tickMillis", 3000),                                   
                                    aRef("railSensorStandback", "railSensorStandbackXplus"),
                                    aRef("railSensorStandby", "railSensorStandbyXplus")))
                            {
                                
                               
                                "railSensorStandbackXplus" (  CanOpenNumericSensor ,
                                        argMap( a("name", "railSensorStandbackXplus"),
                                            aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                            anInt("inputNumero", 6, [description:"The numero of the input of the DIO where this sensor is plugged."]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte where the value of this sensor is stored."]),
                                        ))
                                    
            
                                "railSensorStandbyXplus" (  CanOpenNumericSensor ,
                                        argMap( a("name", "railSensorStandbyXplus"),
                                            aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                            anInt("inputNumero", 7, [description:"The numero of the input of the DIO where this sensor is plugged."]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte where the value of this sensor is stored."]),
                                        ))


                            }//END  TRUCK   (AUTOCHANGER)
                            // ------------------------
                        

                }//END AUTO CHANGER
                // ------------------------    
                       

                
                
            
            }//end description of Main submodules

                


