package loader

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.startup.CCSBuilder ;


import static org.lsst.gruth.jutils.MapArgs.*

def plutoGatewayName = "plutoGateway" // to monitor the loader sensors
def loaderTcpProxyName = "loaderTcpProxy" // the name of the tcpProxy

CCSBuilder builder = ["testbenchLPSC"]

builder.
        "main" ( org.lsst.ccs.subsystems.fcs.testbench.LoaderTestBenchMainModule,
                argMap(a("name", "main"),
                        anInt("tickMillis", 3000),
                        ref("bridge"),
                        ref("autochangerHoldingFilterSensor"),
                        ))
                 


            //begin description of Main submodules
            {       

                autochangerHoldingFilterSensor(CanOpenNumericSensor ,
                    argMap(a ("name", "autochangerHoldingFilterSensor") ,
                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                    anInt("inputNumero", 1, [description:"The numero of the input on the device DIO where this sensor is plugged.", constraints:0..7]),
                    anInt("byteNumero", 4, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                ))


                // Bridge
                bridge (BridgeForLPSCTestBench,
                        argMap(aString("name", "bridge"),
                            anInt("tickMillis", 1000),
                            ref("tcpProxy"),
                            ref("hooksController"),
                            ref("carrierController"),
                            ref("plutoGateway")))

                {//begin description of bridge's children          

                        // tcp Proxy
                        tcpProxy (CanOpenProxy,
                                argMap(aString("name", "tcpProxy"),
                                //argMap(aString("name", tcpProxyName), //TODO
                                    anInt("tickMillis", 1000),
                                    anInt("portNumber", 50000,[static:true, constraints:1024..99000]),
                                    aString("myClientName","TestBench",[static:true]),
                                    anInt("hardwareBootTimeout",1000, [description:"A timeout for the harwdare booting process",constraints:1000..10000])))
                 
                       // can open devices
                       
                        hooksController (CanOpenEPOS24,
                                argMap( aString("name", "hooksController"),
                                anInt("tickMillis",3000),
                                aString("nodeID","1b", [static:true, description:"can open node ID in HEXADECIMAL for EPOS24/50 for loader hook motor"]),
                                aString("serialNB","79007141", [static:true, description:"EPOS24/50 serial number for the hook motor controller"]),
                                aMap("paramsForCurrent", 
                                    [ContinuousCurrentLimit:3440,
                                    OutputCurrentLimit:6880,
                                    MaxSpeedInCurrentMode:2000,
                                    MotorType:10,PolePairNumber:1,
                                    PositionSensorType:1]),
                                aMap("paramsForProfilePosition", 
                                    [MinPositionLimit:-300,
                                    MaxPositionLimit:550000,
                                    MotionProfileType:0]),
                                aMap("paramsForHoming",[HomeOffset:0]),
                                )) 

                        
                        carrierController (CanOpenEPOS70,
                                argMap( aString("name", "carrierController"),
                                anInt("tickMillis",3000),
                                aString("nodeID","1a", [static:true, description:"can open node ID in HEXADECIMAL for EPOS70/10 for loader carrier motor"]),
                                aString("serialNB","80003184", [static:true, description:"EPOS24 serial number for the carrier motor controller"]),
                                aMap("paramsForCurrent", 
                                    [ContinuousCurrentLimit:7290,
                                    OutputCurrentLimit:14580,
                                    MaxSpeedInCurrentMode:9840,
                                    MotorType:10,
                                    PositionSensorType:4,
                                    ThermalTimeConstantWinding:187,
                                    PolePairNumber:1]),
                                aMap("paramsForProfilePosition", 
                                    [MinPositionLimit:-250,
                                    MaxPositionLimit:1037700,
                                    MotionProfileType:0,
                                    MaxFollowingError:6000,
                                    MaxProfileVelocity:227, 
                                    ProfileVelocity:120,
                                    ProfileAcceleration:100,
                                    ProfileDeceleration:100,
                                    QuickStopDeceleration:10000
                                    ]),
                                aMap("paramsForHoming",
                                    [HomeOffset:0,
                                    HomingAcceleration:1000,
                                    CurrentThresholdHomingMode:500]),
                                ))

                        
                        plutoGateway (CanOpenPlutoGateway, 
                                argMap(aString("name", plutoGatewayName),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","1"),
                                    aString("serialNB","22d6"),
                                    aString("station_addr","00"),
                                ))


                            
                }//end description of bridge's childrens
                
                //begin description of loader
                loader (LoaderModule,
                        argMap(aString("name", "loader"),
                        anInt("tickMillis", 1000),
                        ref("carrier"),
                        ref("clamp"),
                        aString("plutoGWName",plutoGatewayName),
                        ref("filterPresenceSensor0"),
                        ref("filterPresenceSensor1"),
                        ref("loaderOnCameraSensor0"),
                        ref("loaderOnCameraSensor1"),
                        ))

                        {//begin description of loader's children



                            carrier(LoaderCarrierModule,
                                argMap(aString("name", "carrier"),
                                        anInt("tickMillis", 1000),
                                        anInt("storagePosition",0,[description:"Storage position in micron"]),
                                        anInt("handoffPosition",1037000,[description:"Handoff position in micron"]),
                                        ref("handoffPositionSensor0"),
                                        ref("handoffPositionSensor1"),
                                        ref("storagePositionSensor0"),
                                        ref("storagePositionSensor1"),
                                        anInt("timeoutForGoingToHandOff",120000,
                                            [description:"timeout in milliseconds."]),
                                        anInt("timeoutForGoingToStorage",120000,
                                            [description:"timeout in milliseconds."]),
                                        anInt("maxCurrent",1000,
                                            [description:"For the GUI : Maximum current to be sent to the controller (in mA)."]),
                                        anInt("maxSpeed",227,
                                            [description:"For the GUI : Maximum speed (in rpm/mn)."]),
                                ))
                                {//begin description of loader carrier's children  
                                        "handoffPositionSensor0" ( CanOpenNumericSensor ,
                                            argMap(a ("name", "handoffPositionSensor0") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 6, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                                            ))
                                        "handoffPositionSensor1" ( CanOpenNumericSensor ,
                                            argMap(a ("name", "handoffPositionSensor1") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 7, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                                            ))
                                        "storagePositionSensor0" ( CanOpenNumericSensor ,
                                            argMap(a ("name", "storagePositionSensor0") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 4, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                                            ))
                                        "storagePositionSensor1" ( CanOpenNumericSensor ,
                                            argMap(a ("name", "storagePositionSensor1") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 5, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                                            ))                                     
                                }//end description of loader carrier's children

                            clamp(LoaderClampModule,
                                argMap(aString("name", "clamp"),
                                        anInt("tickMillis", 1000),
                                        ref("hook1"),
                                        ref("hook2"),
                                        ref("hook3"),
                                        ref("hook4"),
                                        anInt("timeoutForClosingHooks",60000,[description:"timeout in milliseconds : if closing the hook last more than this amount of time, then the subsystem goes in ERROR."]),
                                        anInt("timeoutForClampingHooks",60000,[description:"timeout in milliseconds : if closing strongly the hook last more than this amount of time, then the subsystem goes in ERROR."]),
                                        anInt("timeoutForOpeningHooks",60000,[description:"timeout in milliseconds : if opening the hook last more than this amount of time, then the subsystem goes in ERROR."]),
                                        anInt("timeoutForGoingToHomePosition",60000,[description:"timeout in milliseconds : if the action of hoing to home position last more than this amount of time, then the subsystem goes in ERROR."]),
                                        anInt("targetPositionToOpen",5000,[description:"target encoder absolut value in qc to open"]),
                                        anInt("targetPositionToClose",492000,[description:"target encoder absolut value in qc when hooks are LOCKED"]),
                                        anInt("targetPositionToClamp",515000,[description:"target encoder absolut value in qc when hooks are CLAMPED"]),
                                        anInt("currentToClamp",280,[description:"current to close in initialisation phase, in mA"]),
                                        anInt("currentToGoHome",-200,[description:"current to go to home position in initialisation phase, in mA"]),                                       
                                        aMap("paramsForCurrentToClamp", 
                                            [ContinuousCurrentLimit:410,
                                            OutputCurrentLimit:820,
                                            MaxSpeedInCurrentMode:500],
                                            [description:"list of parameters for CURRENT mode to clamp the clamp."]),
                                        aMap("paramsForCurrentToGoHome", 
                                            [ContinuousCurrentLimit:500,
                                            OutputCurrentLimit:1000,
                                            MaxSpeedInCurrentMode:500],
                                            [description:"list of parameters for CURRENT mode to open the clamp in the initialisation phase."]),  
                                        anInt("minPosition",0,[description:"min position value used by the GUI"]),
                                        anInt("maxPosition",515000,[description:"max position value used by the GUI"]),
                                        anInt("minCurrent",-300,[description:"min current value used by the GUI"]),
                                        anInt("maxCurrent",400,[description:"max current value used by the GUI"]),

                                ))
                                {//begin description of loader clamp's children
                                    hook1(LoaderHookModule,
                                        argMap(aString("name", "hook1"),
                                        ref("lockSensor1"),
                                        ref("unlockSensor1"),
                                    ))
                                    {//begin description of hook1's children
                                        "lockSensor1" ( CanOpenNumericSensor , //closeHookSensor0
                                            argMap(a ("name", "lockSensor1") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 4, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 0, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])))
                                        "unlockSensor1" ( CanOpenNumericSensor , //openHookSensor0
                                            argMap(a ("name", "unlockSensor1") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 0, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 0, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])))
                                    }//end description of hook1's children

                                    hook2(LoaderHookModule,
                                        argMap(aString("name", "hook2"),
                                        ref("lockSensor2"),
                                        ref("unlockSensor2"),
                                    ))
                                    {//begin description of hook2's children
                                        "lockSensor2" ( CanOpenNumericSensor , //closeHookSensor1
                                            argMap(a ("name", "lockSensor2") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 5, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 0, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])))
                                        "unlockSensor2" ( CanOpenNumericSensor , //openHookSensor1
                                            argMap(a ("name", "unlockSensor2") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 0, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])))
                                    }//end description of hook2's children

                                    hook3(LoaderHookModule,
                                        argMap(aString("name", "hook3"), 
                                        ref("lockSensor3"),
                                        ref("unlockSensor3"),
                                    ))
                                    {//begin description of hook3's children
                                        "lockSensor3" ( CanOpenNumericSensor , //closeHookSensor2
                                            argMap(a ("name", "lockSensor3") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 6, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 0, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])))
                                        "unlockSensor3" ( CanOpenNumericSensor , //openHookSensor2
                                            argMap(a ("name", "unlockSensor3") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 0, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])))
                                    }//end description of hook3's children

                                    hook4(LoaderHookModule,
                                        argMap(aString("name", "hook4"),
                                        ref("lockSensor4"),
                                        ref("unlockSensor4"),
                                    ))
                                    {//begin description of hook4's children
                                        "lockSensor4" ( CanOpenNumericSensor , //closeHookSensor3
                                            argMap(a ("name", "lockSensor4") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 7, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 0, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])))
                                        "unlockSensor4" ( CanOpenNumericSensor , //openHookSensor3
                                            argMap(a ("name", "unlockSensor4") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 0, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])))
                                    }//end description of hook4's children
                                }//end description of loader clamp's children


                        filterPresenceSensor0(CanOpenNumericSensor ,
                                            argMap(a ("name", "filterPresenceSensor0") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 0, [description:"The numero of the input on the device DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                                        ))

                        filterPresenceSensor1(CanOpenNumericSensor ,
                                            argMap(a ("name", "filterPresenceSensor1") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 1, [description:"The numero of the input on the device DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                                        ))                                     



                       loaderOnCameraSensor0(CanOpenNumericSensor ,
                                            argMap(a ("name", "loaderOnCameraSensor0") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                                        ))

                       loaderOnCameraSensor1(CanOpenNumericSensor ,
                                            argMap(a ("name", "loaderOnCameraSensor1") ,
                                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                                        ))

                        }//end description of loader's children

            }//end description of Main submodules

                


