/*******************************************************************************/
/*        Description file for the carousel in standalone mode                 */
/*                                                                             */
/*******************************************************************************/


/*******************************************************************************/
/* The file carousel__simulation.groovy is generated with the script :         */
/* generateCarouselDescription.sh                                              */
/* from the files carousel__simulation_head and socket__simulation__model      */
/* DO NOT MODIFY carousel__simulation.groovy : the changes will be lost after  */
/* the next generation.                                                        */
/*******************************************************************************/

package carouselSimulation

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.singlefiltertest.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.framework.Configurable
import org.lsst.ccs.startup.CCSBuilder ;


import static org.lsst.gruth.jutils.MapArgs.*
import static org.lsst.gruth.nodes.NodeUtils.loopList

//for each socket we define a position on the carousel : positionOnCarouselSocket
//and the position of the socket when it is at STANDBY position.
def positionOnCarouselSocket1 = 0
def positionOnCarouselSocket2 = 72
def positionOnCarouselSocket3 = 144
def positionOnCarouselSocket4 = 216
def positionOnCarouselSocket5 = 288
def standbyPositionSocket1 = 0
def standbyPositionSocket2 = 288
def standbyPositionSocket3 = 216
def standbyPositionSocket4 = 144
def standbyPositionSocket5 = 72


//Carousel Can Open Devices (CAN-CBX-AI814)
def adcName = "ai814"

//Carousel clamps controllers name
def clampXminusControllerName = "clampXminusController" //controller to unlock clamp on the side Xminus
def clampXplusControllerName =  "clampXplusController" //controller to unlock clamp on the side Xplus


CCSBuilder builder = ["carousel-standalone"]

builder.
        "Main Module" ( CarouselMainModule,
                argMap(a("name", "main"),
                        anInt("tickMillis", 3000),
                        ref("bridge"),
                        ref("filterManager"),
                        ))
                 


            //begin description of Main submodules
            {       
                //-------------------------
                // BEGIN Bridge description
                // Bridge
                bridge (SimuBridgeForCarousel,
                        argMap(aString("name", "bridge"),
                            anInt("tickMillis", 1000),
                            ref("tcpProxy"),
                            ref("clampXminusController"),
                            ref("clampXplusController"),
                            ref("carouselController"),
                            ref("clampsSensorsReaderDevice"),                            
                            ref("ai420_1"),
                            ref("ai420_2"),
                            ))
                        {//begin description of bridge's children 
                            
                            // tcp Proxy
                            tcpProxy (SimuCanOpenProxy,
                                argMap(aString("name", "tcpProxy"),
                                    anInt("tickMillis", 1000),
                                    anInt("portNumber", 54321,[static:true, 
                                            constraints:1024..99000]),
                                    aString("myClientName","TestBench",[static:true]),
                                    anInt("hardwareBootTimeout",2500, 
                                            [description:"A timeout for the harwdare booting process",
                                            constraints:1000..10000])))
                            
                            clampXminusController (SimuCarouselClampController,
                                    argMap( a("name", clampXminusControllerName),
                                    anInt("tickMillis",3000),
                                    aString("nodeID","1a"),
                                    aString("serialNB","79003317"),
                                    aMap("paramsForCurrent", [MotorType:11, PositionSensorType:3,PolePairNumber:8,
                                            ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                                            ThermalTimeConstantWinding:160,
                                            MaxSpeedInCurrentMode:25]),
                                    aMap("paramsForProfilePosition", [MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))  

                            clampXplusController (SimuCarouselClampController,
                                    argMap( a("name", clampXplusControllerName),
                                    anInt("tickMillis",3000),
                                    aString("nodeID","1b"),
                                    aString("serialNB","79003313"),
                                    aMap("paramsForCurrent", [MotorType:11, PositionSensorType:3,PolePairNumber:8,
                                            ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                                            ThermalTimeConstantWinding:160,
                                            MaxSpeedInCurrentMode:25]),
                                    aMap("paramsForProfilePosition", [MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))
                                
                            carouselController (SimuCarouselController,
                                argMap( aString("name", "carouselController"),
                                anInt("tickMillis",3000),
                                aString("nodeID","1c", [static:true, 
                                        description:"can open node ID in HEXADECIMAL for EPOS24/50 for rotation carousel motor"]),
                                aString("serialNB","7900xxxxx", [static:true, 
                                        description:"EPOS24/50 serial number for the rotation carousel motor controller"]),
                                aMap("paramsForCurrent", 
                                    [ContinuousCurrentLimit:3440,
                                    OutputCurrentLimit:6880,
                                    MaxSpeedInCurrentMode:2000,
                                    MotorType:10,PolePairNumber:1,
                                    PositionSensorType:1]),
                                aMap("paramsForProfilePosition", 
                                    [MinPositionLimit:-300,
                                    MaxPositionLimit:550000,
                                    MotionProfileType:0]),
                                aMap("paramsForHoming",[HomeOffset:0]),
                                ))
                            
                            // can open devices to read clamps sensors
                            clampsSensorsReaderDevice (SimuADCDevice,
                                    argMap(aString("name", "clampsSensorsReaderDevice"),
                                        anInt("tickMillis", 3000),
                                        aString("nodeID","1d"),
                                        aString("serialNB","44110125008180")))
                            
                            // can open devices to read brakes sensors and temperatures
                            ai420_1 (SimuADCDevice,
                                    argMap(aString("name", "ai420_1"),
                                        anInt("tickMillis", 3000),
                                        aString("nodeID","1e"),
                                        aString("serialNB","c7yyyyyy")))

                            // can open devices to read brakes sensors and temperatures
                            ai420_2 (SimuADCDevice, 
                                    argMap(aString("name", "ai420_2"),
                                        anInt("tickMillis", 1000),
                                        aString("nodeID","1f"),
                                        aString("serialNB","c7zzzzzz")))    
                            
                        } //end of carousel's bridge hardware


                //-------------------------
                // BEGIN Filter description
                
                filterManager(FilterManager,
                    argMap( a("name", "filterManager"),
                        ref ("filterU"),
                        ref ("filterG"),
                        ref ("filterR"),
                        ref ("filterI"),
                        ref ("filterZ"),
                        ref ("filterY"),
                        ref ("dummyFilter")
                    ))
                {//begin description of filter manager's children

                    "filterU" (Filter, 
                            argMap(aString("name", "filterU"),
                            anInt("filterID", 1),
                            aDbl("weight", "45.320")))
                    "filterG" (Filter,
                            argMap(aString("name", "filterG"),
                            anInt("filterID", 2),
                            aDbl("weight", "53.215")))
                    "filterR" (Filter,
                            argMap(aString("name", "filterR"),
                            anInt("filterID", 3),
                            aDbl("weight", "62")))
                    "filterI" (Filter,
                            argMap(aString("name", "filterI"),
                            anInt("filterID", 4),
                            aDbl("weight", "47.1")))
                    "filterZ" (Filter,
                            argMap(aString("name", "filterZ"),
                            anInt("filterID", 5),
                            aDbl("weight", "45")))
                    "filterY" (Filter,
                            argMap(aString("name", "filterY"),
                            anInt("filterID", 6),
                            aDbl("weight", "44")))
                    "dummyFilter" (Filter,
                            argMap(aString("name", "dummyFilter"),
                            anInt("filterID", 10),
                            aDbl("weight", "44.5")))
                    
                }//begin description of filter manager's children

    // END Filter description
    // ------------------------
    
    //----------------------------
    // BEGIN Carousel description
    carousel (CarouselModule,
        argMap( a("name", "carousel"),
            anInt("tickMillis",5000),
            ref ("socket1"),
            ref ("socket2"),
            ref ("socket3"),
            ref ("socket4"),
            ref ("socket5"),
        ))
    
    {//begin description of carousel's children
        
        
        /**********************************************************************/
        /*DO NOT MODIFY socket description in file carousel__simulation.groovy*/
        /*MODIFY socket description in socket__simulation_model.groovy        */
        /**********************************************************************/
        /*SOCKET1*/
        "socket1" ( SimuCarouselSocket,
                argMap(a("name", "socket1"),
                    anInt("tickMillis",5000),
                    aRef("clampXminus", "clampXminus1"),
                    aRef("clampXplus", "clampXplus1"),
                    aDbl("positionOnCarousel", positionOnCarouselSocket1),
                    aDbl("standbyPosition", standbyPositionSocket1)
                ))
            
            {   
                //-------------------------
                // BEGIN clampXminus description
                "clampXminus1" (SimuCarouselClampXminus,
                    argMap( a("name", "clampXminus1"),
                        anInt("tickMillis",5000),
                        aRef("filterPresenceSensor","filterPresenceXminus1"),
                        aRef("lockSensor", "lockSensorXminus1"),
                        aRef("thermometer", "thermometerXminus1"),
                        
                        anInt("filterPresenceValueA", 1500, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                        anInt("filterPresenceValueB", 24400, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                        anInt("filterPresenceValueC", 32000 , [description:"above valueC, there is NOFILTER",constraints:0..32768]),
                        anInt("filterPresenceOffset", 0 , [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),
                        
                        anInt("lockSensorValueA", 5000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                        anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                        anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                        anInt("lockSensorOffset", 0 , [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),
                        
                        anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                        anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),
                        
                        anInt("currentToUnlock", 1500),
                        anInt("currentToMaintainUnlocked", 200),
                    ))
                {
                        "filterPresenceXminus1" (SimuClampFilterPresenceSensor,
                        argMap( a("name", "filterPresenceXminus1"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                        "lockSensorXminus1" (SimuClampLockSensor,
                        argMap( a("name", "lockSensorXminus1"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),                                                  
                        ))
                    
                        "thermometerXminus1" (SimuThermometer,
                        argMap( a("name", "thermometerXminus1"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                   
                    
                }
                //-------------------------
                // END clampXminus description
                
                //-------------------------
                // BEGIN clampXplus description
                "clampXplus1" (SimuCarouselClamp,
                    argMap( a("name", "clampXplus1"),
                        anInt("tickMillis",5000),
                        aRef("filterPresenceSensor","filterPresenceXplus1"),
                        aRef("lockSensor", "lockSensorXplus1"),
                        aRef("thermometer", "thermometerXplus1"),
                        
                        anInt("filterPresenceValueA", 1355, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                        anInt("filterPresenceValueB", 10500, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                        anInt("filterPresenceValueC", 32000, [description:"above valueC, there is NOFILTER",constraints:0..32768] ),
                        anInt("filterPresenceOffset", 0, [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),
                        
                        anInt("lockSensorValueA", 6000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                        anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                        anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                        anInt("lockSensorOffset", 0, [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),
                        
                        anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                        anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),
                        
                        anInt("currentToUnlock", 1500),
                        anInt("currentToMaintainUnlocked", 200),
                    ))
                
                {
                        "filterPresenceXplus1" (SimuClampFilterPresenceSensor,
                        argMap( a("name", "filterPresenceXplus1"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                        "lockSensorXplus1" (SimuClampLockSensor,
                        argMap( a("name", "lockSensorXplus1"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                        "thermometerXplus1" (SimuThermometer,
                        argMap( a("name", "thermometerXplus1"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                }
                //-------------------------
                // END clampXplus description
                
            } // END carouselSocket /*SOCKET1*/ description
        /**********************************************************************/
        /*DO NOT MODIFY socket description in file carousel__simulation.groovy*/
        /*MODIFY socket description in socket__simulation_model.groovy        */
        /**********************************************************************/
        /*SOCKET2*/
        "socket2" ( SimuCarouselSocket,
                argMap(a("name", "socket2"),
                    anInt("tickMillis",5000),
                    aRef("clampXminus", "clampXminus2"),
                    aRef("clampXplus", "clampXplus2"),
                    aDbl("positionOnCarousel", positionOnCarouselSocket2),
                    aDbl("standbyPosition", standbyPositionSocket2)
                ))
            
            {   
                //-------------------------
                // BEGIN clampXminus description
                "clampXminus2" (SimuCarouselClampXminus,
                    argMap( a("name", "clampXminus2"),
                        anInt("tickMillis",5000),
                        aRef("filterPresenceSensor","filterPresenceXminus2"),
                        aRef("lockSensor", "lockSensorXminus2"),
                        aRef("thermometer", "thermometerXminus2"),
                        
                        anInt("filterPresenceValueA", 1500, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                        anInt("filterPresenceValueB", 24400, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                        anInt("filterPresenceValueC", 32000 , [description:"above valueC, there is NOFILTER",constraints:0..32768]),
                        anInt("filterPresenceOffset", 0 , [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),
                        
                        anInt("lockSensorValueA", 5000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                        anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                        anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                        anInt("lockSensorOffset", 0 , [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),
                        
                        anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                        anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),
                        
                        anInt("currentToUnlock", 1500),
                        anInt("currentToMaintainUnlocked", 200),
                    ))
                {
                        "filterPresenceXminus2" (SimuClampFilterPresenceSensor,
                        argMap( a("name", "filterPresenceXminus2"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                        "lockSensorXminus2" (SimuClampLockSensor,
                        argMap( a("name", "lockSensorXminus2"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),                                                  
                        ))
                    
                        "thermometerXminus2" (SimuThermometer,
                        argMap( a("name", "thermometerXminus2"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                   
                    
                }
                //-------------------------
                // END clampXminus description
                
                //-------------------------
                // BEGIN clampXplus description
                "clampXplus2" (SimuCarouselClamp,
                    argMap( a("name", "clampXplus2"),
                        anInt("tickMillis",5000),
                        aRef("filterPresenceSensor","filterPresenceXplus2"),
                        aRef("lockSensor", "lockSensorXplus2"),
                        aRef("thermometer", "thermometerXplus2"),
                        
                        anInt("filterPresenceValueA", 1355, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                        anInt("filterPresenceValueB", 10500, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                        anInt("filterPresenceValueC", 32000, [description:"above valueC, there is NOFILTER",constraints:0..32768] ),
                        anInt("filterPresenceOffset", 0, [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),
                        
                        anInt("lockSensorValueA", 6000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                        anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                        anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                        anInt("lockSensorOffset", 0, [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),
                        
                        anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                        anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),
                        
                        anInt("currentToUnlock", 1500),
                        anInt("currentToMaintainUnlocked", 200),
                    ))
                
                {
                        "filterPresenceXplus2" (SimuClampFilterPresenceSensor,
                        argMap( a("name", "filterPresenceXplus2"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                        "lockSensorXplus2" (SimuClampLockSensor,
                        argMap( a("name", "lockSensorXplus2"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                        "thermometerXplus2" (SimuThermometer,
                        argMap( a("name", "thermometerXplus2"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                }
                //-------------------------
                // END clampXplus description
                
            } // END carouselSocket /*SOCKET2*/ description
        /**********************************************************************/
        /*DO NOT MODIFY socket description in file carousel__simulation.groovy*/
        /*MODIFY socket description in socket__simulation_model.groovy        */
        /**********************************************************************/
        /*SOCKET3*/
        "socket3" ( SimuCarouselSocket,
                argMap(a("name", "socket3"),
                    anInt("tickMillis",5000),
                    aRef("clampXminus", "clampXminus3"),
                    aRef("clampXplus", "clampXplus3"),
                    aDbl("positionOnCarousel", positionOnCarouselSocket3),
                    aDbl("standbyPosition", standbyPositionSocket3)
                ))
            
            {   
                //-------------------------
                // BEGIN clampXminus description
                "clampXminus3" (SimuCarouselClampXminus,
                    argMap( a("name", "clampXminus3"),
                        anInt("tickMillis",5000),
                        aRef("filterPresenceSensor","filterPresenceXminus3"),
                        aRef("lockSensor", "lockSensorXminus3"),
                        aRef("thermometer", "thermometerXminus3"),
                        
                        anInt("filterPresenceValueA", 1500, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                        anInt("filterPresenceValueB", 24400, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                        anInt("filterPresenceValueC", 32000 , [description:"above valueC, there is NOFILTER",constraints:0..32768]),
                        anInt("filterPresenceOffset", 0 , [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),
                        
                        anInt("lockSensorValueA", 5000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                        anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                        anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                        anInt("lockSensorOffset", 0 , [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),
                        
                        anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                        anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),
                        
                        anInt("currentToUnlock", 1500),
                        anInt("currentToMaintainUnlocked", 200),
                    ))
                {
                        "filterPresenceXminus3" (SimuClampFilterPresenceSensor,
                        argMap( a("name", "filterPresenceXminus3"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                        "lockSensorXminus3" (SimuClampLockSensor,
                        argMap( a("name", "lockSensorXminus3"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),                                                  
                        ))
                    
                        "thermometerXminus3" (SimuThermometer,
                        argMap( a("name", "thermometerXminus3"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                   
                    
                }
                //-------------------------
                // END clampXminus description
                
                //-------------------------
                // BEGIN clampXplus description
                "clampXplus3" (SimuCarouselClamp,
                    argMap( a("name", "clampXplus3"),
                        anInt("tickMillis",5000),
                        aRef("filterPresenceSensor","filterPresenceXplus3"),
                        aRef("lockSensor", "lockSensorXplus3"),
                        aRef("thermometer", "thermometerXplus3"),
                        
                        anInt("filterPresenceValueA", 1355, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                        anInt("filterPresenceValueB", 10500, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                        anInt("filterPresenceValueC", 32000, [description:"above valueC, there is NOFILTER",constraints:0..32768] ),
                        anInt("filterPresenceOffset", 0, [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),
                        
                        anInt("lockSensorValueA", 6000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                        anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                        anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                        anInt("lockSensorOffset", 0, [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),
                        
                        anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                        anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),
                        
                        anInt("currentToUnlock", 1500),
                        anInt("currentToMaintainUnlocked", 200),
                    ))
                
                {
                        "filterPresenceXplus3" (SimuClampFilterPresenceSensor,
                        argMap( a("name", "filterPresenceXplus3"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                        "lockSensorXplus3" (SimuClampLockSensor,
                        argMap( a("name", "lockSensorXplus3"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                        "thermometerXplus3" (SimuThermometer,
                        argMap( a("name", "thermometerXplus3"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                }
                //-------------------------
                // END clampXplus description
                
            } // END carouselSocket /*SOCKET3*/ description
        /**********************************************************************/
        /*DO NOT MODIFY socket description in file carousel__simulation.groovy*/
        /*MODIFY socket description in socket__simulation_model.groovy        */
        /**********************************************************************/
        /*SOCKET4*/
        "socket4" ( SimuCarouselSocket,
                argMap(a("name", "socket4"),
                    anInt("tickMillis",5000),
                    aRef("clampXminus", "clampXminus4"),
                    aRef("clampXplus", "clampXplus4"),
                    aDbl("positionOnCarousel", positionOnCarouselSocket4),
                    aDbl("standbyPosition", standbyPositionSocket4)
                ))
            
            {   
                //-------------------------
                // BEGIN clampXminus description
                "clampXminus4" (SimuCarouselClampXminus,
                    argMap( a("name", "clampXminus4"),
                        anInt("tickMillis",5000),
                        aRef("filterPresenceSensor","filterPresenceXminus4"),
                        aRef("lockSensor", "lockSensorXminus4"),
                        aRef("thermometer", "thermometerXminus4"),
                        
                        anInt("filterPresenceValueA", 1500, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                        anInt("filterPresenceValueB", 24400, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                        anInt("filterPresenceValueC", 32000 , [description:"above valueC, there is NOFILTER",constraints:0..32768]),
                        anInt("filterPresenceOffset", 0 , [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),
                        
                        anInt("lockSensorValueA", 5000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                        anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                        anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                        anInt("lockSensorOffset", 0 , [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),
                        
                        anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                        anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),
                        
                        anInt("currentToUnlock", 1500),
                        anInt("currentToMaintainUnlocked", 200),
                    ))
                {
                        "filterPresenceXminus4" (SimuClampFilterPresenceSensor,
                        argMap( a("name", "filterPresenceXminus4"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                        "lockSensorXminus4" (SimuClampLockSensor,
                        argMap( a("name", "lockSensorXminus4"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),                                                  
                        ))
                    
                        "thermometerXminus4" (SimuThermometer,
                        argMap( a("name", "thermometerXminus4"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                   
                    
                }
                //-------------------------
                // END clampXminus description
                
                //-------------------------
                // BEGIN clampXplus description
                "clampXplus4" (SimuCarouselClamp,
                    argMap( a("name", "clampXplus4"),
                        anInt("tickMillis",5000),
                        aRef("filterPresenceSensor","filterPresenceXplus4"),
                        aRef("lockSensor", "lockSensorXplus4"),
                        aRef("thermometer", "thermometerXplus4"),
                        
                        anInt("filterPresenceValueA", 1355, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                        anInt("filterPresenceValueB", 10500, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                        anInt("filterPresenceValueC", 32000, [description:"above valueC, there is NOFILTER",constraints:0..32768] ),
                        anInt("filterPresenceOffset", 0, [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),
                        
                        anInt("lockSensorValueA", 6000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                        anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                        anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                        anInt("lockSensorOffset", 0, [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),
                        
                        anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                        anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),
                        
                        anInt("currentToUnlock", 1500),
                        anInt("currentToMaintainUnlocked", 200),
                    ))
                
                {
                        "filterPresenceXplus4" (SimuClampFilterPresenceSensor,
                        argMap( a("name", "filterPresenceXplus4"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                        "lockSensorXplus4" (SimuClampLockSensor,
                        argMap( a("name", "lockSensorXplus4"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                        "thermometerXplus4" (SimuThermometer,
                        argMap( a("name", "thermometerXplus4"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                }
                //-------------------------
                // END clampXplus description
                
            } // END carouselSocket /*SOCKET4*/ description
        /**********************************************************************/
        /*DO NOT MODIFY socket description in file carousel__simulation.groovy*/
        /*MODIFY socket description in socket__simulation_model.groovy        */
        /**********************************************************************/
        /*SOCKET5*/
        "socket5" ( SimuCarouselSocket,
                argMap(a("name", "socket5"),
                    anInt("tickMillis",5000),
                    aRef("clampXminus", "clampXminus5"),
                    aRef("clampXplus", "clampXplus5"),
                    aDbl("positionOnCarousel", positionOnCarouselSocket5),
                    aDbl("standbyPosition", standbyPositionSocket5)
                ))
            
            {   
                //-------------------------
                // BEGIN clampXminus description
                "clampXminus5" (SimuCarouselClampXminus,
                    argMap( a("name", "clampXminus5"),
                        anInt("tickMillis",5000),
                        aRef("filterPresenceSensor","filterPresenceXminus5"),
                        aRef("lockSensor", "lockSensorXminus5"),
                        aRef("thermometer", "thermometerXminus5"),
                        
                        anInt("filterPresenceValueA", 1500, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                        anInt("filterPresenceValueB", 24400, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                        anInt("filterPresenceValueC", 32000 , [description:"above valueC, there is NOFILTER",constraints:0..32768]),
                        anInt("filterPresenceOffset", 0 , [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),
                        
                        anInt("lockSensorValueA", 5000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                        anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                        anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                        anInt("lockSensorOffset", 0 , [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),
                        
                        anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                        anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),
                        
                        anInt("currentToUnlock", 1500),
                        anInt("currentToMaintainUnlocked", 200),
                    ))
                {
                        "filterPresenceXminus5" (SimuClampFilterPresenceSensor,
                        argMap( a("name", "filterPresenceXminus5"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                        "lockSensorXminus5" (SimuClampLockSensor,
                        argMap( a("name", "lockSensorXminus5"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),                                                  
                        ))
                    
                        "thermometerXminus5" (SimuThermometer,
                        argMap( a("name", "thermometerXminus5"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                   
                    
                }
                //-------------------------
                // END clampXminus description
                
                //-------------------------
                // BEGIN clampXplus description
                "clampXplus5" (SimuCarouselClamp,
                    argMap( a("name", "clampXplus5"),
                        anInt("tickMillis",5000),
                        aRef("filterPresenceSensor","filterPresenceXplus5"),
                        aRef("lockSensor", "lockSensorXplus5"),
                        aRef("thermometer", "thermometerXplus5"),
                        
                        anInt("filterPresenceValueA", 1355, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                        anInt("filterPresenceValueB", 10500, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                        anInt("filterPresenceValueC", 32000, [description:"above valueC, there is NOFILTER",constraints:0..32768] ),
                        anInt("filterPresenceOffset", 0, [description:"an offset in the range of values for the filter presence sensor",constraints:0..32768]),
                        
                        anInt("lockSensorValueA", 6000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                        anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                        anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                        anInt("lockSensorOffset", 0, [description:"an offset in the range of values for the lock sensor",constraints:0..32768]),
                        
                        anInt("timeoutForUnlocking", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                        anInt("timeoutForReleasing", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),
                        
                        anInt("currentToUnlock", 1500),
                        anInt("currentToMaintainUnlocked", 200),
                    ))
                
                {
                        "filterPresenceXplus5" (SimuClampFilterPresenceSensor,
                        argMap( a("name", "filterPresenceXplus5"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                        "lockSensorXplus5" (SimuClampLockSensor,
                        argMap( a("name", "lockSensorXplus5"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                        "thermometerXplus5" (SimuThermometer,
                        argMap( a("name", "thermometerXplus5"),
                            anInt("tickMillis",1000),
                            //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                        ))
                    
                    
                }
                //-------------------------
                // END clampXplus description
                
            } // END carouselSocket /*SOCKET5*/ description
    }//end description of carousel's children
    //END Carousel description
    // ------------------------
    
}    // main
