/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;

public class FcsUtils {
    public static final int MAX_VALUE_2BYTES = 65535;
    public static final int MAX_NODE_ID = 127;

    public static StatusDataPublishedByHardware createStatusDataPublishedByHardware(PieceOfHardware device) {
        StatusDataPublishedByHardware status = new StatusDataPublishedByHardware(device.getName(), device.isBooted(), device.isInitialized());
        return status;
    }

    public static StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController(EPOSController ctlr) {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController();
        status.setName(ctlr.getName());
        status.setBooted(ctlr.isBooted());
        status.setInitialized(ctlr.isInitialized());
        status.setEnabled(ctlr.isEnabledToPublish());
        status.setInError(ctlr.isInError());
        status.setErrorRegister(ctlr.getErrorRegister());
        status.setErrorHistory(ctlr.getErrorHistory());
        status.setMode(ctlr.getModeInString());
        return status;
    }

    public static String binaryToHex(String bin) {
        int binaryToInt = Integer.parseInt(bin, 2);
        return Integer.toHexString(binaryToInt);
    }

    public static String hexToBinary(String Hex) {
        int integer = Integer.parseInt(Hex, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%08d", Integer.parseInt(bin));
    }

    public static String twoBytesInHexaToBinary(String twoBytesInHexa) {
        int integer = Integer.parseInt(twoBytesInHexa, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%016d", Long.parseLong(bin));
    }

    public static String replaceDigit(String twoBytesInHexa, int bitPosition, String digit) {
        if (bitPosition < 0 || bitPosition > 15) {
            throw new IllegalArgumentException("replaceDigit:  bitPosition must be: 0< bitPosition <15");
        }
        if (!digit.equals("0") && !digit.equals("1")) {
            throw new IllegalArgumentException("replaceDigit:  digit must 0 or 1");
        }
        StringBuilder bin = new StringBuilder(FcsUtils.twoBytesInHexaToBinary(twoBytesInHexa));
        bin.replace(15 - bitPosition, 15 - bitPosition + 1, digit);
        return Integer.toHexString(Integer.parseInt(bin.toString(), 2));
    }

    public static String force2zero(String hexaVal, int pos) {
        if (pos < 0 || pos > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : 0<= bit <= 15", pos));
        }
        int intVal = Integer.parseInt(hexaVal, 16);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append('1');
        }
        sb.setCharAt(16 - (pos + 1), '0');
        int mask = Integer.parseInt(sb.toString(), 2);
        int myNewVal = intVal & mask;
        return Integer.toHexString(myNewVal);
    }

    public static String force2one(String hexaVal, int pos) {
        if (pos < 0 || pos > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : 0<= bit <= 15", pos));
        }
        int intVal = Integer.parseInt(hexaVal, 16);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append('0');
        }
        sb.setCharAt(16 - (pos + 1), '1');
        int mask = Integer.parseInt(sb.toString(), 2);
        int myNewVal = intVal | mask;
        return Integer.toHexString(myNewVal);
    }

    public static int[] toReverseBinary(int decimal) {
        int[] tab = new int[16];
        for (int i = 0; i < 16; ++i) {
            int bit;
            tab[i] = bit = decimal >> i & 1;
        }
        return tab;
    }
}

