/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench.LPC;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.testbench.CanOpenLED;
import org.lsst.ccs.subsystems.fcs.testbench.LPC.HygrometrySensor;
import org.lsst.ccs.subsystems.fcs.testbench.LPC.LPCInclinometerModule;
import org.lsst.ccs.subsystems.fcs.testbench.LPC.PressureSensor;
import org.lsst.ccs.subsystems.fcs.testbench.LPC.Scale1ProtoPivotingFrame;

public class Scale1ProtoTestBenchMainModule
extends MainModule {
    private final HygrometrySensor hygrometrySensor;
    private final PressureSensor pressureSensor;
    private final Thermometer thermometer;
    private final Scale1ProtoPivotingFrame pivotingFrame;
    private final LPCInclinometerModule inclinometer;
    private final CanOpenLED led;
    private final CanOpenLED fakeLed;
    private final Thermometer fakeSensor;
    public double temperature;
    public double pressure;
    public double hygrometry;

    public Scale1ProtoTestBenchMainModule(String aName, int aTickMillis, BridgeToHardware bridge, HygrometrySensor hygrometrySensor, PressureSensor pressureSensor, Thermometer thermometer, CanOpenLED led, CanOpenLED fakeLed, Thermometer fakeSensor, Scale1ProtoPivotingFrame pivotingFrame, LPCInclinometerModule inclinometer) {
        super(aName, aTickMillis, bridge);
        this.hygrometrySensor = hygrometrySensor;
        this.pressureSensor = pressureSensor;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
        this.pivotingFrame = pivotingFrame;
        this.inclinometer = inclinometer;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read hygrometry on the gauge and returns its values in decimal format.")
    public double readHygrometry() throws FcsHardwareException {
        this.hygrometry = this.hygrometrySensor.readHygrometry();
        return this.hygrometry;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read pressure on the gauge and returns its values in decimal format.")
    public double readPressure() throws FcsHardwareException {
        this.pressure = this.pressureSensor.readPressure();
        return this.pressure;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read temperature on the gauge and returns its values in decimal format.")
    public double readTemperature() throws FcsHardwareException {
        this.temperature = this.thermometer.readTemperature();
        return this.temperature;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Turn On the led.")
    public String turnOnLED() throws SDORequestException, HardwareNotDetectedException, FcsHardwareException {
        return this.led.turnON();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Turn Off the led.")
    public String turnOffLED() throws SDORequestException, HardwareNotDetectedException, FcsHardwareException {
        return this.led.turnOFF();
    }

    public String turnOnFakeLED() throws SDORequestException, HardwareNotDetectedException, FcsHardwareException {
        return this.fakeLed.turnON();
    }

    public String turnOffFakeLED() throws SDORequestException, HardwareNotDetectedException, FcsHardwareException {
        return this.fakeLed.turnOFF();
    }

    public double readFakeSensor() throws FcsHardwareException, BadCommandException {
        return this.fakeSensor.readTemperature();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate camera around axe Z with angle value given as argument.")
    public void rotateCamera(long angle) {
        this.pivotingFrame.rotateCamera(angle);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate camera around axe X with angle value given as argument.")
    public void rotateX(long angle) {
        this.pivotingFrame.rotateX(angle);
    }

    public void tick() {
        try {
            this.readTemperature();
            this.readPressure();
            this.readHygrometry();
            this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("temperature", (Serializable)Double.valueOf(this.temperature)));
            this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("hygrometry", (Serializable)Double.valueOf(this.hygrometry)));
            this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("pressure", (Serializable)Double.valueOf(this.pressure)));
        }
        catch (FcsHardwareException ex) {
            FCSCst.FCSLOG.debug((Object)(this.name + " couldn't read sensors " + (Object)((Object)ex)));
        }
    }

    @Override
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
    }
}

