/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench.LPC;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.testbench.LPC.CanOpenDigitaxVariator;

public class Scale1ProtoPivotingFrame
extends MobileItemModule {
    private CanOpenDigitaxVariator variatorX;
    private CanOpenDigitaxVariator variatorZ;
    private double angleXToReach;
    private double angleZToReach;
    private double actualXAngle;
    private double actualZAngle;

    public Scale1ProtoPivotingFrame(String moduleName, int aTickMillis) {
        super(moduleName, aTickMillis);
    }

    @Override
    public void initModule() {
        this.variatorX = (CanOpenDigitaxVariator)this.getComponentByName("variatorX");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean isHardwareReady() {
        return ((MainModule)((Object)this.getComponentByName("main"))).isHardwareReady();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        return Double.doubleToRawLongBits(this.actualXAngle) == Double.doubleToRawLongBits(this.angleXToReach);
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String goToHome() {
        return this.name + " is at Home Position.";
    }

    public String rotateX(long angle) {
        return this.name + " has rotated at requested angle: " + angle;
    }

    public String rotateCamera(long angle) {
        return this.name + " has rotated";
    }

    @Override
    public void publishData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

